/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.validator;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.conditiontestpanel.ConditionTester;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.plugin.core.analysis.validator.PostAnalysisValidator;
import ghidra.app.plugin.core.validator.ValidateProgramDialog;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@PluginInfo(status=PluginStatus.UNSTABLE, packageName="Ghidra Core", category="Analysis", shortDescription="Validates program analysis", description="This plugin provides an action that displays a dialog to run post-analysis validation tests on a program")
public class ValidateProgramPlugin
extends Plugin {
    public static final String PLUGIN_NAME = "ValidateProgramPlugin";
    public static final String ACTION_NAME = "Validate Program";
    private DockingAction validateAction;

    public ValidateProgramPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.setupActions();
    }

    public void dispose() {
        this.tool.removeAction((DockingActionIf)this.validateAction);
        this.validateAction.dispose();
        super.dispose();
    }

    private void setupActions() {
        this.validateAction = new ProgramContextAction(ACTION_NAME, PLUGIN_NAME){

            @Override
            public void actionPerformed(ProgramActionContext context) {
                Program program = context.getProgram();
                ValidateProgramPlugin.this.validate(program);
            }

            @Override
            public boolean isEnabledForContext(ActionContext context) {
                if (!super.isEnabledForContext(context)) {
                    this.getMenuBarData().setMenuItemName(ValidateProgramPlugin.ACTION_NAME);
                    return false;
                }
                return true;
            }

            @Override
            public boolean isEnabledForContext(ProgramActionContext context) {
                Program program = context.getProgram();
                String menuName = "Validate " + program.getDomainFile().getName();
                this.getMenuBarData().setMenuItemName(menuName);
                return true;
            }
        };
        this.validateAction.addToWindowWhen(ListingActionContext.class);
        this.validateAction.setMenuBarData(new MenuData(new String[]{"&Analysis", ACTION_NAME}, null, "ZZZ"));
        this.validateAction.setEnabled(false);
        this.validateAction.setHelpLocation(new HelpLocation("ValidateProgram", "top_of_page"));
        this.validateAction.setDescription(this.getPluginDescription().getDescription());
        this.tool.addAction((DockingActionIf)this.validateAction);
    }

    private void validate(Program program) {
        List<ConditionTester> list = this.getConditionTests(program);
        Collections.sort(list, new ConditionsComparator(this));
        ValidateProgramDialog dialog = new ValidateProgramDialog(program, list);
        this.tool.showDialog((DialogComponentProvider)dialog);
    }

    private List<ConditionTester> getConditionTests(Program program) {
        ArrayList<ConditionTester> list = new ArrayList<ConditionTester>();
        List validatorClasses = ClassSearcher.getClasses(PostAnalysisValidator.class);
        for (Class validatorClass : validatorClasses) {
            try {
                Constructor ctor = validatorClass.getConstructor(Program.class);
                PostAnalysisValidator validator = (PostAnalysisValidator)ctor.newInstance(program);
                list.add(validator);
            }
            catch (Exception e) {
                Msg.error((Object)((Object)this), (Object)("error including PostAnalysisValidator " + String.valueOf(validatorClass)), (Throwable)e);
            }
        }
        return list;
    }

    private class ConditionsComparator
    implements Comparator<ConditionTester> {
        private ConditionsComparator(ValidateProgramPlugin validateProgramPlugin) {
        }

        @Override
        public int compare(ConditionTester o1, ConditionTester o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

