/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.vscode;

import ghidra.app.services.VSCodeIntegrationService;
import ghidra.framework.Application;
import ghidra.util.SystemUtilities;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

class VSCodeLauncherTask
extends Task {
    private VSCodeIntegrationService vscodeService;
    private File file;

    public VSCodeLauncherTask(VSCodeIntegrationService vscodeService, File file) {
        super("Visual Studio Code Launcher Task", true, true, true);
        this.vscodeService = vscodeService;
        this.file = file;
    }

    public void run(TaskMonitor monitor) {
        File vscodeExecutableFile;
        if (SystemUtilities.isInDevelopmentMode()) {
            this.vscodeService.handleVSCodeError("Launching Visual Studio Code is not supported in development mode.", false, null);
            return;
        }
        try {
            vscodeExecutableFile = this.vscodeService.getVSCodeExecutableFile();
        }
        catch (IOException e1) {
            this.vscodeService.handleVSCodeError(e1.getMessage(), true, null);
            try {
                vscodeExecutableFile = this.vscodeService.getVSCodeExecutableFile();
            }
            catch (IOException e2) {
                this.vscodeService.handleVSCodeError("Failed to launch Visual Studio Code.  The required Visual Studio Code components have not been configured.", false, null);
                return;
            }
        }
        File vscodeSettingsDir = new File(Application.getUserSettingsDirectory(), "vscode");
        File workspaceFile = new File(vscodeSettingsDir, "ghidra_scripts.code-workspace");
        try {
            this.vscodeService.addToVSCodeWorkspace(workspaceFile, this.file.getParentFile());
        }
        catch (IOException e) {
            this.vscodeService.handleVSCodeError("Failed to create Visual Studio Code workspace.", false, e);
            return;
        }
        monitor.setIndeterminate(true);
        monitor.setMessage("Launching Visual Studio Code...");
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(vscodeExecutableFile.getAbsolutePath());
            args.add("-a");
            args.add(workspaceFile.getAbsolutePath());
            args.add(this.file.getAbsolutePath());
            new ProcessBuilder(args).redirectErrorStream(true).start();
        }
        catch (Exception e) {
            this.vscodeService.handleVSCodeError("Unexpected exception occurred while launching Visual Studio Code.", false, null);
            return;
        }
    }
}

