/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.sections;

import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.sections.AbstractFrameSection;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.Cie;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.ExceptionHandlerFrameException;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.FrameDescriptionEntry;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DebugFrameSection
extends AbstractFrameSection {
    public static final String DEBUG_FRAME_BLOCK_NAME = ".debug_frame";

    public DebugFrameSection(TaskMonitor monitor, Program program) {
        super(monitor, program);
    }

    @Override
    public Cie getCie(Address currAddress) throws MemoryAccessException, ExceptionHandlerFrameException {
        return this.getCieOrCreateIfMissing(currAddress, true);
    }

    public List<RegionDescriptor> analyze() throws MemoryAccessException, AddressOutOfBoundsException, ExceptionHandlerFrameException, CancelledException {
        ArrayList<RegionDescriptor> descriptors = new ArrayList<RegionDescriptor>();
        MemoryBlock[] blocks = this.program.getMemory().getBlocks();
        int blockCount = blocks.length;
        this.monitor.setMaximum((long)blockCount);
        for (MemoryBlock block : blocks) {
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
            if (!block.getName().startsWith(DEBUG_FRAME_BLOCK_NAME)) continue;
            descriptors.addAll(this.analyzeSection(block));
        }
        return Collections.unmodifiableList(descriptors);
    }

    private List<RegionDescriptor> analyzeSection(MemoryBlock curMemBlock) throws MemoryAccessException, AddressOutOfBoundsException, ExceptionHandlerFrameException {
        this.monitor.setMessage("Analyzing " + curMemBlock.getName() + " section");
        this.monitor.setShowProgressValue(true);
        this.monitor.setIndeterminate(false);
        ProgramLocation loc = new ProgramLocation(this.program, curMemBlock.getStart());
        Address curAddress = loc.getAddress();
        ArrayList<RegionDescriptor> regions = new ArrayList<RegionDescriptor>();
        if (curAddress != null) {
            this.monitor.setMaximum(curMemBlock.getEnd().subtract(curAddress));
        }
        while (curAddress != null && curAddress.compareTo((Object)curMemBlock.getEnd()) < 0) {
            if (this.monitor.isCancelled()) {
                return regions;
            }
            Cie cie = this.getCie(curAddress);
            if (cie.isEndOfFrame()) break;
            curAddress = cie.getNextAddress();
            ArrayList<RegionDescriptor> newRegions = new ArrayList<RegionDescriptor>();
            while (curAddress != null && curAddress.compareTo((Object)curMemBlock.getEnd()) < 0) {
                this.monitor.setProgress(curAddress.subtract(loc.getAddress()));
                Address currFdeAddr = curAddress;
                try {
                    FrameDescriptionEntry fde = new FrameDescriptionEntry(this.monitor, this.program, this);
                    RegionDescriptor region = fde.create(curAddress);
                    if (fde.isEndOfFrame()) break;
                    if (region != null) {
                        newRegions.add(region);
                        this.createFdeComment(curAddress);
                    }
                    curAddress = fde.getNextAddress();
                }
                catch (ExceptionHandlerFrameException efe) {
                    curAddress = currFdeAddr;
                    break;
                }
            }
            this.createAugmentationData(newRegions, cie);
            regions.addAll(newRegions);
        }
        return regions;
    }
}

