/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.sections;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecodeContext;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecoderFactory;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.ExceptionHandlerFrameException;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.ExceptionHandlerFrameHeader;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.FdeTable;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.ProgramLocation;
import ghidra.util.task.TaskMonitor;

public class EhFrameHeaderSection {
    public static final String EH_FRAME_HEADER_BLOCK_NAME = ".eh_frame_hdr";
    private Program program;

    public EhFrameHeaderSection(Program program) {
        this.program = program;
    }

    public int analyze(TaskMonitor monitor) throws MemoryAccessException, AddressOutOfBoundsException, ExceptionHandlerFrameException {
        MemoryBlock memBlock = this.program.getMemory().getBlock(EH_FRAME_HEADER_BLOCK_NAME);
        if (memBlock != null && !monitor.isCancelled()) {
            return this.analyzeSection(memBlock, monitor);
        }
        return 0;
    }

    private int analyzeSection(MemoryBlock curMemBlock, TaskMonitor monitor) throws MemoryAccessException, AddressOutOfBoundsException, ExceptionHandlerFrameException {
        monitor.setMessage("Analyzing .eh_frame_hdr section");
        ProgramLocation loc = new ProgramLocation(this.program, curMemBlock.getStart());
        Address curAddress = loc.getAddress();
        ExceptionHandlerFrameHeader eh_frame_hdr = new ExceptionHandlerFrameHeader(monitor, this.program);
        eh_frame_hdr.addToDataTypeManager();
        eh_frame_hdr.create(curAddress);
        curAddress = curAddress.add((long)eh_frame_hdr.getLength());
        curAddress = this.processEncodedFramePointer(curAddress, eh_frame_hdr, curMemBlock);
        DwarfEHDecoder fdeCountDecoder = this.getFdeCountDecoder(eh_frame_hdr);
        Address fdeCountAddress = curAddress;
        curAddress = this.markupEncodedFdeCount(fdeCountAddress, fdeCountDecoder);
        int fdeTableCnt = this.getFdeTableCount(fdeCountAddress, curMemBlock, fdeCountDecoder);
        if (fdeTableCnt > 0) {
            this.createFdeTable(curAddress, eh_frame_hdr, fdeTableCnt, monitor);
        }
        return fdeTableCnt;
    }

    private Address markupEncodedFdeCount(Address curAddress, DwarfEHDecoder fdeDecoder) throws MemoryAccessException {
        DwarfDecodeContext ctx = new DwarfDecodeContext(this.program, curAddress);
        long unused = fdeDecoder.decode(ctx);
        DataType encDataType = fdeDecoder.getDataType(this.program);
        CreateDataCmd dataCmd = new CreateDataCmd(curAddress, encDataType);
        dataCmd.applyTo(this.program);
        SetCommentCmd commentCmd = new SetCommentCmd(curAddress, CommentType.EOL, "Encoded FDE count");
        commentCmd.applyTo(this.program);
        curAddress = curAddress.add((long)ctx.getEncodedLength());
        return curAddress;
    }

    private DwarfEHDecoder getFdeCountDecoder(ExceptionHandlerFrameHeader eh_frame_hdr) {
        int fdeCntEnc = eh_frame_hdr.getEh_FrameDescEntryCntEncoding();
        DwarfEHDecoder fdeDecoder = DwarfDecoderFactory.getDecoder(fdeCntEnc);
        return fdeDecoder;
    }

    private Address processEncodedFramePointer(Address curAddress, ExceptionHandlerFrameHeader eh_frame_hdr, MemoryBlock curMemBlock) throws MemoryAccessException {
        DwarfEHDecoder frmPtrDecoder = DwarfDecoderFactory.getDecoder(eh_frame_hdr.getEh_FramePtrEncoding());
        DwarfDecodeContext ctx = new DwarfDecodeContext(this.program, curAddress, curMemBlock);
        Address frmPtrAddr = frmPtrDecoder.decodeAddress(ctx);
        this.program.getReferenceManager().addMemoryReference(curAddress, frmPtrAddr, RefType.DATA, SourceType.ANALYSIS, 0);
        DataType frmPtrDataType = frmPtrDecoder.getDataType(this.program);
        CreateDataCmd dataCmd = new CreateDataCmd(curAddress, frmPtrDataType);
        dataCmd.applyTo(this.program);
        SetCommentCmd commentCmd = new SetCommentCmd(curAddress, CommentType.EOL, "Encoded eh_frame_ptr");
        commentCmd.applyTo(this.program);
        curAddress = curAddress.add((long)ctx.getEncodedLength());
        return curAddress;
    }

    private int getFdeTableCount(Address countAddress, MemoryBlock curMemBlock, DwarfEHDecoder fdeDecoder) throws MemoryAccessException {
        DwarfDecodeContext context = new DwarfDecodeContext(this.program, countAddress, curMemBlock);
        int fdeTableCnt = (int)fdeDecoder.decode(context);
        return fdeTableCnt;
    }

    private void createFdeTable(Address curAddress, ExceptionHandlerFrameHeader eh_frame_hdr, int fdeTableCnt, TaskMonitor monitor) throws MemoryAccessException, ExceptionHandlerFrameException {
        int fdeTblEnc = eh_frame_hdr.getEh_FrameTableEncoding();
        DwarfEHDecoder fdeTblDecoder = DwarfDecoderFactory.getDecoder(fdeTblEnc);
        FdeTable fde_table = new FdeTable(monitor, this.program);
        fde_table.create(curAddress, fdeTblDecoder, fdeTableCnt);
        SetCommentCmd commentCmd = new SetCommentCmd(curAddress, CommentType.PLATE, "Frame Description Entry Table");
        commentCmd.applyTo(this.program);
    }
}

