/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.tablechooser;

import docking.DialogComponentProvider;
import docking.action.DockingActionIf;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableSortState;
import docking.widgets.table.threaded.ThreadedTableModel;
import generic.theme.GThemeDefaults;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.services.GoToService;
import ghidra.app.tablechooser.AddressableRowObject;
import ghidra.app.tablechooser.ColumnDisplay;
import ghidra.app.tablechooser.TableChooserExecutor;
import ghidra.app.tablechooser.TableChooserTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableCellRenderer;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import utility.function.Callback;

public class TableChooserDialog
extends DialogComponentProvider
implements NavigatableRemovalListener {
    private WeakSet<ExecutorSwingWorker> workers = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private Set<AddressableRowObject> sharedPending = ConcurrentHashMap.newKeySet();
    private final TableChooserExecutor executor;
    private WrappingCellRenderer wrappingRenderer = new WrappingCellRenderer();
    private GhidraTable table;
    private TableChooserTableModel model;
    private final Program program;
    private final PluginTool tool;
    private Navigatable navigatable;
    private Callback closedCallback = Callback.dummy();

    public TableChooserDialog(PluginTool tool, TableChooserExecutor executor, Program program, String title, Navigatable navigatable, boolean isModal) {
        super(title, isModal, true, true, true);
        this.tool = tool;
        this.executor = executor;
        this.program = program;
        this.navigatable = navigatable;
        this.addWorkPanel(this.buildMainPanel());
        if (executor != null) {
            this.addOKButton();
            this.setOkButtonText(executor.getButtonName());
        }
        this.addDismissButton();
        this.createActions();
        this.setOkEnabled(false);
    }

    public TableChooserDialog(PluginTool tool, TableChooserExecutor executor, Program program, String title, Navigatable navigatable) {
        this(tool, executor, program, title, navigatable, false);
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.createTableModel();
        TableChooserDialogPanel tablePanel = new TableChooserDialogPanel(this.model);
        tablePanel.getAccessibleContext().setAccessibleName("Table Dialog");
        this.table = tablePanel.getTable();
        this.table.setAccessibleNamePrefix("Chooser");
        this.table.setToolTipText("Table of choices for " + this.getTitle());
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        if (goToService != null) {
            this.navigatable = this.navigatable == null ? goToService.getDefaultNavigatable() : this.navigatable;
            this.navigatable.addNavigatableListener(this);
            this.table.installNavigation((ServiceProvider)this.tool, this.navigatable);
        }
        this.table.getSelectionModel().addListSelectionListener(e -> this.setOkEnabled(this.table.getSelectedRowCount() > 0));
        GhidraTableFilterPanel filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.model);
        filterPanel.getAccessibleContext().setAccessibleName("Dialog");
        panel.add((Component)((Object)tablePanel), "Center");
        panel.add((Component)((Object)filterPanel), "South");
        panel.getAccessibleContext().setAccessibleName("Table Chooser");
        return panel;
    }

    public void setClosedListener(Callback callback) {
        Swing.runNow(() -> {
            this.closedCallback = Callback.dummyIfNull((Callback)callback);
            return this.closedCallback;
        });
    }

    public void add(AddressableRowObject rowObject) {
        this.model.addObject(rowObject);
    }

    public void remove(AddressableRowObject rowObject) {
        this.model.removeObject(rowObject);
    }

    public boolean contains(AddressableRowObject rowObject) {
        return this.model.containsObject(rowObject);
    }

    private void createTableModel() {
        Swing.runNow(() -> {
            this.model = new TableChooserTableModel("Test", (ServiceProvider)this.tool, this.program, null);
            return this.model;
        });
    }

    private void createActions() {
        String owner = this.getClass().getSimpleName();
        MakeProgramSelectionAction selectAction = new MakeProgramSelectionAction(this.navigatable, owner, this.table);
        SelectionNavigationAction selectionNavigationAction = new SelectionNavigationAction(owner, this.table);
        selectionNavigationAction.setHelpLocation(new HelpLocation("Search", "Selection_Navigation"));
        this.addAction((DockingActionIf)selectAction);
        this.addAction((DockingActionIf)selectionNavigationAction);
    }

    public void show() {
        this.tool.showDialog((DialogComponentProvider)this);
    }

    public void close() {
        super.close();
        if (this.navigatable != null) {
            this.navigatable.removeNavigatableListener(this);
        }
        this.dispose();
    }

    protected void dialogClosed() {
        this.closedCallback.call();
    }

    protected void okCallback() {
        List<AddressableRowObject> rowObjects = this.getSelectedRowObjects();
        rowObjects.removeAll(this.sharedPending);
        if (rowObjects.isEmpty()) {
            return;
        }
        this.clearSelection();
        this.sharedPending.addAll(rowObjects);
        TaskMonitorComponent monitor = this.getTaskMonitorComponent();
        ExecutorSwingWorker worker = new ExecutorSwingWorker(rowObjects, (TaskMonitor)monitor);
        this.workers.add((Object)worker);
        this.showProgressBar("Working", true, true, 0);
        worker.execute();
    }

    private void workerDone(ExecutorSwingWorker worker) {
        this.workers.remove((Object)worker);
        if (this.workers.isEmpty()) {
            this.hideTaskMonitorComponent();
        }
    }

    public boolean isBusy() {
        for (ExecutorSwingWorker worker : this.workers) {
            if (worker.isDone()) continue;
            return true;
        }
        return this.model.isBusy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(List<AddressableRowObject> rowObjects, TaskMonitor monitor) {
        monitor.initialize((long)rowObjects.size());
        try {
            List<AddressableRowObject> deleted = this.doProcessRowsInTransaction(rowObjects, monitor);
            if (monitor.isCancelled()) {
                return;
            }
            for (AddressableRowObject rowObject : deleted) {
                this.model.removeObject(rowObject);
            }
        }
        finally {
            this.sharedPending.removeAll(rowObjects);
            this.model.fireTableDataChanged();
            this.setStatusText("");
        }
    }

    private List<AddressableRowObject> doProcessRows(List<AddressableRowObject> rowObjects, TaskMonitor monitor) {
        ArrayList<AddressableRowObject> deleted = new ArrayList<AddressableRowObject>();
        if (this.executor.executeInBulk(rowObjects, deleted, monitor)) {
            return deleted;
        }
        for (AddressableRowObject rowObject : rowObjects) {
            if (monitor.isCancelled()) break;
            if (!this.model.containsObject(rowObject)) {
                monitor.incrementProgress(1L);
                continue;
            }
            monitor.setMessage("Processing item at address " + String.valueOf(rowObject.getAddress()));
            if (this.executor.execute(rowObject)) {
                deleted.add(rowObject);
            }
            monitor.incrementProgress(1L);
            this.table.repaint();
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AddressableRowObject> doProcessRowsInTransaction(List<AddressableRowObject> rowObjects, TaskMonitor monitor) {
        int tx = this.program.startTransaction("Table Chooser: " + this.getTitle());
        try {
            List<AddressableRowObject> list = this.doProcessRows(rowObjects, monitor);
            return list;
        }
        finally {
            this.program.endTransaction(tx, true);
        }
    }

    public void addCustomColumn(ColumnDisplay<?> columnDisplay) {
        Swing.runNow(() -> this.model.addCustomColumn(columnDisplay));
    }

    public void setSortColumn(int index) {
        this.setSortState(TableSortState.createDefaultSortState((int)index));
    }

    public void setSortState(TableSortState state) {
        AtomicReference ref = new AtomicReference();
        Swing.runNow(() -> {
            try {
                this.model.setTableSortState(state);
            }
            catch (IllegalArgumentException e) {
                ref.set(e);
            }
        });
        IllegalArgumentException exception = (IllegalArgumentException)ref.get();
        if (exception != null) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    public void navigatableRemoved(Navigatable nav) {
        this.close();
    }

    public void setMessage(String message) {
        this.setStatusText(message);
    }

    public GhidraTable getTable() {
        return this.table;
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public void clearSelection() {
        Swing.runNow(() -> this.table.clearSelection());
    }

    public void selectRows(int ... rows) {
        Swing.runNow(() -> {
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            for (int row : rows) {
                selectionModel.addSelectionInterval(row, row);
            }
        });
    }

    public int[] getSelectedRows() {
        int[] selectedRows = this.table.getSelectedRows();
        return selectedRows;
    }

    public List<AddressableRowObject> getSelectedRowObjects() {
        int[] selectedRows = this.table.getSelectedRows();
        List rowObjects = this.model.getRowObjects(selectedRows);
        return rowObjects;
    }

    public void dispose() {
        this.table.dispose();
        this.workers.forEach(w -> w.cancel(true));
        super.dispose();
    }

    private class WrappingCellRenderer
    extends GhidraTableCellRenderer {
        private Color pendingColor = GThemeDefaults.Colors.Palette.LIGHT_GRAY;
        private TableCellRenderer delegate;

        private WrappingCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component renderer = this.delegate == null ? super.getTableCellRendererComponent(data) : (this.delegate instanceof GTableCellRenderer ? ((GTableCellRenderer)this.delegate).getTableCellRendererComponent(data) : this.delegate.getTableCellRendererComponent(data.getTable(), data.getValue(), data.isSelected(), data.hasFocus(), data.getRowViewIndex(), data.getColumnViewIndex()));
            AddressableRowObject ro = (AddressableRowObject)data.getRowObject();
            if (TableChooserDialog.this.sharedPending.contains(ro)) {
                renderer.setBackground(this.pendingColor);
                renderer.setForeground(data.getTable().getSelectionForeground());
                renderer.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
            }
            return renderer;
        }

        void setDelegate(TableCellRenderer delegate) {
            this.delegate = delegate;
        }
    }

    private class TableChooserDialogPanel
    extends GhidraThreadedTablePanel<AddressableRowObject> {
        public TableChooserDialogPanel(ThreadedTableModel<AddressableRowObject, ?> model) {
            super(model, 50, 2000);
        }

        @Override
        protected GTable createTable(ThreadedTableModel<AddressableRowObject, ?> tm) {
            return new TableChooserDialogGhidraTable(tm);
        }
    }

    private class ExecutorSwingWorker
    extends SwingWorker<Object, Object> {
        private final TaskMonitor monitor;
        private List<AddressableRowObject> rowObjects;

        ExecutorSwingWorker(List<AddressableRowObject> rowObjects, TaskMonitor monitor) {
            this.rowObjects = rowObjects;
            this.monitor = monitor;
        }

        @Override
        protected Object doInBackground() throws Exception {
            TableChooserDialog.this.doExecute(this.rowObjects, this.monitor);
            return null;
        }

        @Override
        protected void done() {
            TableChooserDialog.this.workerDone(this);
        }

        public String toString() {
            return this.rowObjects.toString();
        }
    }

    private class TableChooserDialogGhidraTable
    extends GhidraTable {
        public TableChooserDialogGhidraTable(ThreadedTableModel<AddressableRowObject, ?> tm) {
            super((TableModel)tm);
        }

        public TableCellRenderer getCellRenderer(int row, int col) {
            TableCellRenderer tableRenderer = super.getCellRenderer(row, col);
            TableChooserDialog.this.wrappingRenderer.setDelegate(tableRenderer);
            return TableChooserDialog.this.wrappingRenderer;
        }
    }
}

