/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoItab;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.GoSymbolName;
import ghidra.app.util.bin.format.golang.rtti.GoTypeManager;
import ghidra.app.util.bin.format.golang.rtti.types.GoArrayType;
import ghidra.app.util.bin.format.golang.rtti.types.GoBaseType;
import ghidra.app.util.bin.format.golang.rtti.types.GoChanType;
import ghidra.app.util.bin.format.golang.rtti.types.GoFuncType;
import ghidra.app.util.bin.format.golang.rtti.types.GoInterfaceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoKind;
import ghidra.app.util.bin.format.golang.rtti.types.GoMapType;
import ghidra.app.util.bin.format.golang.rtti.types.GoMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoPlainType;
import ghidra.app.util.bin.format.golang.rtti.types.GoPointerType;
import ghidra.app.util.bin.format.golang.rtti.types.GoSliceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructType;
import ghidra.app.util.bin.format.golang.rtti.types.GoTypeDetector;
import ghidra.app.util.bin.format.golang.rtti.types.GoUncommonType;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.FieldOutput;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.PlateComment;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.app.util.bin.format.golang.structmapping.StructureVerifier;
import ghidra.app.util.viewer.field.AddressAnnotatedStringHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Undefined;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PlateComment
public abstract class GoType
implements StructureMarkup<GoType>,
StructureVerifier {
    private static final Map<GoKind, Class<? extends GoType>> specializedTypeClasses = Map.ofEntries(Map.entry(GoKind.Struct, GoStructType.class), Map.entry(GoKind.Pointer, GoPointerType.class), Map.entry(GoKind.Func, GoFuncType.class), Map.entry(GoKind.Slice, GoSliceType.class), Map.entry(GoKind.Array, GoArrayType.class), Map.entry(GoKind.Chan, GoChanType.class), Map.entry(GoKind.Map, GoMapType.class), Map.entry(GoKind.Interface, GoInterfaceType.class));
    @ContextField
    protected GoRttiMapper programContext;
    @ContextField
    protected StructureContext<GoType> context;
    @FieldMapping(fieldName={"typ", "Type"})
    @Markup
    @FieldOutput
    protected GoBaseType typ;
    protected GoUncommonType uncommonType;

    public static Class<? extends GoType> getSpecializedTypeClass(GoRttiMapper programContext, long offset) throws IOException {
        GoTypeDetector typeDetector = programContext.readStructure(GoTypeDetector.class, offset);
        Class<? extends GoType> result = specializedTypeClasses.get((Object)typeDetector.getKind());
        if (result == null) {
            result = GoPlainType.class;
        }
        return result;
    }

    protected GoBaseType getBaseType() {
        return this.typ;
    }

    public long getTypeOffset() {
        return this.context.getStructureStart();
    }

    public String getName() {
        return this.typ.getName();
    }

    public GoSymbolName getSymbolName() {
        return GoSymbolName.parseTypeName(this.getName(), this.getPackagePathString());
    }

    public String getFullyQualifiedName() {
        return this.getSymbolName().asString();
    }

    public String getPackagePathString() {
        try {
            return this.typ.hasUncommonType() ? this.getUncommonType().getPackagePathString() : "";
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getDebugId() {
        return "%s@%s".formatted(this.context.getMappingInfo().getDescription(), this.context.getStructureAddress());
    }

    protected long getOffsetEndOfFullType() {
        return this.context.getStructureEnd() + (long)(this.typ.hasUncommonType() ? this.programContext.getStructureMappingInfo(GoUncommonType.class).getStructureLength() : 0);
    }

    public long getEndOfTypeInfo() throws IOException {
        return this.typ.hasUncommonType() ? this.getUncommonType().getEndOfTypeInfo() : this.context.getStructureEnd();
    }

    @Markup
    public GoUncommonType getUncommonType() throws IOException {
        if (this.uncommonType == null && this.typ.hasUncommonType()) {
            this.uncommonType = this.programContext.readStructure(GoUncommonType.class, this.context.getStructureEnd());
        }
        return this.uncommonType;
    }

    public List<GoMethod.GoMethodInfo> getMethodInfoList() throws IOException {
        List<GoMethod> methods;
        ArrayList<GoMethod.GoMethodInfo> results = new ArrayList<GoMethod.GoMethodInfo>();
        GoUncommonType ut = this.getUncommonType();
        if (ut != null && (methods = ut.getMethods()) != null) {
            for (GoMethod method : methods) {
                results.addAll(method.getMethodInfos(this));
            }
        }
        return results;
    }

    @Override
    public StructureContext<GoType> getStructureContext() {
        return this.context;
    }

    @Override
    public String getStructureLabel() throws IOException {
        return "%s___%s_type".formatted(this.getFullyQualifiedName(), this.typ.getKind().toString());
    }

    @Override
    public String getStructureName() throws IOException {
        return this.getFullyQualifiedName();
    }

    @Override
    public String getStructureNamespace() throws IOException {
        return this.getPackagePathString();
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException, CancelledException {
        GoUncommonType ut = this.getUncommonType();
        if (ut != null) {
            GoSlice slice = ut.getMethodsSlice();
            slice.markupArray(this.getStructureLabel() + "_methods", this.getStructureNamespace(), GoMethod.class, false, session);
            slice.markupArrayElements(GoMethod.class, session);
            session.labelStructure(ut, this.getStructureLabel() + "_uncommon", this.getStructureNamespace());
        }
    }

    protected String getImplementsInterfaceString() {
        StringBuilder sb = new StringBuilder();
        for (GoItab goItab : this.programContext.getGoTypes().getInterfacesImplementedByType(this)) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            try {
                sb.append(AddressAnnotatedStringHandler.createAddressAnnotationString(goItab.getInterfaceType().getStructureContext().getStructureAddress(), goItab.getInterfaceType().getFullyQualifiedName()));
                sb.append(" ");
                sb.append(AddressAnnotatedStringHandler.createAddressAnnotationString(goItab.getStructureContext().getStructureAddress(), "[itab]"));
            }
            catch (IOException e) {
                sb.append("unknown_interface");
            }
        }
        return sb.toString();
    }

    protected String getMethodListString() throws IOException {
        GoUncommonType ut = this.getUncommonType();
        if (ut == null || this.uncommonType.mcount == 0) {
            return "";
        }
        GoType ptrType = this.typ.getPtrToThis();
        GoSymbolName ptrSymbolName = ptrType != null ? ptrType.getSymbolName() : null;
        String ptrTypeName = ptrSymbolName != null ? ptrSymbolName.getBaseTypeName() : null;
        StringBuilder sb = new StringBuilder();
        for (GoMethod method : ut.getMethods()) {
            Address ifnAddr;
            GoFuncType funcType;
            GoType goType = method.getType();
            GoFuncType methodFuncDef = goType instanceof GoFuncType ? (funcType = (GoFuncType)goType) : null;
            Address tfnAddr = method.getTfn();
            if (tfnAddr != null) {
                String tfnStr = this.getMethodPrototypeString(method.getName(), methodFuncDef);
                sb.append(!sb.isEmpty() ? "\n" : "").append(AddressAnnotatedStringHandler.createAddressAnnotationString(tfnAddr, tfnStr));
            }
            if ((ifnAddr = method.getIfn()) != null && ptrTypeName != null) {
                String ifnStr = this.getMethodPrototypeString(ptrTypeName, method.getName(), methodFuncDef);
                sb.append(!sb.isEmpty() ? "\n" : "").append(AddressAnnotatedStringHandler.createAddressAnnotationString(ifnAddr, ifnStr));
            }
            if (tfnAddr != null || ifnAddr != null) continue;
            String methodStr = this.getMethodPrototypeString(method.getName(), methodFuncDef);
            sb.append(!sb.isEmpty() ? "\n" : "").append(methodStr);
        }
        return sb.toString();
    }

    public String getMethodPrototypeString(String methodName, GoFuncType funcdefType) {
        return this.getMethodPrototypeString(this.getSymbolName().getBaseTypeName(), methodName, funcdefType);
    }

    public String getMethodPrototypeString(String recvStr, String methodName, GoFuncType funcdefType) {
        return "func (%s) %s%s".formatted(recvStr, methodName, funcdefType != null ? funcdefType.getParamListString() : "(???) ???");
    }

    protected String getTypeDeclString() throws IOException {
        return "type " + this.typ.getName() + " " + String.valueOf((Object)this.typ.getKind());
    }

    public String toString() {
        try {
            String interfaceString;
            Object s = this.getTypeDeclString();
            String methodListString = this.getMethodListString();
            if (!methodListString.isEmpty()) {
                s = (String)s + "\n\n// Methods\n" + methodListString;
            }
            if (!(interfaceString = this.getImplementsInterfaceString()).isEmpty()) {
                s = (String)s + "\n\n// Interfaces implemented\n" + interfaceString;
            }
            return s;
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public DataType recoverDataType(GoTypeManager goTypes) throws IOException {
        DataType dt = Undefined.getUndefinedDataType((int)((int)this.typ.getSize()));
        return new TypedefDataType(goTypes.getCP(this), goTypes.getTypeName(this), dt, goTypes.getDTM());
    }

    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!discoveredTypes.add(this.context.getStructureStart())) {
            return false;
        }
        GoUncommonType ut = this.getUncommonType();
        if (ut != null) {
            for (GoMethod method : ut.getMethods()) {
                GoType methodType = method.getType();
                if (methodType == null) continue;
                methodType.discoverGoTypes(discoveredTypes);
            }
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.typ.isValid();
    }
}

