/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import java.util.EnumSet;
import java.util.Set;

public enum GoTypeFlag {
    Uncommon(1),
    ExtraStar(2),
    Named(4),
    RegularMemory(8);

    private final int value;

    private GoTypeFlag(int i) {
        this.value = i;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSet(int i) {
        return (i & this.value) != 0;
    }

    public static boolean isValid(int b) {
        return b <= 15;
    }

    public static Set<GoTypeFlag> parseFlags(int b) {
        EnumSet<GoTypeFlag> result = EnumSet.noneOf(GoTypeFlag.class);
        for (GoTypeFlag flag : GoTypeFlag.values()) {
            if (!flag.isSet(b)) continue;
            result.add(flag);
        }
        return result;
    }
}

