/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.ExportTrie;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.dyld.BindOpcode;
import ghidra.app.util.bin.format.macho.commands.dyld.BindingTable;
import ghidra.app.util.bin.format.macho.commands.dyld.OpcodeTable;
import ghidra.app.util.bin.format.macho.commands.dyld.RebaseOpcode;
import ghidra.app.util.bin.format.macho.commands.dyld.RebaseTable;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DyldInfoCommand
extends LoadCommand {
    private long rebaseOff;
    private long rebaseSize;
    private long bindOff;
    private long bindSize;
    private long weakBindOff;
    private long weakBindSize;
    private long lazyBindOff;
    private long lazyBindSize;
    private long exportOff;
    private long exportSize;
    private RebaseTable rebaseTable;
    private BindingTable bindingTable;
    private BindingTable weakBindingTable;
    private BindingTable lazyBindingTable;
    private ExportTrie exportTrie;

    DyldInfoCommand(BinaryReader loadCommandReader, BinaryReader dataReader, MachHeader header) throws IOException {
        super(loadCommandReader);
        this.rebaseOff = loadCommandReader.readNextUnsignedInt();
        this.rebaseSize = loadCommandReader.readNextUnsignedInt();
        this.bindOff = loadCommandReader.readNextUnsignedInt();
        this.bindSize = loadCommandReader.readNextUnsignedInt();
        this.weakBindOff = loadCommandReader.readNextUnsignedInt();
        this.weakBindSize = loadCommandReader.readNextUnsignedInt();
        this.lazyBindOff = loadCommandReader.readNextUnsignedInt();
        this.lazyBindSize = loadCommandReader.readNextUnsignedInt();
        this.exportOff = loadCommandReader.readNextUnsignedInt();
        this.exportSize = loadCommandReader.readNextUnsignedInt();
        if (this.rebaseOff > 0L && this.rebaseSize > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.rebaseOff);
            this.rebaseTable = new RebaseTable(dataReader, header, this.rebaseSize);
        } else {
            this.rebaseTable = new RebaseTable();
        }
        if (this.bindOff > 0L && this.bindSize > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.bindOff);
            this.bindingTable = new BindingTable(dataReader, header, this.bindSize, false);
        } else {
            this.bindingTable = new BindingTable();
        }
        if (this.weakBindOff > 0L && this.weakBindSize > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.weakBindOff);
            this.weakBindingTable = new BindingTable(dataReader, header, this.weakBindSize, false);
        } else {
            this.weakBindingTable = new BindingTable();
        }
        if (this.lazyBindOff > 0L && this.lazyBindSize > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.lazyBindOff);
            this.lazyBindingTable = new BindingTable(dataReader, header, this.lazyBindSize, true);
        } else {
            this.lazyBindingTable = new BindingTable();
        }
        if (this.exportOff > 0L && this.exportSize > 0L) {
            dataReader.setPointerIndex(header.getStartIndex() + this.exportOff);
            this.exportTrie = new ExportTrie(dataReader);
        } else {
            this.exportTrie = new ExportTrie();
        }
    }

    public long getRebaseOffset() {
        return this.rebaseOff;
    }

    public long getRebaseSize() {
        return this.rebaseSize;
    }

    public long getBindOffset() {
        return this.bindOff;
    }

    public long getBindSize() {
        return this.bindSize;
    }

    public long getWeakBindOffset() {
        return this.weakBindOff;
    }

    public long getWeakBindSize() {
        return this.weakBindSize;
    }

    public long getLazyBindOffset() {
        return this.lazyBindOff;
    }

    public long getLazyBindSize() {
        return this.lazyBindSize;
    }

    public long getExportOffset() {
        return this.exportOff;
    }

    public long getExportSize() {
        return this.exportSize;
    }

    public RebaseTable getRebaseTable() {
        return this.rebaseTable;
    }

    public BindingTable getBindingTable() {
        return this.bindingTable;
    }

    public BindingTable getLazyBindingTable() {
        return this.lazyBindingTable;
    }

    public BindingTable getWeakBindingTable() {
        return this.weakBindingTable;
    }

    public ExportTrie getExportTrie() {
        return this.exportTrie;
    }

    @Override
    public String getCommandName() {
        return "dyld_info_command";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "rebase_off", "file offset to rebase info");
        struct.add(DWORD, "rebase_size", "size of rebase info");
        struct.add(DWORD, "bind_off", "file offset to binding info");
        struct.add(DWORD, "bind_size", "size of binding info");
        struct.add(DWORD, "weak_bind_off", "file offset to weak binding info");
        struct.add(DWORD, "weak_bind_size", "size of weak binding info");
        struct.add(DWORD, "lazy_bind_off", "file offset to lazy binding info");
        struct.add(DWORD, "lazy_bind_size", "size of lazy binding info");
        struct.add(DWORD, "export_off", "file offset to lazy binding info");
        struct.add(DWORD, "export_size", "size of lazy binding info");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.markupRebaseInfo(program, header, source, monitor, log);
        this.markupBindings(program, header, source, monitor, log);
        this.markupWeakBindings(program, header, source, monitor, log);
        this.markupLazyBindings(program, header, source, monitor, log);
        this.markupExportInfo(program, header, source, monitor, log);
    }

    private void markupRebaseInfo(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        Address rebaseAddr = this.fileOffsetToAddress(program, header, this.rebaseOff, this.rebaseSize);
        this.markupPlateComment(program, this.fileOffsetToAddress(program, header, this.rebaseOff, this.rebaseSize), source, "rebase");
        this.markupOpcodeTable(program, rebaseAddr, this.rebaseTable, RebaseOpcode.toDataType(), source, "rebase", log);
    }

    private void markupBindings(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        Address bindAddr = this.fileOffsetToAddress(program, header, this.bindOff, this.bindSize);
        this.markupPlateComment(program, bindAddr, source, "bind");
        this.markupOpcodeTable(program, bindAddr, this.bindingTable, BindOpcode.toDataType(), source, "bind", log);
    }

    private void markupWeakBindings(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        Address addr = this.fileOffsetToAddress(program, header, this.weakBindOff, this.weakBindSize);
        this.markupPlateComment(program, addr, source, "weak bind");
        this.markupOpcodeTable(program, addr, this.weakBindingTable, BindOpcode.toDataType(), source, "weak bind", log);
    }

    private void markupLazyBindings(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        Address addr = this.fileOffsetToAddress(program, header, this.lazyBindOff, this.lazyBindSize);
        this.markupPlateComment(program, addr, source, "lazy bind");
        this.markupOpcodeTable(program, addr, this.lazyBindingTable, BindOpcode.toDataType(), source, "lazy bind", log);
    }

    private void markupOpcodeTable(Program program, Address addr, OpcodeTable table, DataType opcodeDataType, String source, String additionalDescription, MessageLog log) {
        if (addr == null) {
            return;
        }
        try {
            for (long offset : table.getOpcodeOffsets()) {
                DataUtilities.createData((Program)program, (Address)addr.add(offset), (DataType)opcodeDataType, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            for (long offset : table.getUlebOffsets()) {
                DataUtilities.createData((Program)program, (Address)addr.add(offset), (DataType)ULEB128, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            for (long offset : table.getSlebOffsets()) {
                DataUtilities.createData((Program)program, (Address)addr.add(offset), (DataType)SLEB128, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            for (long offset : table.getStringOffsets()) {
                DataUtilities.createData((Program)program, (Address)addr.add(offset), (DataType)STRING, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
        }
        catch (Exception e) {
            log.appendMsg(DyldInfoCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, additionalDescription));
        }
    }

    private void markupExportInfo(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        Address exportAddr = this.fileOffsetToAddress(program, header, this.exportOff, this.exportSize);
        if (exportAddr == null) {
            return;
        }
        this.markupPlateComment(program, exportAddr, source, "export");
        try {
            for (long offset : this.exportTrie.getUlebOffsets()) {
                DataUtilities.createData((Program)program, (Address)exportAddr.add(offset), (DataType)ULEB128, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            for (long offset : this.exportTrie.getStringOffsets()) {
                DataUtilities.createData((Program)program, (Address)exportAddr.add(offset), (DataType)STRING, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
        }
        catch (Exception e) {
            log.appendMsg(DyldInfoCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, "export"));
        }
    }

    @Override
    public void markupRawBinary(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        try {
            Address start;
            super.markupRawBinary(header, api, baseAddress, parentModule, monitor, log);
            if (this.rebaseSize > 0L) {
                start = baseAddress.getNewAddress(this.rebaseOff);
                api.createFragment(parentModule, this.getCommandName() + "_REBASE", start, this.rebaseSize);
            }
            if (this.bindSize > 0L) {
                start = baseAddress.getNewAddress(this.bindOff);
                api.createFragment(parentModule, this.getCommandName() + "_BIND", start, this.bindSize);
            }
            if (this.weakBindSize > 0L) {
                start = baseAddress.getNewAddress(this.weakBindOff);
                api.createFragment(parentModule, this.getCommandName() + "_WEAK_BIND", start, this.weakBindSize);
            }
            if (this.lazyBindSize > 0L) {
                start = baseAddress.getNewAddress(this.lazyBindOff);
                api.createFragment(parentModule, this.getCommandName() + "_LAZY_BIND", start, this.lazyBindSize);
            }
            if (this.exportSize > 0L) {
                start = baseAddress.getNewAddress(this.exportOff);
                api.createFragment(parentModule, this.getCommandName() + "_EXPORT", start, this.exportSize);
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }
}

