/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ExportTrie {
    private BinaryReader reader;
    private long base;
    private List<ExportEntry> exports = new ArrayList<ExportEntry>();
    private List<Long> ulebOffsets = new ArrayList<Long>();
    private List<Long> stringOffsets = new ArrayList<Long>();

    public ExportTrie() {
    }

    public ExportTrie(BinaryReader reader) throws IOException {
        this();
        this.reader = reader;
        this.base = reader.getPointerIndex();
        this.parseTrie();
    }

    public List<ExportEntry> getExports() {
        return this.exports;
    }

    public List<ExportEntry> getExports(Predicate<ExportEntry> filter) {
        return this.exports.stream().filter(filter).collect(Collectors.toList());
    }

    private void parseTrie() throws IOException {
        LinkedList<Node> remainingNodes = this.parseNode("", 0);
        while (!remainingNodes.isEmpty()) {
            Node parent = remainingNodes.removeFirst();
            LinkedList<Node> children = this.parseNode(parent.name, parent.offset);
            for (Node child : children) {
                remainingNodes.add(new Node(parent.name + child.name, child.offset));
            }
        }
    }

    private LinkedList<Node> parseNode(String name, int offset) throws IOException {
        LinkedList<Node> children = new LinkedList<Node>();
        this.reader.setPointerIndex(this.base + (long)offset);
        this.ulebOffsets.add(this.reader.getPointerIndex() - this.base);
        int terminalSize = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        long childrenIndex = this.reader.getPointerIndex() + (long)terminalSize;
        if (terminalSize != 0) {
            this.ulebOffsets.add(this.reader.getPointerIndex() - this.base);
            long flags = this.reader.readNext(LEB128::unsigned);
            long address = 0L;
            long other = 0L;
            String importName = null;
            if ((flags & 8L) != 0L) {
                this.ulebOffsets.add(this.reader.getPointerIndex() - this.base);
                other = this.reader.readNext(LEB128::unsigned);
                this.stringOffsets.add(this.reader.getPointerIndex() - this.base);
                importName = this.reader.readNextAsciiString();
            } else {
                this.ulebOffsets.add(this.reader.getPointerIndex() - this.base);
                address = this.reader.readNext(LEB128::unsigned);
                if ((flags & 0x10L) != 0L) {
                    this.ulebOffsets.add(this.reader.getPointerIndex() - this.base);
                    other = this.reader.readNext(LEB128::unsigned);
                }
            }
            ExportEntry export = new ExportEntry(name, address, flags, other, importName);
            this.exports.add(export);
        }
        this.reader.setPointerIndex(childrenIndex);
        this.ulebOffsets.add(this.reader.getPointerIndex() - this.base);
        int numChildren = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        for (int i = 0; i < numChildren; ++i) {
            this.stringOffsets.add(this.reader.getPointerIndex() - this.base);
            String childName = this.reader.readNextAsciiString();
            this.ulebOffsets.add(this.reader.getPointerIndex() - this.base);
            int childOffset = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
            children.add(new Node(childName, childOffset));
        }
        return children;
    }

    public List<Long> getUlebOffsets() {
        return this.ulebOffsets;
    }

    public List<Long> getStringOffsets() {
        return this.stringOffsets;
    }

    private record Node(String name, int offset) {
        @Override
        public String toString() {
            return String.format("%s, 0x%x", this.name, this.offset);
        }
    }

    public record ExportEntry(String name, long address, long flags, long other, String importName) {
        public boolean isReExport() {
            return (this.flags & 8L) != 0L;
        }

        @Override
        public String toString() {
            return String.format("%s addr: 0x%x, flags: 0x%x, other: 0x%x, importName: %s", this.name, this.address, this.flags, this.other, this.importName != null ? this.importName : "<null>");
        }
    }
}

