/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class LoadCommandString
implements StructConverter {
    private int offset;
    private String string;

    LoadCommandString(BinaryReader reader, LoadCommand command) throws IOException {
        this.offset = reader.readNextInt();
        this.string = reader.readAsciiString(command.getStartIndex() + (long)this.offset);
    }

    public String getString() {
        return this.string;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("lc_str", 0);
        struct.add(DWORD, "offset", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public String toString() {
        return this.string;
    }
}

