/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImage;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheImageTextInfo
implements DyldCacheImage,
StructConverter {
    private byte[] uuid;
    private long loadAddress;
    private int textSegmentSize;
    private int pathOffset;
    private String path;

    public DyldCacheImageTextInfo(BinaryReader reader) throws IOException {
        this.uuid = reader.readNextByteArray(16);
        this.loadAddress = reader.readNextLong();
        this.textSegmentSize = reader.readNextInt();
        this.pathOffset = reader.readNextInt();
        this.path = reader.readAsciiString(this.pathOffset);
    }

    @Override
    public long getAddress() {
        return this.loadAddress;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_image_text_info", 0);
        struct.add((DataType)new ArrayDataType(BYTE, 16, 1), "uuid", "");
        struct.add(QWORD, "loadAddress", "");
        struct.add(DWORD, "textSegmentSize", "");
        struct.add(DWORD, "pathOffset", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

