/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.threadcommand;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadState;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThreadStatePPC
extends ThreadState {
    public static final int PPC_THREAD_STATE = 1;
    public static final int PPC_FLOAT_STATE = 2;
    public static final int PPC_EXCEPTION_STATE = 3;
    public static final int PPC_VECTOR_STATE = 4;
    public static final int PPC_THREAD_STATE64 = 5;
    public static final int PPC_EXCEPTION_STATE64 = 6;
    public static final int THREAD_STATE_NONE = 7;
    public long srr0;
    public long srr1;
    public long r0;
    public long r1;
    public long r2;
    public long r3;
    public long r4;
    public long r5;
    public long r6;
    public long r7;
    public long r8;
    public long r9;
    public long r10;
    public long r11;
    public long r12;
    public long r13;
    public long r14;
    public long r15;
    public long r16;
    public long r17;
    public long r18;
    public long r19;
    public long r20;
    public long r21;
    public long r22;
    public long r23;
    public long r24;
    public long r25;
    public long r26;
    public long r27;
    public long r28;
    public long r29;
    public long r30;
    public long r31;
    public int cr;
    public long xer;
    public long lr;
    public long ctr;
    public long mq;
    public long vrsave;

    ThreadStatePPC(BinaryReader reader, boolean is32bit) throws IOException {
        this.srr0 = this.read(reader, is32bit);
        this.srr1 = this.read(reader, is32bit);
        this.r0 = this.read(reader, is32bit);
        this.r1 = this.read(reader, is32bit);
        this.r2 = this.read(reader, is32bit);
        this.r3 = this.read(reader, is32bit);
        this.r4 = this.read(reader, is32bit);
        this.r5 = this.read(reader, is32bit);
        this.r6 = this.read(reader, is32bit);
        this.r7 = this.read(reader, is32bit);
        this.r8 = this.read(reader, is32bit);
        this.r9 = this.read(reader, is32bit);
        this.r10 = this.read(reader, is32bit);
        this.r11 = this.read(reader, is32bit);
        this.r12 = this.read(reader, is32bit);
        this.r13 = this.read(reader, is32bit);
        this.r14 = this.read(reader, is32bit);
        this.r15 = this.read(reader, is32bit);
        this.r16 = this.read(reader, is32bit);
        this.r17 = this.read(reader, is32bit);
        this.r18 = this.read(reader, is32bit);
        this.r19 = this.read(reader, is32bit);
        this.r20 = this.read(reader, is32bit);
        this.r21 = this.read(reader, is32bit);
        this.r22 = this.read(reader, is32bit);
        this.r23 = this.read(reader, is32bit);
        this.r24 = this.read(reader, is32bit);
        this.r25 = this.read(reader, is32bit);
        this.r26 = this.read(reader, is32bit);
        this.r27 = this.read(reader, is32bit);
        this.r28 = this.read(reader, is32bit);
        this.r29 = this.read(reader, is32bit);
        this.r30 = this.read(reader, is32bit);
        this.r31 = this.read(reader, is32bit);
        this.cr = reader.readNextInt();
        this.xer = this.read(reader, is32bit);
        this.lr = this.read(reader, is32bit);
        this.ctr = this.read(reader, is32bit);
        this.mq = this.read(reader, is32bit);
        this.vrsave = this.read(reader, is32bit);
    }

    private long read(BinaryReader reader, boolean is32bit) throws IOException {
        if (is32bit) {
            return reader.readNextUnsignedInt();
        }
        return reader.readNextLong();
    }

    @Override
    public long getInstructionPointer() {
        return this.srr0;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("PPC_THREAD_STATE", 0);
        struct.add(DWORD, "srr0", null);
        struct.add(DWORD, "srr1", null);
        struct.add(DWORD, "r0", null);
        struct.add(DWORD, "r1", null);
        struct.add(DWORD, "r2", null);
        struct.add(DWORD, "r3", null);
        struct.add(DWORD, "r4", null);
        struct.add(DWORD, "r5", null);
        struct.add(DWORD, "r6", null);
        struct.add(DWORD, "r7", null);
        struct.add(DWORD, "r8", null);
        struct.add(DWORD, "r9", null);
        struct.add(DWORD, "r10", null);
        struct.add(DWORD, "r11", null);
        struct.add(DWORD, "r12", null);
        struct.add(DWORD, "r13", null);
        struct.add(DWORD, "r14", null);
        struct.add(DWORD, "r15", null);
        struct.add(DWORD, "r16", null);
        struct.add(DWORD, "r17", null);
        struct.add(DWORD, "r18", null);
        struct.add(DWORD, "r19", null);
        struct.add(DWORD, "r20", null);
        struct.add(DWORD, "r21", null);
        struct.add(DWORD, "r22", null);
        struct.add(DWORD, "r23", null);
        struct.add(DWORD, "r24", null);
        struct.add(DWORD, "r25", null);
        struct.add(DWORD, "r26", null);
        struct.add(DWORD, "r27", null);
        struct.add(DWORD, "r28", null);
        struct.add(DWORD, "r29", null);
        struct.add(DWORD, "r30", null);
        struct.add(DWORD, "r31", null);
        struct.add(DWORD, "cr", null);
        struct.add(DWORD, "xer", null);
        struct.add(DWORD, "lr", null);
        struct.add(DWORD, "ctr", null);
        struct.add(DWORD, "mq", null);
        struct.add(DWORD, "vrsave", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

