/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.omf.AbstractOmfRecordFactory;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfUnknownRecord;
import ghidra.app.util.bin.format.omf.OmfUnsupportedRecord;
import ghidra.app.util.bin.format.omf.omf166.Omf166DepList;
import ghidra.app.util.bin.format.omf.omf51.Omf51Content;
import ghidra.app.util.bin.format.omf.omf51.Omf51ExternalDefsRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51FixupRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51LibraryDictionaryRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51LibraryHeaderRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51LibraryModuleLocationsRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51LibraryModuleNamesRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51ModuleEnd;
import ghidra.app.util.bin.format.omf.omf51.Omf51ModuleHeader;
import ghidra.app.util.bin.format.omf.omf51.Omf51PublicDefsRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordTypes;
import ghidra.app.util.bin.format.omf.omf51.Omf51SegmentDefs;
import java.io.IOException;
import java.util.List;

public class Omf51RecordFactory
extends AbstractOmfRecordFactory {
    public Omf51RecordFactory(ByteProvider provider) {
        super(new BinaryReader(provider, true));
    }

    @Override
    public OmfRecord readNextRecord() throws IOException, OmfException {
        int type = Byte.toUnsignedInt(this.reader.peekNextByte());
        OmfRecord record = switch (type) {
            case 2 -> new Omf51ModuleHeader(this.reader);
            case 4 -> new Omf51ModuleEnd(this.reader);
            case 112 -> new Omf166DepList(this.reader);
            case 6 -> new Omf51Content(this.reader, false);
            case 7 -> new Omf51Content(this.reader, true);
            case 14 -> new Omf51SegmentDefs(this.reader, false);
            case 15 -> new Omf51SegmentDefs(this.reader, true);
            case 8 -> new Omf51FixupRecord(this.reader, false);
            case 9 -> new Omf51FixupRecord(this.reader, true);
            case 22 -> new Omf51PublicDefsRecord(this.reader, false);
            case 23 -> new Omf51PublicDefsRecord(this.reader, true);
            case 24 -> new Omf51ExternalDefsRecord(this.reader, false);
            case 25 -> new Omf51ExternalDefsRecord(this.reader, true);
            case 38 -> new Omf51LibraryModuleLocationsRecord(this.reader);
            case 40 -> new Omf51LibraryModuleNamesRecord(this.reader);
            case 42 -> new Omf51LibraryDictionaryRecord(this.reader);
            case 44 -> new Omf51LibraryHeaderRecord(this.reader);
            case 16, 18 -> new OmfUnsupportedRecord(this.reader, Omf51RecordTypes.class);
            default -> new OmfUnknownRecord(this.reader);
        };
        record.parseData();
        return record;
    }

    @Override
    public List<Integer> getStartRecordTypes() {
        return List.of(Integer.valueOf(2), Integer.valueOf(112));
    }

    @Override
    public int getEndRecordType() {
        return 4;
    }
}

