/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.ImportByName;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThunkData
implements StructConverter,
ByteArrayConverter {
    private boolean is64bit;
    private long value;
    private ImportByName ibn;

    ThunkData(BinaryReader reader, int index, boolean is64bit) throws IOException {
        this.is64bit = is64bit;
        this.value = is64bit ? reader.readLong(index) : reader.readUnsignedInt(index);
    }

    public ThunkData(int value) {
        this.setValue(value);
    }

    public int getStructSize() {
        return this.is64bit ? 8 : 4;
    }

    public String getStructName() {
        return "IMAGE_THUNK_DATA" + (this.is64bit ? "64" : "32");
    }

    public void setValue(int value) {
        this.value = Integer.toUnsignedLong(value);
    }

    public long getForwarderString() {
        return this.value;
    }

    public long getFunction() {
        return this.value;
    }

    public long getOrdinal() {
        return this.value & 0xFFFFL;
    }

    public boolean isOrdinal() {
        if (this.is64bit) {
            return (this.value & Long.MIN_VALUE) != 0L;
        }
        return (this.value & 0x80000000L) != 0L;
    }

    public long getAddressOfData() {
        return this.value;
    }

    void setImportByName(ImportByName ibn) {
        this.ibn = ibn;
    }

    public ImportByName getImportByName() {
        return this.ibn;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        UnionDataType union = new UnionDataType("u1");
        union.setCategoryPath(new CategoryPath("/PE"));
        DataType dt = this.is64bit ? QWORD : DWORD;
        union.add(dt, "ForwarderString", null);
        union.add(dt, "Function", null);
        union.add(dt, "Ordinal", null);
        union.add(dt, "AddressOfData", null);
        StructureDataType struct = new StructureDataType(this.getStructName(), 0);
        struct.add((DataType)union, "u1", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        if (this.is64bit) {
            return dc.getBytes(this.value);
        }
        int tmp = (int)this.value;
        return dc.getBytes(tmp);
    }
}

