/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableNestedClass
extends CliAbstractTable {
    public CliTableNestedClass(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliNestedClassRow(this.readTableIndex(reader, CliTypeTable.TypeDef), this.readTableIndex(reader, CliTypeTable.TypeDef)));
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "NestedClass Row", 0);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.TypeDef), "NestedClass", "TypeDef index");
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.TypeDef), "EnclosingClass", "TypeDef index");
        return rowDt;
    }

    public class CliNestedClassRow
    extends CliAbstractTableRow {
        public int nestedClassIndex;
        public int enclosingClassIndex;

        public CliNestedClassRow(int nestedClassIndex, int enclosingClassIndex) {
            this.nestedClassIndex = nestedClassIndex;
            this.enclosingClassIndex = enclosingClassIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("%s is nested in %s", CliTableNestedClass.this.getRowRepresentationSafe(CliTypeTable.TypeDef, this.nestedClassIndex), CliTableNestedClass.this.getRowRepresentationSafe(CliTypeTable.TypeDef, this.enclosingClassIndex));
        }
    }
}

