/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.rich;

import ghidra.app.util.bin.format.pe.rich.MSRichProductInfoDataType;
import ghidra.app.util.bin.format.pe.rich.RichHeaderRecord;
import ghidra.app.util.bin.format.pe.rich.RichObjectCountDataType;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.mem.MemBuffer;

class RichTableRecordDataType
extends StructureDataType {
    private final RichHeaderRecord record;

    public RichTableRecordDataType(RichHeaderRecord record) {
        this(null, record);
    }

    public RichTableRecordDataType(DataTypeManager dtm, RichHeaderRecord record) {
        super(new CategoryPath("/PE"), "MSRichRecord", 0, dtm);
        this.record = record;
        this.initialize();
    }

    public boolean hasLanguageDependantLength() {
        return false;
    }

    public RichTableRecordDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new RichTableRecordDataType(dtm, this.record);
    }

    public String getMnemonic(Settings settings) {
        return "MSRichRecord";
    }

    public int getLength() {
        return 8;
    }

    public String getDescription() {
        return "MS Rich Table Record";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.record;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    public DataType copy(DataTypeManager dtm) {
        return this.clone(dtm);
    }

    private void initialize() {
        this.add((DataType)new MSRichProductInfoDataType(this.record.getCompId()), 4, "productInfo", null);
        this.add((DataType)new RichObjectCountDataType(this.record.getObjectCount()), 4, "objectCount", null);
    }
}

