/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.unixaout;

import ghidra.app.util.bin.format.unixaout.UnixAoutSymbolTable;

public class UnixAoutRelocation {
    public long address;
    public int symbolNum;
    public byte flags;
    public boolean pcRelativeAddressing;
    public byte pointerLength;
    public boolean extern;
    public boolean baseRelative;
    public boolean jmpTable;
    public boolean relative;
    public boolean copy;

    public UnixAoutRelocation(long address, long flags, boolean bigEndian) {
        this.address = 0xFFFFFFFFFFFFFFFFL & address;
        if (bigEndian) {
            this.symbolNum = (int)((flags & 0xFFFFFFFFFFFFFF00L) >> 8);
            this.flags = (byte)(flags & 0xFFL);
            this.pcRelativeAddressing = (flags & 0x80L) != 0L;
            this.pointerLength = (byte)(1 << (int)((flags & 0x60L) >> 5));
            this.extern = (flags & 0x10L) != 0L;
            this.baseRelative = (flags & 8L) != 0L;
            this.jmpTable = (flags & 4L) != 0L;
            this.relative = (flags & 2L) != 0L;
            this.copy = (flags & 1L) != 0L;
        } else {
            this.symbolNum = (int)(flags & 0xFFFFFFL);
            this.flags = (byte)((flags & 0xFFFFFFFFFF000000L) >> 24);
            this.pcRelativeAddressing = (this.flags & 1) != 0;
            this.pointerLength = (byte)(1 << ((this.flags & 6) >> 1));
            this.extern = (this.flags & 8) != 0;
            this.baseRelative = (this.flags & 0x10) != 0;
            this.jmpTable = (this.flags & 0x20) != 0;
            this.relative = (this.flags & 0x40) != 0;
            this.copy = (this.flags & 0x80) != 0;
        }
    }

    public String getSymbolName(UnixAoutSymbolTable symtab) {
        if (this.extern && (long)this.symbolNum < symtab.size()) {
            return symtab.get((int)this.symbolNum).name;
        }
        if (!this.extern) {
            return switch (this.symbolNum) {
                case 4 -> ".text";
                case 6 -> ".data";
                case 8 -> ".bss";
                default -> null;
            };
        }
        return null;
    }
}

