/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.C;

import ghidra.app.util.cparser.C.CParserConstants;
import ghidra.app.util.cparser.C.CParserTokenManager;
import ghidra.app.util.cparser.C.CompositeHandler;
import ghidra.app.util.cparser.C.Declaration;
import ghidra.app.util.cparser.C.ParseException;
import ghidra.app.util.cparser.C.SimpleCharStream;
import ghidra.app.util.cparser.C.Token;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.LongLongDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.SignedByteDataType;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.UnsignedCharDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.UnsignedLongLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;

public class CParser
implements CParserConstants {
    private static String DEFAULT_PARSER_OUTPUT_FILENAME = "CParser.out";
    private Map<String, DataType> types = new HashMap<String, DataType>();
    private Map<String, DataType> composites = new HashMap<String, DataType>();
    private Map<String, DataType> functions = new HashMap<String, DataType>();
    private Map<String, DataType> enums = new HashMap<String, DataType>();
    private Map<String, DataType> declarations = new HashMap<String, DataType>();
    private Map<String, DataType> internalTypes = new HashMap<String, DataType>();
    private DataType lastDataType = DefaultDataType.dataType;
    private boolean storeNewDT = true;
    private String possiblyUndefinedType = null;
    DataTypeManager dtMgr = null;
    private DataTypeManager[] subDTMgrs = new DataTypeManager[0];
    private int cnt = 1;
    private int func_cnt = 1;
    private String headerFileName = null;
    private int headerFileLine = 1;
    private int headerFileLineOffset = 0;
    private String currentCategoryName = "";
    private static final String ANONYMOUS_STRUCT_PREFIX = "_struct_";
    private static final String ANONYMOUS_UNION_PREFIX = "_union_";
    private static final String ANONYMOUS_FUNC_PREFIX = "_func_";
    private Stack<Boolean> typedefParsingStack = new Stack();
    private Stack<DataType> dataTypeStack = new Stack();
    private StringBuilder parseMessages = new StringBuilder();
    private boolean parseSuccess = false;
    private TaskMonitor monitor = null;
    private int packSize = 0;
    Stack<Integer> packStack = new Stack();
    Stack<String> packStackID = new Stack();
    String parseFileName = DEFAULT_PARSER_OUTPUT_FILENAME;
    public CParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[183];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private final JJCalls[] jj_2_rtns = new JJCalls[50];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setParseFileName(String fName) {
        this.parseFileName = fName;
    }

    private CategoryPath getCurrentCategoryPath() {
        return this.getCategory(this.currentCategoryName);
    }

    private CategoryPath getCurrentCategoryPath(String subCatName) {
        return this.getCategory(this.currentCategoryName).extend(new String[]{subCatName});
    }

    private CategoryPath getCategory(String catName) {
        CategoryPath rootCat = CategoryPath.ROOT;
        if (catName == null || catName.length() == 0) {
            return rootCat;
        }
        CategoryPath cat = new CategoryPath(rootCat, new String[]{catName});
        return cat;
    }

    private String getFileName(String path) {
        int slashpos = path.lastIndexOf(47);
        if (slashpos < 0) {
            slashpos = path.lastIndexOf(92);
        }
        if (slashpos < 0) {
            return path;
        }
        return path.substring(slashpos + 1);
    }

    private boolean isType(String type) {
        return this.getType(type) != null;
    }

    private DataType addTypedef(String type, DataType dt) {
        if (type == null || dt == null) {
            this.addNearParseMessage("Problem with type " + type + " : " + String.valueOf(dt));
            return dt;
        }
        if (type.equals(dt.getName())) {
            if (dt instanceof Composite) {
                return this.addDef(this.composites, type, (DataType)dt);
            }
            if (dt instanceof Enum) {
                return this.addDef(this.enums, type, (DataType)dt);
            }
        }
        if (dt instanceof Composite && (dt.getName().startsWith(ANONYMOUS_STRUCT_PREFIX) || dt.getName().startsWith(ANONYMOUS_UNION_PREFIX))) {
            try {
                this.composites.remove(dt.getName());
                dt.setName(type);
                dt = this.addDef(this.composites, type, (DataType)dt);
                return dt;
            }
            catch (InvalidNameException invalidNameException) {
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
        dt = type.equals("wchar_t") ? WideCharDataType.dataType : new TypedefDataType(this.getCurrentCategoryPath(), type, dt, this.dtMgr);
        dt = this.addDef(this.types, type, (DataType)dt);
        return dt;
    }

    private DataType getType(String type) {
        boolean functionsOK;
        DataType obj = this.composites.get(type);
        if (obj instanceof DataType) {
            return obj;
        }
        obj = this.types.get(type);
        if (obj instanceof DataType) {
            return obj;
        }
        obj = this.enums.get(type);
        if (obj instanceof DataType) {
            return obj;
        }
        boolean bl = functionsOK = this.typedefParsingStack.size() > 0;
        if (functionsOK && (obj = this.functions.get(type)) instanceof DataType) {
            return obj;
        }
        DataType dt = this.findDataType(type);
        if (dt != null && (functionsOK || !(dt instanceof FunctionDefinition))) {
            return dt;
        }
        BuiltInDataTypeManager builtInMgr = BuiltInDataTypeManager.getDataTypeManager();
        DataType bdt = this.findDataType((DataTypeManager)builtInMgr, type);
        if (bdt != null) {
            return bdt;
        }
        this.possiblyUndefinedType = type;
        return null;
    }

    private DataType findDataType(String dataTypeString) {
        DataType dt = this.findDataType(this.dtMgr, dataTypeString);
        if (dt != null) {
            return dt;
        }
        for (int i = 0; i < this.subDTMgrs.length; ++i) {
            DataTypeManager dtm = this.subDTMgrs[i];
            dt = this.findDataType(dtm, dataTypeString);
            if (dt == null) continue;
            return dt;
        }
        return null;
    }

    private DataType findDataType(DataTypeManager dtm, String dataTypeString) {
        ArrayList list = new ArrayList();
        dtm.findDataTypes(dataTypeString, list);
        if (list.size() > 0) {
            return (DataType)list.get(0);
        }
        return null;
    }

    private List<DataType> findAllDataTypes(String dataTypeString) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        this.dtMgr.findDataTypes(dataTypeString, list);
        return list;
    }

    private DataType addDef(Map<String, DataType> table, String name, DataType dt) {
        this.lastDataType = dt;
        DataType existingDT = table.get(name);
        if (existingDT != null && dt.isEquivalent(existingDT)) {
            return existingDT;
        }
        dt = this.findEquivalentInOpenDTMgrs(name, dt);
        if (this.storeNewDT) {
            try {
                dt = this.dtMgr.addDataType(dt, DataTypeConflictHandler.REPLACE_HANDLER);
            }
            catch (Exception e) {
                this.addNearParseMessage("Problem adding DataType " + dt.getDisplayName() + "\n    " + e.getMessage());
            }
        } else {
            dt = dt.clone(this.dtMgr);
        }
        table.put(name, dt);
        this.lastDataType = dt;
        return dt;
    }

    private DataType findEquivalentInOpenDTMgrs(String name, DataType dt) {
        ArrayList list = new ArrayList();
        boolean foundDT = false;
        for (int i = 0; !foundDT && i < this.subDTMgrs.length; ++i) {
            this.subDTMgrs[i].findDataTypes(name, list);
            for (DataType dataType : list) {
                if (!dataType.isEquivalent(dt)) continue;
                return dataType;
            }
        }
        return dt;
    }

    private DataType resolveInternal(DataType datatype) {
        DataType existingDT = this.internalTypes.get(datatype.getName());
        if (existingDT != null) {
            return existingDT;
        }
        existingDT = datatype.clone(this.dtMgr);
        this.internalTypes.put(datatype.getName(), existingDT);
        return existingDT;
    }

    private Composite defineForwardDeclaredComposite(Token symName, Composite comp) {
        DataType dt = this.findAnyComposite(symName.image);
        if (dt instanceof Composite) {
            comp = (Composite)dt;
        }
        if (dt == null) {
            String nameStr = symName.image;
            try {
                comp.setName(nameStr);
            }
            catch (InvalidNameException e) {
                e.printStackTrace();
            }
            catch (DuplicateNameException e) {
                e.printStackTrace();
            }
            comp = (Composite)this.addDef(this.composites, nameStr, (DataType)comp);
        }
        return comp;
    }

    private Composite defineNamedComposite(Token name, Token parentName, Composite comp) {
        String nameStr = name.image;
        DataType dt = this.findAnyComposite(nameStr);
        boolean hasNoComponents = false;
        boolean hasSameSourceArchive = true;
        if (dt != null) {
            Composite dtComp = (Composite)dt;
            hasNoComponents = dtComp.getNumDefinedComponents() == 0;
            hasSameSourceArchive = Objects.equals(dt.getSourceArchive(), this.dtMgr.getLocalSourceArchive());
        }
        if (comp instanceof Composite && hasNoComponents && hasSameSourceArchive) {
            Composite dtcomp = (Composite)dt;
            dtcomp.replaceWith((DataType)comp);
            comp = dtcomp;
        } else {
            if (parentName != null) {
                DataType superDt = this.findAnyComposite(parentName.image);
                if (superDt == null) {
                    this.addNearParseMessage("Parent structure " + parentName.image + " for " + nameStr + " undefined ");
                } else {
                    comp.insert(0, superDt);
                }
            }
            try {
                comp.setName(nameStr);
            }
            catch (InvalidNameException e) {
                e.printStackTrace();
            }
            catch (DuplicateNameException e) {
                e.printStackTrace();
            }
            comp = (Composite)this.addDef(this.composites, nameStr, (DataType)comp);
        }
        return comp;
    }

    private DataType findAnyComposite(String name) {
        DataType dt = this.getDef(this.composites, name);
        if (dt != null) {
            return dt;
        }
        if (!this.storeNewDT) {
            List<DataType> list = this.findAllDataTypes(name);
            for (int i = 0; i < list.size(); ++i) {
                dt = list.get(i);
                if (!(dt instanceof Composite)) continue;
                return dt;
            }
        }
        return null;
    }

    private DataType getEnumDef(String name) {
        DataType dt = this.getDef(this.enums, name);
        if (dt != null) {
            return dt;
        }
        if (!this.storeNewDT) {
            List<DataType> list = this.findAllDataTypes(name);
            for (int i = 0; i < list.size(); ++i) {
                dt = list.get(i);
                if (!(dt instanceof Enum)) continue;
                return dt;
            }
        }
        return null;
    }

    private DataType allocateEnumDT(Token t, ArrayList<EnumMember> list) {
        String enumName = t != null ? t.image : "enum_" + this.cnt++;
        int normalEnumLen = this.dtMgr != null ? this.dtMgr.getDataOrganization().getIntegerSize() : 4;
        EnumDataType enumDT = new EnumDataType(this.getCurrentCategoryPath(), enumName, 8, this.dtMgr);
        if (list != null) {
            for (EnumMember member : list) {
                try {
                    enumDT.add(member.name, member.value);
                }
                catch (IllegalArgumentException exc) {
                    this.addNearParseMessage("duplicate enum value: " + enumName + " : " + member.name + " : " + member.value);
                }
            }
            int minLen = enumDT.getMinimumPossibleLength();
            if (minLen > normalEnumLen) {
                enumDT.setLength(minLen);
            } else {
                enumDT.setLength(normalEnumLen);
            }
        } else {
            enumDT.setLength(normalEnumLen);
        }
        return this.addDef(this.enums, enumDT.getName(), (DataType)enumDT);
    }

    private DataType getDef(Map<String, DataType> table, String name) {
        return table.get(name);
    }

    private void printTypes() {
        System.out.println("**************   TYPES   ********************");
        this.printTable(this.types);
        System.out.println("**************   FUNCTIONS  *****************");
        this.printTable(this.functions);
        System.out.println("**************   DECLS      *****************");
        this.printTable(this.declarations);
        System.out.println("**************   ENUMS      *****************");
        this.printTable(this.enums);
        System.out.println("**************   STRUCTS    *****************");
        this.printTable(this.composites);
    }

    private void addNearParseMessage(String message) {
        this.parseMessages.append(message + "\n");
        this.parseMessages.append("   In file " + this.headerFileName + "\n");
        this.parseMessages.append("  Near datatype: " + (this.lastDataType == null ? "- none -" : this.lastDataType.getName()) + "\n");
        int endLine = this.token_source.input_stream.line;
        long subLinenum = endLine - this.headerFileLineOffset + this.headerFileLine;
        if (this.headerFileName != null) {
            this.parseMessages.append("         in " + this.headerFileName + " near line " + subLinenum + "\n");
        }
    }

    public String getParseMessages() {
        return this.parseMessages.toString();
    }

    public boolean didParseSucceed() {
        return this.parseSuccess;
    }

    public void setMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    private FunctionDefinitionDataType newAnonymousFunction(FunctionDefinitionDataType currentFuncDT) {
        if (currentFuncDT != null) {
            return currentFuncDT;
        }
        return new FunctionDefinitionDataType(this.getCurrentCategoryPath("functions"), ANONYMOUS_FUNC_PREFIX + this.func_cnt++, this.dtMgr);
    }

    private void checkReturnDataType(DataType retDT) throws ParseException {
        if (retDT == null) {
            return;
        }
        DataType dt = retDT;
        int len = dt.getLength();
        if (len == 0 && dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (len <= 0 && !dt.isEquivalent(DataType.VOID)) {
            throw new ParseException("'" + retDT.getName() + "' is not fixed length.  Function return must be fixed length data type or void.");
        }
    }

    private void defineAndReplaceFunction(Declaration dec, FunctionDefinitionDataType funcDT) {
        DataType repDT;
        DataType newDT;
        DataType newDecDT = newDT = this.addDef(this.functions, dec.getName(), (DataType)funcDT);
        DataType origDT = repDT = dec.getDataType();
        while (repDT != null) {
            if (repDT instanceof Pointer) {
                PointerDataType ptDT = (PointerDataType)repDT;
                if (ptDT.getDataType() instanceof FunctionDefinition) {
                    ptDT.dataTypeReplaced(ptDT.getDataType(), newDT);
                    newDecDT = origDT;
                    break;
                }
                repDT = ptDT.getDataType();
                continue;
            }
            if (!(repDT instanceof Array)) break;
            ArrayDataType arrDT = (ArrayDataType)repDT;
            if (arrDT.getDataType() instanceof FunctionDefinition) {
                arrDT.dataTypeReplaced(arrDT.getDataType(), newDT);
                newDecDT = origDT;
                break;
            }
            repDT = arrDT.getDataType();
        }
        dec.setDataType(newDecDT);
    }

    private void applyFunctionQualifiers(Declaration dec, FunctionDefinition funcDT) {
        List<Integer> qualifierList = dec.getQualifiers();
        if (qualifierList.contains(48)) {
            funcDT.setNoReturn(true);
        }
        String convention = null;
        for (Integer qualifier : qualifierList) {
            switch (qualifier) {
                case 42: {
                    convention = "__cdecl";
                    break;
                }
                case 43: {
                    convention = "__stdcall";
                    break;
                }
                case 44: {
                    convention = "__fastcall";
                    break;
                }
                case 45: {
                    convention = "__vectorcall";
                    break;
                }
                case 46: {
                    convention = "__rustcall";
                    break;
                }
                case 47: {
                    convention = "__pascal";
                }
            }
        }
        if (convention != null) {
            try {
                funcDT.setCallingConvention(convention);
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
    }

    private Integer getConstantValue(Object obj, int defaultValue) {
        int value = defaultValue;
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Integer) {
            value = (Integer)obj;
        } else if (obj instanceof Long) {
            value = (int)((Long)obj).longValue();
        } else if (obj instanceof Character) {
            value = ((Character)obj).charValue();
        }
        return value;
    }

    private void pushPack(Token iD, int packingSize) {
        this.packStack.push(packingSize);
        String name = "";
        if (iD != null) {
            name = iD.image;
        }
        this.packStackID.push(name);
    }

    private int popPack(Token iD) {
        String ID;
        if (this.packStack.size() == 0) {
            return this.packSize;
        }
        String name = "";
        if (iD != null) {
            name = iD.image;
        }
        int popVal = this.packSize;
        do {
            ID = this.packStackID.pop();
            popVal = this.packStack.pop();
        } while (!name.equals(ID) && this.packStack.size() > 0);
        return popVal;
    }

    private void printTable(Map<String, DataType> table) {
        for (String name : table.keySet()) {
            DataType dt = table.get(name);
            String dataTypeName = "- unknown -";
            String mnemonic = "";
            if (dt != null) {
                dataTypeName = dt.getName();
                mnemonic = dt.getMnemonic(null);
            }
            System.out.println(name + " = " + dataTypeName + " : " + mnemonic);
        }
    }

    Object computeBinaryValue(Object obj1, Token operation, Object obj2) {
        if (!(obj1 instanceof Long) || !(obj2 instanceof Long)) {
            return null;
        }
        Long val1 = (Long)obj1;
        Long val2 = (Long)obj2;
        switch (operation.image) {
            case "<<": {
                return val1 << (int)val2.longValue();
            }
            case ">>": {
                return val1 >> (int)val2.longValue();
            }
            case "+": {
                return val1 + val2;
            }
            case "-": {
                return val1 - val2;
            }
            case "*": {
                return val1 * val2;
            }
            case "/": {
                return val1 / val2;
            }
            case "%": {
                return val1 % val2;
            }
            case "|": {
                return val1 | val2;
            }
            case "&": {
                return val1 & val2;
            }
            case "^": {
                return val1 ^ val2;
            }
            case "==": {
                return val1 == val2 ? 1 : 0;
            }
            case "!=": {
                return val1 != val2 ? 1 : 0;
            }
            case "<": {
                return val1 < val2 ? 1 : 0;
            }
            case ">": {
                return val1 > val2 ? 1 : 0;
            }
            case "<=": {
                return val1 <= val2 ? 1 : 0;
            }
            case ">=": {
                return val1 >= val2 ? 1 : 0;
            }
            case "&&": {
                return val1 != 0L && val2 != 0L ? 1 : 0;
            }
            case "||": {
                return val1 != 0L || val2 != 0L ? 1 : 0;
            }
        }
        return null;
    }

    Object computeUnaryValue(Object obj, Token operation) {
        if (!(obj instanceof Long)) {
            return null;
        }
        Long val = (Long)obj;
        switch (operation.image) {
            case "+": {
                return val;
            }
            case "-": {
                return -val.longValue();
            }
            case "~": {
                return val ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case "!": {
                return val != 0L ? 0 : 1;
            }
        }
        return null;
    }

    Object computeTernaryValue(Object objTest, Object objTrue, Object objFalse) {
        if (!(objTest instanceof Long)) {
            return null;
        }
        Long testValue = (Long)objTest;
        return testValue != 0L ? objTrue : objFalse;
    }

    public DataTypeManager getDataTypeManager() {
        return this.dtMgr;
    }

    public DataType getLastDataType() {
        return this.lastDataType;
    }

    public Map<String, DataType> getDeclarations() {
        return this.declarations;
    }

    public Map<String, DataType> getEnums() {
        return this.enums;
    }

    public Map<String, DataType> getFunctions() {
        return this.functions;
    }

    public Map<String, DataType> getComposites() {
        return this.composites;
    }

    public Map<String, DataType> getTypes() {
        return this.types;
    }

    public DataType parse(String str) throws ParseException {
        ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
        this.parse(is);
        if (this.lastDataType != null && this.dtMgr != null) {
            return this.lastDataType.clone(this.dtMgr);
        }
        return this.lastDataType;
    }

    public void parse(InputStream fis) throws ParseException {
        this.ReInit(fis);
        int transactionID = -1;
        this.parseSuccess = false;
        try {
            transactionID = this.dtMgr.startTransaction("Parsing");
            this.TranslationUnit();
            this.parseSuccess = true;
        }
        catch (ParseException e) {
            if (this.headerFileName == null) {
                throw e;
            }
            long endLine = e.currentToken != null ? e.currentToken.endLine : 0;
            long subLinenum = endLine - (long)this.headerFileLineOffset + (long)this.headerFileLine;
            Object parseMessage = "C Parser:  Encountered errors during parse.\n";
            if (this.headerFileName != null) {
                parseMessage = (String)parseMessage + "         in " + this.headerFileName + " near line " + subLinenum + "\n";
            }
            parseMessage = (String)parseMessage + "Error: " + e.getMessage() + "\n";
            parseMessage = (String)parseMessage + "         near token: " + String.valueOf(e.currentToken) + "\n";
            parseMessage = (String)parseMessage + "Possibly Undefined : " + this.possiblyUndefinedType + "\n";
            parseMessage = (String)parseMessage + "         Last Valid Datatype: " + (this.lastDataType == null ? "- none -" : this.lastDataType.getDisplayName()) + "\n";
            parseMessage = (String)parseMessage + "         Check around " + this.parseFileName + " around line: " + this.jj_input_stream.getBeginLine() + "\n";
            ParseException parseException = new ParseException((String)parseMessage);
            parseException.currentToken = e.currentToken;
            throw parseException;
        }
        catch (Error e) {
            if (this.headerFileName == null) {
                throw e;
            }
            Object parseMessage = "C Parser:  Problem Parsing.\n";
            if (this.headerFileName != null) {
                parseMessage = (String)parseMessage + "          in " + this.headerFileName + " near line " + this.headerFileLine + "\n";
            }
            parseMessage = (String)parseMessage + "         Last Valid Datatype: " + (this.lastDataType == null ? "- none -" : this.lastDataType.getDisplayName()) + "\n";
            parseMessage = (String)parseMessage + "         Check around " + this.parseFileName + " around line: " + this.jj_input_stream.getBeginLine() + "\n";
            Msg.warn((Object)this, (Object)e, (Throwable)e);
            ParseException parseException = new ParseException((String)parseMessage);
            if (this.token != null) {
                parseException.currentToken = this.token;
            }
            throw parseException;
        }
        catch (Exception e) {
            Object parseMessage = "C Parser:  Problem Parsing.\n";
            if (this.headerFileName != null) {
                parseMessage = (String)parseMessage + "          in " + this.headerFileName + " near line " + this.headerFileLine + "\n";
            }
            parseMessage = (String)parseMessage + "         Last Valid Datatype: " + (this.lastDataType == null ? "- none -" : this.lastDataType.getDisplayName()) + "\n";
            parseMessage = (String)parseMessage + "         Check around " + this.parseFileName + " around line: " + this.jj_input_stream.getBeginLine() + "\n";
            Msg.warn((Object)this, (Object)e, (Throwable)e);
            throw new ParseException((String)parseMessage);
        }
        finally {
            this.dtMgr.endTransaction(transactionID, true);
        }
    }

    public CParser() {
        this(System.in);
        this.dtMgr = new StandAloneDataTypeManager("parsed");
    }

    public CParser(DataTypeManager dtmgr) {
        this(dtmgr, false, null);
    }

    public CParser(DataTypeManager dtmgr, boolean storeDataType, DataTypeManager[] subDTMgrs) {
        this(System.in);
        this.dtMgr = dtmgr;
        if (subDTMgrs == null) {
            subDTMgrs = new DataTypeManager[]{};
        }
        this.subDTMgrs = subDTMgrs;
        this.storeNewDT = storeDataType;
    }

    public static void main(String[] args) {
        CParser parser = new CParser();
        try {
            if (args.length == 0) {
                System.out.println("C Parser:  Reading from standard input . . .");
                parser.parse(System.in);
            } else if (args.length == 1) {
                System.out.println("C Parser:  Reading from file " + args[0] + " . . .");
                try {
                    parser.parse(new FileInputStream(args[0]));
                }
                catch (FileNotFoundException e) {
                    System.out.println("C Parser:  File " + args[0] + " not found.");
                    return;
                }
            } else {
                System.out.println("C Parser:  Usage is one of:");
                System.out.println("         java CParser < inputfile");
                System.out.println("OR");
                System.out.println("         java CParser inputfile");
                return;
            }
            System.out.println("C Parser:  Java program parsed successfully.");
        }
        catch (ParseException e) {
            System.out.println("C Parser:  Encountered errors during parse.");
        }
    }

    public final void TranslationUnit() throws ParseException {
        do {
            this.ExternalDeclaration();
        } while (this.jj_2_1(1));
        this.jj_consume_token(0);
    }

    public final void ExternalDeclaration() throws ParseException {
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            this.FunctionDefinition();
            this.jj_consume_token(146);
            if (this.jj_2_2(1)) {
                this.StatementList();
            }
            this.jj_consume_token(147);
        } else if (this.jj_2_4(1)) {
            this.Declaration();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 39: 
                case 40: {
                    this.PragmaSpec();
                    break;
                }
                case 58: {
                    this.StaticAssert();
                    break;
                }
                case 85: 
                case 86: {
                    this.LineDef();
                    break;
                }
                case 148: {
                    this.jj_consume_token(148);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (this.monitor != null && this.monitor.isCancelled()) {
            throw new ParseException("Parsing Canceled");
        }
        this.typedefParsingStack.clear();
    }

    public final void LineDef() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token lineTok = this.jj_consume_token(100);
        Token fileTok = this.jj_consume_token(99);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                block10: while (true) {
                    this.jj_consume_token(10);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 10: {
                            continue block10;
                        }
                    }
                    break;
                }
                this.jj_la1[2] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.headerFileName = fileTok.image.substring(1, fileTok.image.length() - 1);
        this.headerFileLine = Integer.parseInt(lineTok.image);
        this.headerFileLineOffset = lineTok.beginLine;
        this.currentCategoryName = this.getFileName(this.headerFileName);
    }

    public final DataType ObjcDef() throws ParseException {
        Token nameTok;
        block13: {
            nameTok = this.jj_consume_token(130);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 129: 
                    case 130: 
                    case 144: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 130: {
                        this.jj_consume_token(130);
                        continue block12;
                    }
                    case 129: {
                        this.jj_consume_token(129);
                        continue block12;
                    }
                    case 144: {
                        this.jj_consume_token(144);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[5] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 133: {
                this.jj_consume_token(133);
                break;
            }
            case 145: {
                this.jj_consume_token(145);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.addTypedef(nameTok.image, this.resolveInternal((DataType)VoidDataType.dataType));
    }

    public final void FunctionDefinition() throws ParseException {
        Declaration retDT = new Declaration();
        Declaration dec = null;
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            retDT = this.DeclarationSpecifiers(retDT);
        }
        this.typedefParsingStack.push(Boolean.FALSE);
        dec = this.Declarator(retDT, null);
        if (this.jj_2_6(1)) {
            this.DeclarationList();
        }
        this.typedefParsingStack.pop();
        if (dec.getDataType() instanceof FunctionDefinition) {
            this.addDef(this.functions, dec.getName(), dec.getDataType());
        }
    }

    public final Declaration Declaration() throws ParseException {
        Declaration dec = new Declaration();
        DataType dt = null;
        if (this.jj_2_7(1)) {
            dec = this.DeclarationSpecifiers(dec);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 31: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 68: 
                case 69: 
                case 71: 
                case 77: 
                case 78: 
                case 87: 
                case 149: 
                case 151: 
                case 157: 
                case 158: {
                    this.InitDeclaratorList(dec);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                }
            }
            this.jj_consume_token(148);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 83: 
                case 84: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 83: {
                            this.jj_consume_token(83);
                            break;
                        }
                        case 84: {
                            this.jj_consume_token(84);
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    dt = this.ObjcDef();
                    dec.setDataType(dt);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return dec;
    }

    public final void DeclarationList() throws ParseException {
        do {
            this.Declaration();
        } while (this.jj_2_8(Integer.MAX_VALUE));
    }

    public final Declaration DeclarationSpecifiers(Declaration specDT) throws ParseException {
        Declaration typeDT = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: 
            case 22: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 73: {
                specDT = this.StorageClassSpecifier(specDT);
                if (!this.jj_2_9(1)) break;
                specDT = this.DeclarationSpecifiers(specDT);
                break;
            }
            case 21: 
            case 24: 
            case 33: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 74: 
            case 75: 
            case 80: {
                specDT = this.BuiltInDeclarationSpecifier(specDT);
                if (!this.jj_2_10(Integer.MAX_VALUE)) break;
                specDT = this.TypeQualifierList(specDT);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                if (this.jj_2_13(1)) {
                    specDT = this.TypeSpecifier(specDT);
                    if (!this.jj_2_11(Integer.MAX_VALUE) || specDT.getDataType() != null) break;
                    specDT = this.DeclarationSpecifiers(specDT);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: 
                    case 31: 
                    case 37: 
                    case 38: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 68: 
                    case 69: 
                    case 71: 
                    case 77: 
                    case 78: 
                    case 151: {
                        specDT = this.TypeQualifier(specDT);
                        if (!this.jj_2_12(Integer.MAX_VALUE)) break block0;
                        specDT = this.DeclarationSpecifiers(specDT);
                        break block0;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        if (this.jj_2_14(Integer.MAX_VALUE)) {
            specDT = this.TypeQualifier(specDT);
        }
        if (specDT == null) {
            specDT = new Declaration(typeDT);
        }
        return specDT;
    }

    public final Declaration StorageClassSpecifier(Declaration specDT) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.MultiLineString();
                        break block0;
                    }
                }
                this.jj_la1[12] = this.jj_gen;
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                this.typedefParsingStack.push(Boolean.TRUE);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return specDT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Declaration BuiltInTypeSpecifier(Declaration dec) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                this.jj_consume_token(74);
                dec.setDataType(this.resolveInternal((DataType)VoidDataType.dataType));
                return dec;
            }
            case 75: {
                this.jj_consume_token(75);
                DataType dt = dec.getDataType();
                if (dt != null) {
                    if (dt == this.resolveInternal((DataType)UnsignedIntegerDataType.dataType)) {
                        dt = this.resolveInternal((DataType)UnsignedCharDataType.dataType);
                    } else {
                        if (dt != this.resolveInternal((DataType)IntegerDataType.dataType)) throw new ParseException("Bad datatype " + String.valueOf(dt) + " char");
                        dt = this.resolveInternal((DataType)CharDataType.dataType);
                    }
                } else {
                    dt = this.resolveInternal((DataType)CharDataType.dataType);
                }
                dec.setDataType(dt);
                return dec;
            }
            case 60: {
                this.jj_consume_token(60);
                DataType dt = dec.getDataType();
                if (dt == null) {
                    dt = this.resolveInternal((DataType)ShortDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)UnsignedIntegerDataType.dataType)) {
                    dt = this.resolveInternal((DataType)UnsignedShortDataType.dataType);
                } else {
                    if (dt != this.resolveInternal((DataType)IntegerDataType.dataType)) throw new ParseException("Bad datatype " + String.valueOf(dt) + " short");
                    dt = this.resolveInternal((DataType)ShortDataType.dataType);
                }
                dec.setDataType(dt);
                if (!this.jj_2_15(Integer.MAX_VALUE)) return dec;
                return this.BuiltInDeclarationSpecifier(dec);
            }
            case 80: {
                this.jj_consume_token(80);
                DataType dt = dec.getDataType();
                if (dt != null) return dec;
                dec.setDataType(this.resolveInternal((DataType)IntegerDataType.dataType));
                return dec;
            }
            case 63: {
                this.jj_consume_token(63);
                DataType dt = dec.getDataType();
                if (dt == null) {
                    dt = this.resolveInternal((DataType)LongDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)UnsignedIntegerDataType.dataType)) {
                    dt = this.resolveInternal((DataType)UnsignedLongDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)IntegerDataType.dataType)) {
                    dt = this.resolveInternal((DataType)LongDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)LongDataType.dataType)) {
                    dt = this.resolveInternal((DataType)LongLongDataType.dataType);
                } else {
                    if (dt != this.resolveInternal((DataType)UnsignedLongDataType.dataType)) throw new ParseException("Bad datatype " + String.valueOf(dt) + " long");
                    dt = this.resolveInternal((DataType)UnsignedLongLongDataType.dataType);
                }
                dec.setDataType(dt);
                if (!this.jj_2_16(Integer.MAX_VALUE)) return dec;
                return this.BuiltInDeclarationSpecifier(dec);
            }
            case 59: {
                this.jj_consume_token(59);
                DataType dt = dec.getDataType();
                if (dt == null) {
                    dt = this.resolveInternal((DataType)FloatDataType.dataType);
                } else {
                    if (dt != this.resolveInternal((DataType)LongDataType.dataType)) throw new ParseException("Bad datatype " + String.valueOf(dt) + " long");
                    dt = this.resolveInternal((DataType)DoubleDataType.dataType);
                }
                dec.setDataType(dt);
                return dec;
            }
            case 24: {
                this.jj_consume_token(24);
                dec.setDataType(this.resolveInternal((DataType)DoubleDataType.dataType));
                return dec;
            }
            case 33: {
                this.jj_consume_token(33);
                DataType dt = dec.getDataType();
                if (dt == null) {
                    dt = this.resolveInternal((DataType)IntegerDataType.dataType);
                }
                dec.setDataType(dt);
                if (!this.jj_2_17(Integer.MAX_VALUE)) return dec;
                return this.BuiltInDeclarationSpecifier(dec);
            }
            case 21: {
                this.jj_consume_token(21);
                DataType dt = dec.getDataType();
                if (dt == null) {
                    dt = this.resolveInternal((DataType)UnsignedIntegerDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)ShortDataType.dataType)) {
                    dt = this.resolveInternal((DataType)UnsignedShortDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)LongDataType.dataType)) {
                    dt = this.resolveInternal((DataType)UnsignedLongDataType.dataType);
                } else {
                    if (dt != this.resolveInternal((DataType)LongLongDataType.dataType)) throw new ParseException("Bad datatype " + String.valueOf(dt) + " unsigned");
                    dt = this.resolveInternal((DataType)UnsignedLongLongDataType.dataType);
                }
                dec.setDataType(dt);
                if (!this.jj_2_18(Integer.MAX_VALUE)) return dec;
                return this.BuiltInDeclarationSpecifier(dec);
            }
            case 64: {
                this.jj_consume_token(64);
                dec.setDataType(this.resolveInternal((DataType)SignedByteDataType.dataType));
                return dec;
            }
            case 65: {
                this.jj_consume_token(65);
                dec.setDataType(this.resolveInternal((DataType)ShortDataType.dataType));
                return dec;
            }
            case 66: {
                this.jj_consume_token(66);
                dec.setDataType(this.resolveInternal((DataType)IntegerDataType.dataType));
                return dec;
            }
            case 67: {
                this.jj_consume_token(67);
                dec.setDataType(this.resolveInternal((DataType)LongLongDataType.dataType));
                return dec;
            }
            case 70: {
                this.jj_consume_token(70);
                dec.setDataType(this.resolveInternal((DataType)BooleanDataType.dataType));
                return dec;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Declaration BuiltInDeclarationSpecifier(Declaration dec) throws ParseException {
        Object dt = null;
        dec = this.BuiltInTypeSpecifier(dec);
        return dec;
    }

    public final Declaration TypeSpecifier(Declaration dec) throws ParseException {
        DataType dt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 36: {
                dt = this.StructOrUnionSpecifier();
                break;
            }
            case 72: {
                dt = this.EnumSpecifier();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                if (this.isType(this.getToken((int)1).image)) {
                    dt = this.TypedefName();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        dec.setDataType(dt);
        return dec;
    }

    public final Declaration TypeQualifier(Declaration dec) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                dec.addQualifier(37);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                dec.addQualifier(42);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                dec.addQualifier(43);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                dec.addQualifier(44);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                dec.addQualifier(45);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                dec.addQualifier(46);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                dec.addQualifier(47);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                dec.addQualifier(48);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            case 38: 
            case 41: 
            case 49: 
            case 53: 
            case 56: 
            case 151: {
                this.DeclSpec(dec);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return dec;
    }

    public final void AttributeSpec(Declaration dec) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                this.jj_consume_token(53);
                this.jj_consume_token(149);
                this.SubIdent(dec);
                this.jj_consume_token(150);
                break;
            }
            case 56: {
                this.AsmStatement();
                break;
            }
            case 151: {
                this.jj_consume_token(151);
                this.jj_consume_token(151);
                this.AttributeList(dec);
                this.jj_consume_token(152);
                this.jj_consume_token(152);
                break;
            }
            case 49: {
                this.AlignmentSpecifier();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void AlignmentSpecifier() throws ParseException {
        Declaration dt = new Declaration();
        this.jj_consume_token(49);
        this.jj_consume_token(149);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 31: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 68: 
            case 69: 
            case 71: 
            case 77: 
            case 78: 
            case 151: {
                this.TypeQualifier(dt);
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 25: 
            case 50: 
            case 87: 
            case 149: 
            case 157: 
            case 158: 
            case 161: 
            case 162: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                this.AssignmentExpression();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(150);
    }

    public final void AttributeList(Declaration dec) throws ParseException {
        this.AttributeToken(dec);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 153: {
                block6: while (true) {
                    this.jj_consume_token(153);
                    this.AttributeToken(dec);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 153: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[19] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
    }

    public final void AttributeToken(Declaration dec) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 19: 
            case 31: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 68: 
            case 69: 
            case 71: 
            case 77: 
            case 78: 
            case 151: {
                this.TypeQualifier(dec);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 154: {
                this.jj_consume_token(154);
                this.jj_consume_token(154);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 87: {
                        this.jj_consume_token(87);
                        break block4;
                    }
                    case 19: 
                    case 31: 
                    case 37: 
                    case 38: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 68: 
                    case 69: 
                    case 71: 
                    case 77: 
                    case 78: 
                    case 151: {
                        this.TypeQualifier(dec);
                        break block4;
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 149: {
                this.jj_consume_token(149);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 87: {
                        this.jj_consume_token(87);
                        break;
                    }
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: {
                        this.Constant();
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 153: {
                        block28: while (true) {
                            this.jj_consume_token(153);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 87: {
                                    this.jj_consume_token(87);
                                    break;
                                }
                                case 10: 
                                case 14: 
                                case 16: 
                                case 17: {
                                    this.Constant();
                                    break;
                                }
                                default: {
                                    this.jj_la1[25] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 153: {
                                    continue block28;
                                }
                            }
                            break;
                        }
                        this.jj_la1[26] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                    }
                }
                this.jj_consume_token(150);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
    }

    public final void AttributeSpecList(Declaration dec) throws ParseException {
        block3: while (true) {
            this.AttributeSpec(dec);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 49: 
                case 53: 
                case 56: 
                case 151: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[29] = this.jj_gen;
    }

    public final void SubIdent(Declaration dec) throws ParseException {
        Token id = null;
        Declaration dt = new Declaration();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 149: {
                this.jj_consume_token(149);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 31: 
                    case 37: 
                    case 38: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 68: 
                    case 69: 
                    case 71: 
                    case 77: 
                    case 78: 
                    case 87: 
                    case 149: 
                    case 151: {
                        this.SubIdent(dec);
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                    }
                }
                this.jj_consume_token(150);
                break;
            }
            case 19: 
            case 31: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 68: 
            case 69: 
            case 71: 
            case 77: 
            case 78: 
            case 87: 
            case 151: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 87: {
                        id = this.jj_consume_token(87);
                        break;
                    }
                    case 19: 
                    case 31: 
                    case 37: 
                    case 38: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 68: 
                    case 69: 
                    case 71: 
                    case 77: 
                    case 78: 
                    case 151: {
                        this.TypeQualifier(dec);
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block12 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 149: 
                    case 155: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 149: {
                                this.jj_consume_token(149);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 10: 
                                    case 14: 
                                    case 16: 
                                    case 17: 
                                    case 19: 
                                    case 31: 
                                    case 37: 
                                    case 38: 
                                    case 41: 
                                    case 42: 
                                    case 43: 
                                    case 44: 
                                    case 45: 
                                    case 46: 
                                    case 47: 
                                    case 48: 
                                    case 49: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: 
                                    case 68: 
                                    case 69: 
                                    case 71: 
                                    case 77: 
                                    case 78: 
                                    case 87: 
                                    case 149: 
                                    case 151: {
                                        this.SubIdent(dt);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[32] = this.jj_gen;
                                    }
                                }
                                this.jj_consume_token(150);
                                break block12;
                            }
                            case 155: {
                                this.jj_consume_token(155);
                                this.SubIdent(dt);
                                break block12;
                            }
                        }
                        this.jj_la1[33] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 153: {
                        this.jj_consume_token(153);
                        this.SubIdent(dt);
                        break block0;
                    }
                }
                this.jj_la1[35] = this.jj_gen;
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 17: {
                this.Constant();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 153: {
                        this.jj_consume_token(153);
                        this.SubIdent(dt);
                        break block0;
                    }
                }
                this.jj_la1[36] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (id != null && "noreturn".equals(id.image.replace("_", ""))) {
            dec.addQualifier(48);
            if (dec.getDataType() instanceof FunctionDefinition) {
                this.applyFunctionQualifiers(dec, (FunctionDefinition)dec.getDataType());
            }
        }
    }

    public final void DeclSpec(Declaration dec) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: 
            case 41: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 38: {
                        this.jj_consume_token(38);
                        break;
                    }
                    case 41: {
                        this.jj_consume_token(41);
                        break;
                    }
                    default: {
                        this.jj_la1[38] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(149);
                this.DeclSpecifier(dec);
                this.jj_consume_token(150);
                break;
            }
            case 49: 
            case 53: 
            case 56: 
            case 151: {
                this.AttributeSpecList(dec);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DeclSpecifier(Declaration dec) throws ParseException {
        Token id = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 149: {
                this.jj_consume_token(149);
                this.DeclSpecifier(dec);
                this.jj_consume_token(150);
                break;
            }
            case 87: {
                block13: while (true) {
                    if ((id = this.jj_consume_token(87)) != null && "noreturn".equals(id.image)) {
                        dec.addQualifier(48);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 87: {
                            continue block13;
                        }
                    }
                    break;
                }
                this.jj_la1[40] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 149: {
                        this.jj_consume_token(149);
                        this.DeclConstant();
                        block14: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 10: 
                                case 17: 
                                case 87: 
                                case 149: 
                                case 154: 
                                case 156: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[41] = this.jj_gen;
                                    break block14;
                                }
                            }
                            this.DeclConstant();
                        }
                        this.jj_consume_token(150);
                        break block0;
                    }
                }
                this.jj_la1[42] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DeclConstant() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 154: {
                        this.jj_consume_token(154);
                        this.jj_consume_token(10);
                        break block0;
                    }
                }
                this.jj_la1[44] = this.jj_gen;
                break;
            }
            case 17: 
            case 149: 
            case 154: 
            case 156: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 156: {
                        this.jj_consume_token(156);
                        break block0;
                    }
                    case 154: {
                        this.jj_consume_token(154);
                        break block0;
                    }
                    case 87: {
                        this.jj_consume_token(87);
                        break block0;
                    }
                    case 149: {
                        this.jj_consume_token(149);
                        this.jj_consume_token(150);
                        break block0;
                    }
                    case 17: {
                        this.MultiLineString();
                        break block0;
                    }
                }
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token MultiLineString() throws ParseException {
        Token t = null;
        Token r = null;
        block3: while (true) {
            t = this.jj_consume_token(17);
            if (r == null) {
                r = t;
            } else {
                r.image = r.image.substring(0, r.image.length()) + t.image.substring(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[47] = this.jj_gen;
        return r;
    }

    public final void PragmaSpec() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                this.jj_consume_token(39);
                block7: while (true) {
                    this.PragmaSpecifier();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 109: 
                        case 112: {
                            continue block7;
                        }
                    }
                    break;
                }
                this.jj_la1[48] = this.jj_gen;
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                this.PragmaSpecifier();
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void PragmaSpecifier() throws ParseException {
        block45: {
            block44: {
                ds1 = null;
                ds2 = null;
                ds3 = null;
                if (!this.jj_2_19(3)) break block44;
                this.jj_consume_token(112);
                this.PragmaSpecifier();
                this.jj_consume_token(113);
                break block45;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 109: {
                    id = this.jj_consume_token(109);
                    block37: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 109: 
                            case 118: 
                            case 119: 
                            case 123: {
                                break;
                            }
                            default: {
                                this.jj_la1[50] = this.jj_gen;
                                ** GOTO lbl43
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 109: {
                                this.jj_consume_token(109);
                                continue block37;
                            }
                            case 119: {
                                this.jj_consume_token(119);
                                continue block37;
                            }
                            case 123: {
                                this.jj_consume_token(123);
                                continue block37;
                            }
                            case 118: {
                                this.jj_consume_token(118);
                                continue block37;
                            }
                        }
                        break;
                    }
                    this.jj_la1[51] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
lbl43:
                    // 1 sources

                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 112: {
                            this.jj_consume_token(112);
                            block17 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 109: 
                                case 112: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 119: 
                                case 123: {
                                    block38: while (true) {
                                        ds1 = this.PragmaConstant();
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 109: 
                                            case 112: 
                                            case 114: 
                                            case 115: 
                                            case 116: 
                                            case 119: 
                                            case 123: {
                                                continue block38;
                                            }
                                        }
                                        break;
                                    }
                                    this.jj_la1[52] = this.jj_gen;
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 118: {
                                            this.jj_consume_token(118);
                                            ds2 = this.PragmaConstant();
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 118: {
                                                    this.jj_consume_token(118);
                                                    ds3 = this.PragmaConstant();
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 118: {
                                                            block39: while (true) {
                                                                this.jj_consume_token(118);
                                                                this.PragmaConstant();
                                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                    case 118: {
                                                                        continue block39;
                                                                    }
                                                                }
                                                                break;
                                                            }
                                                            this.jj_la1[53] = this.jj_gen;
                                                            break block17;
                                                        }
                                                    }
                                                    this.jj_la1[54] = this.jj_gen;
                                                    break block17;
                                                }
                                            }
                                            this.jj_la1[55] = this.jj_gen;
                                            break block17;
                                        }
                                    }
                                    this.jj_la1[56] = this.jj_gen;
                                    break;
                                }
                                default: {
                                    this.jj_la1[57] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(113);
                            break;
                        }
                        default: {
                            this.jj_la1[58] = this.jj_gen;
                        }
                    }
                    if (id.image.equals("pack") && ds1 != null) {
                        newPackVal = ds1;
                        ID = ds2;
                        if (ds1.image.equals("pop")) {
                            this.packSize = this.popPack(ID);
                            newPackVal = null;
                        } else if (ds1.image.equals("push") && ds2 != null) {
                            try {
                                ival = Integer.parseInt(ds2.image);
                                newPackVal = ds2;
                                ID = null;
                            }
                            catch (NumberFormatException exc) {
                                newPackVal = ds3;
                                ID = ds2;
                            }
                            this.pushPack(ID, this.packSize);
                        }
                        if (newPackVal == null) break;
                        ival = this.packSize;
                        try {
                            ival = Integer.parseInt(newPackVal.image);
                        }
                        catch (NumberFormatException var8_9) {
                            // empty catch block
                        }
                        this.packSize = ival;
                        break;
                    }
                    if (!id.image.equals("pack")) break;
                    this.packSize = 0;
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final Token PragmaConstant() throws ParseException {
        Token val = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 119: {
                val = this.jj_consume_token(119);
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 116: {
                        this.jj_consume_token(116);
                        break;
                    }
                    case 115: {
                        this.jj_consume_token(115);
                        break;
                    }
                    case 114: {
                        this.jj_consume_token(114);
                        break;
                    }
                    default: {
                        this.jj_la1[60] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 109: 
                        case 112: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 119: 
                        case 123: {
                            break;
                        }
                        default: {
                            this.jj_la1[61] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.PragmaConstant();
                }
            }
            case 112: {
                block42: while (true) {
                    this.jj_consume_token(112);
                    block43: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 109: 
                            case 112: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 119: 
                            case 123: {
                                break;
                            }
                            default: {
                                this.jj_la1[62] = this.jj_gen;
                                break block43;
                            }
                        }
                        this.PragmaConstant();
                    }
                    this.jj_consume_token(113);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 112: {
                            continue block42;
                        }
                    }
                    break;
                }
                this.jj_la1[63] = this.jj_gen;
                break;
            }
            case 109: {
                val = this.jj_consume_token(109);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 117: 
                    case 123: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 123: {
                                this.jj_consume_token(123);
                                break block0;
                            }
                            case 117: {
                                this.jj_consume_token(117);
                                block44: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 119: {
                                            this.jj_consume_token(119);
                                            break;
                                        }
                                        case 109: {
                                            this.jj_consume_token(109);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[64] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 109: 
                                        case 119: {
                                            continue block44;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[65] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_la1[66] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[67] = this.jj_gen;
                break;
            }
            case 123: {
                val = this.jj_consume_token(123);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 109: {
                            break;
                        }
                        default: {
                            this.jj_la1[68] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(109);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 112: {
                            this.jj_consume_token(112);
                            this.jj_consume_token(113);
                            break;
                        }
                        default: {
                            this.jj_la1[69] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(123);
                }
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final void StaticAssert() throws ParseException {
        Integer evalue;
        Object expr = null;
        Token message = null;
        Token t = this.jj_consume_token(58);
        this.jj_consume_token(149);
        expr = this.ConstantExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 153: {
                this.jj_consume_token(153);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 17: {
                            message = this.jj_consume_token(17);
                            break;
                        }
                        case 156: {
                            this.jj_consume_token(156);
                            this.jj_consume_token(87);
                            break;
                        }
                        default: {
                            this.jj_la1[71] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 17: 
                        case 156: {
                            continue block10;
                        }
                    }
                    break;
                }
                this.jj_la1[72] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
            }
        }
        this.jj_consume_token(150);
        if (expr != null && (evalue = this.getConstantValue(expr, 1)) == 0) {
            String smessage = message == null ? "" : message.image;
            this.addNearParseMessage("Warning: Static_Assert possibly failed  \"" + smessage + "\"");
        }
    }

    public final DataType StructOrUnionSpecifier() throws ParseException {
        Declaration dec = new Declaration();
        this.typedefParsingStack.push(Boolean.FALSE);
        Token sname = null;
        Token t = null;
        Token parent = null;
        Composite comp = this.StructOrUnion();
        if (this.jj_2_21(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    t = this.jj_consume_token(87);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 154: {
                            this.jj_consume_token(154);
                            parent = this.jj_consume_token(87);
                            break;
                        }
                        default: {
                            this.jj_la1[74] = this.jj_gen;
                        }
                    }
                    comp = this.defineNamedComposite(t, null, comp);
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                }
            }
            this.jj_consume_token(146);
            if (this.jj_2_20(1)) {
                this.StructDeclarationList(comp);
            }
            this.jj_consume_token(147);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 49: 
                case 53: 
                case 56: 
                case 151: {
                    this.AttributeSpecList(dec);
                    break;
                }
                default: {
                    this.jj_la1[76] = this.jj_gen;
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    sname = this.jj_consume_token(87);
                    break;
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (t != null) {
            comp = this.defineNamedComposite(t, parent, comp);
        } else if (sname != null) {
            comp = this.defineForwardDeclaredComposite(sname, comp);
        }
        this.typedefParsingStack.pop();
        return comp;
    }

    /*
     * Unable to fully structure code
     */
    public final Composite StructOrUnion() throws ParseException {
        dec = new Declaration();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 49: 
                        case 53: 
                        case 56: 
                        case 151: {
                            break;
                        }
                        default: {
                            this.jj_la1[78] = this.jj_gen;
                            ** GOTO lbl24
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 38: 
                        case 41: 
                        case 49: 
                        case 53: 
                        case 56: 
                        case 151: {
                            this.DeclSpec(dec);
                            continue block14;
                        }
                        case 39: 
                        case 40: {
                            this.PragmaSpec();
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[79] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
lbl24:
                // 1 sources

                comp = new StructureDataType(this.getCurrentCategoryPath(), "_struct_" + this.cnt++, 0, this.dtMgr);
                if (this.packSize > 0) {
                    comp.setExplicitPackingValue(this.packSize);
                    break;
                }
                comp.setPackingEnabled(true);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 38: 
                        case 41: 
                        case 49: 
                        case 53: 
                        case 56: 
                        case 151: {
                            break;
                        }
                        default: {
                            this.jj_la1[80] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.DeclSpec(dec);
                }
                comp = new UnionDataType(this.getCurrentCategoryPath(), "_union_" + this.cnt++, this.dtMgr);
                if (this.packSize > 0) {
                    comp.setExplicitPackingValue(this.packSize);
                    break;
                }
                comp.setPackingEnabled(true);
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return comp;
    }

    public final void StructDeclarationList(Composite comp) throws ParseException {
        CompositeHandler compositeHandler = new CompositeHandler(comp);
        do {
            this.StructDeclaration(comp, compositeHandler);
        } while (this.jj_2_22(1));
    }

    public final void InitDeclaratorList(Declaration dt) throws ParseException {
        Declaration initialDT = new Declaration(dt);
        this.InitDeclarator(dt);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 153: {
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(153);
            dt = new Declaration(initialDT);
            this.InitDeclarator(dt);
        }
        if (!this.typedefParsingStack.empty() && this.typedefParsingStack.peek().booleanValue()) {
            this.typedefParsingStack.pop();
        }
    }

    public final void InitDeclarator(Declaration dt) throws ParseException {
        Declaration dec = this.Declarator(dt, null);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 155: {
                this.jj_consume_token(155);
                this.Initializer();
                break;
            }
            default: {
                this.jj_la1[83] = this.jj_gen;
            }
        }
        if (!this.typedefParsingStack.empty() && this.typedefParsingStack.peek().booleanValue()) {
            this.addTypedef(dec.getName(), dec.getDataType());
        } else if (dt.getDataType() instanceof FunctionDefinition) {
            this.addDef(this.functions, dec.getName(), dec.getDataType());
        }
    }

    public final void StructDeclaration(Composite comp, CompositeHandler compositeHandler) throws ParseException {
        Declaration dt = null;
        Declaration dec = new Declaration();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: 
            case 86: {
                this.LineDef();
                break;
            }
            case 58: {
                this.StaticAssert();
                break;
            }
            case 39: 
            case 40: {
                this.PragmaSpec();
                break;
            }
            default: {
                this.jj_la1[86] = this.jj_gen;
                if (this.jj_2_24(1)) {
                    if (this.jj_2_23(1)) {
                        dt = this.SpecifierQualifierList();
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 19: 
                        case 31: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 68: 
                        case 69: 
                        case 71: 
                        case 77: 
                        case 78: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 149: 
                        case 151: 
                        case 154: 
                        case 157: 
                        case 158: {
                            this.StructDeclaratorList(dt, comp, compositeHandler);
                            dt = null;
                            break;
                        }
                        default: {
                            this.jj_la1[84] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 49: 
                        case 53: 
                        case 56: 
                        case 151: {
                            this.AttributeSpecList(dec);
                            break;
                        }
                        default: {
                            this.jj_la1[85] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(148);
                    if (dt == null) break;
                    if (dt.getDataType().getLength() > 0) {
                        comp.add(dt.getDataType(), "", null);
                        break;
                    }
                    this.addNearParseMessage("BAD data type struct size  " + String.valueOf(dt));
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Declaration SpecifierQualifierList() throws ParseException {
        Declaration dt = new Declaration();
        Declaration sdt = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: 
            case 24: 
            case 33: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 74: 
            case 75: 
            case 80: {
                dt = this.BuiltInDeclarationSpecifier(dt);
                if (!this.jj_2_25(Integer.MAX_VALUE)) break;
                dt = this.TypeQualifierList(dt);
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
                if (this.jj_2_28(1)) {
                    dt = this.TypeSpecifier(dt);
                    if (this.jj_2_26(Integer.MAX_VALUE) && (dt == null || dt.getDataType() == null)) {
                        sdt = this.SpecifierQualifierList();
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 19: 
                        case 31: 
                        case 37: 
                        case 38: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 68: 
                        case 69: 
                        case 71: 
                        case 77: 
                        case 78: 
                        case 151: {
                            sdt = this.TypeQualifier(sdt != null ? sdt : dt);
                            break block0;
                        }
                    }
                    this.jj_la1[87] = this.jj_gen;
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: 
                    case 31: 
                    case 37: 
                    case 38: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 68: 
                    case 69: 
                    case 71: 
                    case 77: 
                    case 78: 
                    case 151: {
                        dt = this.TypeQualifier(dt);
                        if (!this.jj_2_27(Integer.MAX_VALUE)) break block0;
                        sdt = this.SpecifierQualifierList();
                        break block0;
                    }
                    default: {
                        this.jj_la1[89] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        if (sdt == null) {
            this.dataTypeStack.push(dt.getDataType());
            return dt;
        }
        return sdt;
    }

    public final void StructDeclaratorList(Declaration dt, Composite comp, CompositeHandler compositeHandler) throws ParseException {
        this.StructDeclarator(dt, comp, compositeHandler);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 153: {
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(153);
            this.StructDeclarator(dt, comp, compositeHandler);
        }
    }

    public final void StructDeclarator(Declaration dt, Composite comp, CompositeHandler compositeHandler) throws ParseException {
        Declaration dec = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: 
            case 86: {
                this.LineDef();
                break;
            }
            case 58: {
                this.StaticAssert();
                break;
            }
            case 19: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 68: 
            case 69: 
            case 71: 
            case 77: 
            case 78: 
            case 87: 
            case 149: 
            case 151: 
            case 154: 
            case 157: 
            case 158: {
                if (this.jj_2_29(3)) {
                    dec = this.Declarator(dt, (DataType)comp);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 154: {
                            this.jj_consume_token(154);
                            Object bitSizeObj = this.ConstantExpression();
                            Integer bitSize = this.getConstantValue(bitSizeObj, -1);
                            dec.setBitFieldSize(bitSize);
                            break;
                        }
                        default: {
                            this.jj_la1[91] = this.jj_gen;
                            break;
                        }
                    }
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 154: {
                            this.jj_consume_token(154);
                            Object bitSizeObj = this.ConstantExpression();
                            Integer bitSize = this.getConstantValue(bitSizeObj, -1);
                            dec = new Declaration(dt);
                            dec.setBitFieldSize(bitSize);
                            break;
                        }
                        default: {
                            this.jj_la1[92] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                try {
                    compositeHandler.add(dec);
                }
                catch (IllegalArgumentException e) {
                    this.addNearParseMessage("Bad structure size " + dec.getName() + "  length=" + dec.getDataType().getLength());
                }
                break;
            }
            default: {
                this.jj_la1[93] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final DataType EnumSpecifier() throws ParseException {
        DataType dt;
        Token t = null;
        Declaration dec = new Declaration();
        this.jj_consume_token(72);
        if (this.jj_2_30(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 49: 
                case 53: 
                case 56: 
                case 151: {
                    this.AttributeSpecList(dec);
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    t = this.jj_consume_token(87);
                    break;
                }
                default: {
                    this.jj_la1[95] = this.jj_gen;
                }
            }
            this.jj_consume_token(146);
            ArrayList<EnumMember> list = this.EnumeratorList();
            this.jj_consume_token(147);
            dt = this.allocateEnumDT(t, list);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    t = this.jj_consume_token(87);
                    dt = this.getEnumDef(t.image);
                    if (dt != null) break;
                    dt = this.allocateEnumDT(t, null);
                    break;
                }
                default: {
                    this.jj_la1[96] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return dt;
    }

    public final ArrayList<EnumMember> EnumeratorList() throws ParseException {
        ArrayList<EnumMember> list;
        block13: {
            int value = 0;
            list = new ArrayList<EnumMember>();
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 39: 
                    case 40: 
                    case 58: 
                    case 85: 
                    case 86: 
                    case 87: {
                        break;
                    }
                    default: {
                        this.jj_la1[97] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 85: 
                    case 86: {
                        this.LineDef();
                        continue block12;
                    }
                    case 39: 
                    case 40: {
                        this.PragmaSpec();
                        continue block12;
                    }
                    case 58: {
                        this.StaticAssert();
                        continue block12;
                    }
                    case 10: 
                    case 87: {
                        value = this.Enumerator(list, value);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 153: {
                                this.jj_consume_token(153);
                                break;
                            }
                            default: {
                                this.jj_la1[98] = this.jj_gen;
                            }
                        }
                        ++value;
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[99] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return list;
    }

    public final int Enumerator(ArrayList<EnumMember> list, int value) throws ParseException {
        Token t = null;
        Object obj = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 87: {
                t = this.jj_consume_token(87);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 155: {
                        this.jj_consume_token(155);
                        obj = this.ConstantExpression();
                        break;
                    }
                    default: {
                        this.jj_la1[100] = this.jj_gen;
                    }
                }
                Integer evalue = this.getConstantValue(obj, value);
                if (evalue != null) {
                    value = evalue;
                }
                list.add(new EnumMember(t.image, value));
                return value;
            }
            case 10: {
                t = this.jj_consume_token(10);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 155: {
                        this.jj_consume_token(155);
                        obj = this.ConstantExpression();
                        break;
                    }
                    default: {
                        this.jj_la1[101] = this.jj_gen;
                    }
                }
                Integer evalue = this.getConstantValue(obj, value);
                if (evalue != null) {
                    value = evalue;
                }
                list.add(new EnumMember(t.image, value));
                return value;
            }
        }
        this.jj_la1[102] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Declaration Declarator(Declaration dt, DataType container) throws ParseException {
        Declaration dec = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 31: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 68: 
            case 69: 
            case 71: 
            case 77: 
            case 78: 
            case 151: {
                dt = this.TypeQualifierList(dt);
                break;
            }
            default: {
                this.jj_la1[103] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 157: 
            case 158: {
                dt = this.Pointer(dt);
                break;
            }
            default: {
                this.jj_la1[104] = this.jj_gen;
            }
        }
        dec = this.DirectDeclarator(dt, container);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: 
            case 53: 
            case 56: 
            case 151: {
                this.AttributeSpecList(dec);
                break;
            }
            default: {
                this.jj_la1[105] = this.jj_gen;
            }
        }
        return dec;
    }

    public final Declaration DirectDeclarator(Declaration dt, DataType container) throws ParseException {
        FunctionDefinitionDataType funcDT;
        Declaration funcDec;
        Declaration dec;
        block33: {
            dec = null;
            funcDec = null;
            funcDT = null;
            Object obj = null;
            ArrayList<Integer> list = new ArrayList<Integer>();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 39: 
                case 40: {
                    this.PragmaSpec();
                    break;
                }
                default: {
                    this.jj_la1[106] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    Token t = this.jj_consume_token(87);
                    dec = new Declaration(dt, t.image);
                    break;
                }
                case 149: {
                    this.jj_consume_token(149);
                    funcDT = this.newAnonymousFunction(funcDT);
                    dec = this.Declarator(new Declaration((DataType)funcDT), null);
                    this.jj_consume_token(150);
                    break;
                }
                default: {
                    this.jj_la1[107] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.lastDataType = dec.getDataType();
            block24: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 151: {
                        break;
                    }
                    default: {
                        this.jj_la1[108] = this.jj_gen;
                        break block24;
                    }
                }
                this.jj_consume_token(151);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 50: 
                    case 87: 
                    case 149: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 162: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: {
                        obj = this.ConditionalExpression();
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                    }
                }
                this.jj_consume_token(152);
                Integer size = this.getConstantValue(obj, 0);
                if (size == null) {
                    System.out.println("BAD ARRAY SIZE! " + String.valueOf(obj));
                    size = 0;
                }
                list.add(0, size);
            }
            if (list.size() > 0) {
                dec.setDataType(dt.getDataType());
                for (Integer iSize : list) {
                    DataType decDt = dec.getDataType();
                    dec.setDataType((DataType)new ArrayDataType(decDt, iSize.intValue(), decDt.getLength()));
                }
            }
            block26: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 149: {
                        break;
                    }
                    default: {
                        this.jj_la1[110] = this.jj_gen;
                        break block33;
                    }
                }
                if (this.jj_2_31(3)) {
                    this.jj_consume_token(149);
                    funcDT = this.newAnonymousFunction(funcDT);
                    funcDec = this.ParameterTypeList(funcDT, dt.getDataType());
                    this.jj_consume_token(150);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 149: {
                        this.jj_consume_token(149);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 87: {
                                funcDT = this.newAnonymousFunction(funcDT);
                                this.IdentifierList(funcDT, dt.getDataType());
                                break;
                            }
                            default: {
                                this.jj_la1[111] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(150);
                        funcDT = this.newAnonymousFunction(funcDT);
                        funcDec = new Declaration((DataType)funcDT, "__paramIDList__");
                        continue block26;
                    }
                }
                break;
            }
            this.jj_la1[112] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (funcDec != null) {
            try {
                if (container == null) {
                    funcDT.setName(dec.getName());
                }
                funcDec.setName(dec.getName());
                if (dec.getDataType() != null) {
                    funcDec.setDataType(dec.getDataType());
                }
            }
            catch (InvalidNameException e) {
                throw new ParseException("duplicate name " + dec.getName());
            }
            DataType retDT = dt.getDataType();
            this.checkReturnDataType(retDT);
            funcDT.setReturnType(retDT);
            this.applyFunctionQualifiers(dt, (FunctionDefinition)funcDT);
            dec = funcDec;
            this.defineAndReplaceFunction(dec, funcDT);
        }
        return dec;
    }

    public final Declaration Pointer(Declaration dec) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 157: {
                this.jj_consume_token(157);
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                break;
            }
            default: {
                this.jj_la1[113] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 31: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 68: 
            case 69: 
            case 71: 
            case 77: 
            case 78: 
            case 151: {
                dec = this.TypeQualifierList(dec);
                break;
            }
            default: {
                this.jj_la1[114] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 157: 
            case 158: {
                dec = this.Pointer(dec);
                break;
            }
            default: {
                this.jj_la1[115] = this.jj_gen;
            }
        }
        dec.setDataType((DataType)this.dtMgr.getPointer(dec.getDataType()));
        return dec;
    }

    public final Declaration TypeQualifierList(Declaration dec) throws ParseException {
        block3: while (true) {
            dec = this.TypeQualifier(dec);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 31: 
                case 37: 
                case 38: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 68: 
                case 69: 
                case 71: 
                case 77: 
                case 78: 
                case 151: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[116] = this.jj_gen;
        return dec;
    }

    public final Declaration ParameterTypeList(FunctionDefinitionDataType funcDT, DataType retDT) throws ParseException {
        Token varargs = null;
        ArrayList<Declaration> list = this.ParameterList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 153: {
                this.jj_consume_token(153);
                varargs = this.jj_consume_token(159);
                break;
            }
            default: {
                this.jj_la1[117] = this.jj_gen;
            }
        }
        this.checkReturnDataType(retDT);
        if (funcDT == null) {
            funcDT = new FunctionDefinitionDataType(this.getCurrentCategoryPath("functions"), ANONYMOUS_FUNC_PREFIX, this.dtMgr);
        }
        funcDT.setVarArgs(varargs != null);
        Declaration firstDeclaration = null;
        ParameterDefinition[] variables = new ParameterDefinition[list.size()];
        if (variables.length == 1) {
            firstDeclaration = list.get(0);
        }
        for (int i = 0; i < variables.length; ++i) {
            Declaration dec = list.get(i);
            DataType varDT = dec.getDataType();
            if (variables.length == 1 && varDT instanceof VoidDataType) {
                variables = new ParameterDefinition[]{};
                break;
            }
            variables[i] = new ParameterDefinitionImpl(dec.getName(), dec.getDataType(), null);
        }
        funcDT.setReturnType(retDT);
        funcDT.setArguments(variables);
        Declaration dec = new Declaration((DataType)funcDT);
        if (firstDeclaration != null) {
            dec.addQualifiers(firstDeclaration);
        }
        return dec;
    }

    public final ArrayList<Declaration> ParameterList() throws ParseException {
        ArrayList<Declaration> list = new ArrayList<Declaration>();
        this.ParameterDeclaration(list);
        while (this.jj_2_32(2)) {
            this.jj_consume_token(153);
            this.ParameterDeclaration(list);
        }
        return list;
    }

    public final void ParameterDeclaration(ArrayList<Declaration> list) throws ParseException {
        DataType decDT;
        Declaration dt = new Declaration();
        Declaration dec = new Declaration();
        dt = this.DeclarationSpecifiers(dec);
        if (this.jj_2_33(Integer.MAX_VALUE)) {
            dec = this.Declarator(dt, null);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 149: 
                case 151: 
                case 157: 
                case 158: {
                    dec = this.AbstractDeclarator(dt);
                    break;
                }
                default: {
                    this.jj_la1[118] = this.jj_gen;
                }
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 155: {
                this.jj_consume_token(155);
                this.jj_consume_token(10);
                break;
            }
            default: {
                this.jj_la1[119] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: {
                this.PragmaSpec();
                break;
            }
            default: {
                this.jj_la1[120] = this.jj_gen;
            }
        }
        if (dec == null) {
            dec = new Declaration(dt);
        }
        if ((decDT = dec.getDataType()) != null) {
            if (!(decDT.getLength() >= 0 || decDT instanceof FunctionDefinition || decDT instanceof TypeDef && ((TypeDef)decDT).getDataType() instanceof FunctionDefinition)) {
                throw new ParseException("'" + decDT.getName() + "' is not fixed length.  Function parameters must use fixed length data type.");
            }
            list.add(dec);
        }
    }

    public final void IdentifierList(FunctionDefinitionDataType funcDT, DataType retDT) throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        Token t = this.jj_consume_token(87);
        list.add(t.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 153: {
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(153);
            t = this.jj_consume_token(87);
            list.add(t.image);
        }
        this.checkReturnDataType(retDT);
        ParameterDefinition[] variables = new ParameterDefinition[list.size()];
        for (int i = 0; i < variables.length; ++i) {
            variables[i] = new ParameterDefinitionImpl((String)list.get(i), null, null);
        }
        funcDT.setReturnType(retDT);
        funcDT.setArguments(variables);
    }

    public final void Initializer() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 25: 
            case 50: 
            case 87: 
            case 149: 
            case 157: 
            case 158: 
            case 161: 
            case 162: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                this.AssignmentExpression();
                break;
            }
            case 146: {
                this.jj_consume_token(146);
                this.InitializerList();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 153: {
                        this.jj_consume_token(153);
                        break;
                    }
                    default: {
                        this.jj_la1[122] = this.jj_gen;
                    }
                }
                this.jj_consume_token(147);
                break;
            }
            default: {
                this.jj_la1[123] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void InitializerList() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 151: 
            case 160: {
                this.Designation();
                break;
            }
            default: {
                this.jj_la1[124] = this.jj_gen;
            }
        }
        this.Initializer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 153: {
                this.jj_consume_token(153);
                this.InitializerList();
                break;
            }
            default: {
                this.jj_la1[125] = this.jj_gen;
            }
        }
    }

    public final void Designation() throws ParseException {
        this.DesignatorList();
        this.jj_consume_token(155);
    }

    public final void DesignatorList() throws ParseException {
        this.Designator();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 151: 
            case 160: {
                this.DesignatorList();
                break;
            }
            default: {
                this.jj_la1[126] = this.jj_gen;
            }
        }
    }

    public final void Designator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 151: {
                this.jj_consume_token(151);
                this.ConstantExpression();
                this.jj_consume_token(152);
                break;
            }
            case 160: {
                this.jj_consume_token(160);
                this.jj_consume_token(87);
                break;
            }
            default: {
                this.jj_la1[127] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Declaration TypeName() throws ParseException {
        Declaration dec = null;
        dec = this.SpecifierQualifierList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 149: 
            case 151: 
            case 157: 
            case 158: {
                dec = this.AbstractDeclarator(new Declaration(dec));
                break;
            }
            default: {
                this.jj_la1[128] = this.jj_gen;
            }
        }
        return dec;
    }

    public final Declaration AbstractDeclarator(Declaration dt) throws ParseException {
        Declaration dec = null;
        if (this.jj_2_34(3)) {
            dec = this.DirectAbstractDeclarator(dt);
            return dec;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 157: 
            case 158: {
                dt = this.Pointer(dt);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 149: 
                    case 151: {
                        dec = this.DirectAbstractDeclarator(dt);
                        return dec;
                    }
                }
                this.jj_la1[129] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[130] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new Declaration(dt);
    }

    public final Declaration DirectAbstractDeclarator(Declaration dt) throws ParseException {
        Integer size;
        Declaration dec = dt;
        Declaration paramDec = null;
        FunctionDefinitionDataType funcDT = null;
        Object constObj = null;
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (this.jj_2_36(2)) {
            this.jj_consume_token(149);
            funcDT = this.newAnonymousFunction(null);
            dec = new Declaration((DataType)funcDT);
            dec = this.AbstractDeclarator(dec);
            this.jj_consume_token(150);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 151: {
                    this.jj_consume_token(151);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 10: 
                        case 14: 
                        case 16: 
                        case 17: 
                        case 25: 
                        case 50: 
                        case 87: 
                        case 149: 
                        case 157: 
                        case 158: 
                        case 161: 
                        case 162: 
                        case 188: 
                        case 189: 
                        case 190: 
                        case 191: {
                            constObj = this.ConstantExpression();
                            break;
                        }
                        default: {
                            this.jj_la1[131] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(152);
                    size = this.getConstantValue(constObj, 0);
                    list.add(0, size);
                    break;
                }
                case 149: {
                    this.jj_consume_token(149);
                    if (this.jj_2_35(1)) {
                        funcDT = this.newAnonymousFunction(null);
                        dec = this.ParameterTypeList(funcDT, dt.getDataType());
                    }
                    this.jj_consume_token(150);
                    funcDT = (FunctionDefinitionDataType)dec.getDataType();
                    dec.setDataType((DataType)this.dtMgr.getPointer((DataType)funcDT));
                    break;
                }
                default: {
                    this.jj_la1[132] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 151: {
                    break;
                }
                default: {
                    this.jj_la1[133] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(151);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 14: 
                case 16: 
                case 17: 
                case 25: 
                case 50: 
                case 87: 
                case 149: 
                case 157: 
                case 158: 
                case 161: 
                case 162: 
                case 188: 
                case 189: 
                case 190: 
                case 191: {
                    constObj = this.ConstantExpression();
                    break;
                }
                default: {
                    this.jj_la1[134] = this.jj_gen;
                }
            }
            this.jj_consume_token(152);
            size = this.getConstantValue(constObj, 0);
            list.add(0, size);
        }
        if (list.size() > 0) {
            for (Integer iSize : list) {
                DataType decDt = dec.getDataType();
                dec.setDataType((DataType)new ArrayDataType(decDt, iSize.intValue(), decDt.getLength()));
            }
        }
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 149: {
                    break;
                }
                default: {
                    this.jj_la1[135] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(149);
            if (this.jj_2_37(1)) {
                paramDec = this.ParameterTypeList(funcDT, dt.getDataType());
            }
            this.jj_consume_token(150);
            dec = funcDT != null ? dec : paramDec;
        }
        if (funcDT != null) {
            List<Integer> dtQualifiers = dt.getQualifiers();
            if (dtQualifiers == null || dtQualifiers.isEmpty()) {
                dt = dec;
            }
            this.applyFunctionQualifiers(dt, (FunctionDefinition)funcDT);
            this.defineAndReplaceFunction(dec, funcDT);
        }
        return dec;
    }

    public final DataType TypedefName() throws ParseException {
        Token t = this.jj_consume_token(87);
        return this.getType(t.image);
    }

    public final void Statement() throws ParseException {
        if (this.jj_2_38(2)) {
            this.AsmStatement();
        } else if (this.jj_2_39(3)) {
            this.DeclarationList();
        } else if (this.jj_2_40(2)) {
            this.LabeledStatement();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 14: 
                case 16: 
                case 17: 
                case 25: 
                case 50: 
                case 87: 
                case 148: 
                case 149: 
                case 157: 
                case 158: 
                case 161: 
                case 162: 
                case 188: 
                case 189: 
                case 190: 
                case 191: {
                    this.ExpressionStatement();
                    break;
                }
                case 146: {
                    this.CompoundStatement();
                    break;
                }
                case 26: 
                case 81: {
                    this.SelectionStatement();
                    break;
                }
                case 34: 
                case 79: 
                case 82: {
                    this.IterationStatement();
                    break;
                }
                case 18: 
                case 27: 
                case 35: 
                case 76: {
                    this.JumpStatement();
                    break;
                }
                case 56: {
                    this.AsmStatement();
                    break;
                }
                case 39: 
                case 40: {
                    this.PragmaSpec();
                    break;
                }
                case 58: {
                    this.StaticAssert();
                    break;
                }
                default: {
                    this.jj_la1[136] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void LabeledStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 87: {
                this.jj_consume_token(87);
                this.jj_consume_token(154);
                this.Statement();
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                this.ConstantExpression();
                this.jj_consume_token(154);
                this.Statement();
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(154);
                this.Statement();
                break;
            }
            default: {
                this.jj_la1[137] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ExpressionStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 25: 
            case 50: 
            case 87: 
            case 149: 
            case 157: 
            case 158: 
            case 161: 
            case 162: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                this.Expression();
                break;
            }
            default: {
                this.jj_la1[138] = this.jj_gen;
            }
        }
        this.jj_consume_token(148);
    }

    public final void CompoundStatement() throws ParseException {
        this.jj_consume_token(146);
        if (this.jj_2_41(1)) {
            this.StatementList();
        }
        this.jj_consume_token(147);
    }

    public final void StatementList() throws ParseException {
        do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 85: 
                case 86: {
                    this.LineDef();
                    break;
                }
                default: {
                    this.jj_la1[139] = this.jj_gen;
                    if (this.jj_2_42(1)) {
                        this.Statement();
                        break;
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        } while (this.jj_2_43(1));
    }

    public final void AsmStatement() throws ParseException {
        Declaration dec = new Declaration();
        this.jj_consume_token(56);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 31: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 68: 
            case 69: 
            case 71: 
            case 77: 
            case 78: 
            case 151: {
                this.TypeQualifier(dec);
                break;
            }
            default: {
                this.jj_la1[140] = this.jj_gen;
            }
        }
        this.AsmLine();
    }

    public final void AsmLine() throws ParseException {
        Declaration dec = new Declaration();
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    this.jj_consume_token(87);
                    break;
                }
                case 17: {
                    this.jj_consume_token(17);
                    break;
                }
                case 10: {
                    this.jj_consume_token(10);
                    break;
                }
                case 53: {
                    this.jj_consume_token(53);
                    break;
                }
                case 21: 
                case 24: 
                case 33: 
                case 59: 
                case 60: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 70: 
                case 74: 
                case 75: 
                case 80: {
                    this.BuiltInTypeSpecifier(dec);
                    break;
                }
                case 156: {
                    this.jj_consume_token(156);
                    break;
                }
                case 161: {
                    this.jj_consume_token(161);
                    break;
                }
                case 162: {
                    this.jj_consume_token(162);
                    break;
                }
                case 153: {
                    this.jj_consume_token(153);
                    break;
                }
                case 154: {
                    this.jj_consume_token(154);
                    break;
                }
                case 157: {
                    this.jj_consume_token(157);
                    break;
                }
                case 151: {
                    this.jj_consume_token(151);
                    this.AsmLine();
                    this.jj_consume_token(152);
                    break;
                }
                case 149: {
                    this.jj_consume_token(149);
                    this.AsmLine();
                    this.jj_consume_token(150);
                    break;
                }
                case 146: {
                    this.jj_consume_token(146);
                    this.AsmLine();
                    this.jj_consume_token(147);
                    break;
                }
                default: {
                    this.jj_la1[141] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 17: 
                case 21: 
                case 24: 
                case 33: 
                case 53: 
                case 59: 
                case 60: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 70: 
                case 74: 
                case 75: 
                case 80: 
                case 87: 
                case 146: 
                case 149: 
                case 151: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 161: 
                case 162: {
                    continue block19;
                }
            }
            break;
        }
        this.jj_la1[142] = this.jj_gen;
    }

    public final void SelectionStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: {
                this.jj_consume_token(81);
                this.jj_consume_token(149);
                this.Expression();
                this.jj_consume_token(150);
                this.Statement();
                if (!this.jj_2_44(2)) break;
                this.jj_consume_token(61);
                this.Statement();
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                this.jj_consume_token(149);
                this.Expression();
                this.jj_consume_token(150);
                this.Statement();
                break;
            }
            default: {
                this.jj_la1[143] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void IterationStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                this.jj_consume_token(149);
                this.Expression();
                this.jj_consume_token(150);
                this.Statement();
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                this.Statement();
                this.jj_consume_token(34);
                this.jj_consume_token(149);
                this.Expression();
                this.jj_consume_token(150);
                this.jj_consume_token(148);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                this.jj_consume_token(149);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 50: 
                    case 87: 
                    case 149: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 162: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: {
                        this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[144] = this.jj_gen;
                    }
                }
                this.jj_consume_token(148);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 50: 
                    case 87: 
                    case 149: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 162: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: {
                        this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[145] = this.jj_gen;
                    }
                }
                this.jj_consume_token(148);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 50: 
                    case 87: 
                    case 149: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 162: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: {
                        this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[146] = this.jj_gen;
                    }
                }
                this.jj_consume_token(150);
                this.Statement();
                break;
            }
            default: {
                this.jj_la1[147] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void JumpStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: {
                this.jj_consume_token(76);
                this.jj_consume_token(87);
                this.jj_consume_token(148);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                this.jj_consume_token(148);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                this.jj_consume_token(148);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 50: 
                    case 87: 
                    case 149: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 162: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: {
                        this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[148] = this.jj_gen;
                    }
                }
                this.jj_consume_token(148);
                break;
            }
            default: {
                this.jj_la1[149] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Object Expression() throws ParseException {
        Object obj = null;
        obj = this.AssignmentExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 153: {
                    break;
                }
                default: {
                    this.jj_la1[150] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(153);
            obj = this.AssignmentExpression();
        }
        return obj;
    }

    public final Object AssignmentExpression() throws ParseException {
        Object obj = null;
        if (this.jj_2_45(Integer.MAX_VALUE)) {
            this.UnaryExpression();
            this.AssignmentOperator();
            obj = this.AssignmentExpression();
        } else if (this.jj_2_46(3)) {
            obj = this.ConditionalExpression();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: {
                this.PragmaSpec();
                break;
            }
            default: {
                this.jj_la1[151] = this.jj_gen;
            }
        }
        return obj;
    }

    public final void AssignmentOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 155: {
                this.jj_consume_token(155);
                break;
            }
            case 163: {
                this.jj_consume_token(163);
                break;
            }
            case 164: {
                this.jj_consume_token(164);
                break;
            }
            case 165: {
                this.jj_consume_token(165);
                break;
            }
            case 166: {
                this.jj_consume_token(166);
                break;
            }
            case 167: {
                this.jj_consume_token(167);
                break;
            }
            case 168: {
                this.jj_consume_token(168);
                break;
            }
            case 169: {
                this.jj_consume_token(169);
                break;
            }
            case 170: {
                this.jj_consume_token(170);
                break;
            }
            case 171: {
                this.jj_consume_token(171);
                break;
            }
            case 172: {
                this.jj_consume_token(172);
                break;
            }
            default: {
                this.jj_la1[152] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Object ConditionalExpression() throws ParseException {
        Object obj = null;
        Object objTrue = null;
        Object objFalse = null;
        obj = this.LogicalORExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 173: {
                this.jj_consume_token(173);
                objTrue = this.Expression();
                this.jj_consume_token(154);
                objFalse = this.ConditionalExpression();
                obj = this.computeTernaryValue(obj, objTrue, objFalse);
                break;
            }
            default: {
                this.jj_la1[153] = this.jj_gen;
            }
        }
        return obj;
    }

    public final Object ConstantExpression() throws ParseException {
        Object obj = null;
        obj = this.ConditionalExpression();
        return obj;
    }

    public final Object LogicalORExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.LogicalANDExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 174: {
                    break;
                }
                default: {
                    this.jj_la1[154] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(174);
            obj2 = this.LogicalANDExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object LogicalANDExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.InclusiveORExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 175: {
                    break;
                }
                default: {
                    this.jj_la1[155] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(175);
            obj2 = this.InclusiveORExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object InclusiveORExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.ExclusiveORExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 176: {
                    break;
                }
                default: {
                    this.jj_la1[156] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(176);
            obj2 = this.ExclusiveORExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object ExclusiveORExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.ANDExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 177: {
                    break;
                }
                default: {
                    this.jj_la1[157] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(177);
            obj2 = this.ANDExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object ANDExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.EqualityExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 158: {
                    break;
                }
                default: {
                    this.jj_la1[158] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(158);
            obj2 = this.EqualityExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object EqualityExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.RelationalExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 178: 
                case 179: {
                    break;
                }
                default: {
                    this.jj_la1[159] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 178: {
                    op = this.jj_consume_token(178);
                    break;
                }
                case 179: {
                    op = this.jj_consume_token(179);
                    break;
                }
                default: {
                    this.jj_la1[160] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.RelationalExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object RelationalExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.ShiftExpression();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 180: 
                case 181: 
                case 182: 
                case 183: {
                    break;
                }
                default: {
                    this.jj_la1[161] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 180: {
                    op = this.jj_consume_token(180);
                    break;
                }
                case 181: {
                    op = this.jj_consume_token(181);
                    break;
                }
                case 182: {
                    op = this.jj_consume_token(182);
                    break;
                }
                case 183: {
                    op = this.jj_consume_token(183);
                    break;
                }
                default: {
                    this.jj_la1[162] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.ShiftExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object ShiftExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.AdditiveExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 184: 
                case 185: {
                    break;
                }
                default: {
                    this.jj_la1[163] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 184: {
                    op = this.jj_consume_token(184);
                    break;
                }
                case 185: {
                    op = this.jj_consume_token(185);
                    break;
                }
                default: {
                    this.jj_la1[164] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.AdditiveExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object AdditiveExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.MultiplicativeExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 161: 
                case 162: {
                    break;
                }
                default: {
                    this.jj_la1[165] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 161: {
                    op = this.jj_consume_token(161);
                    break;
                }
                case 162: {
                    op = this.jj_consume_token(162);
                    break;
                }
                default: {
                    this.jj_la1[166] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.MultiplicativeExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object MultiplicativeExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.CastExpression();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 157: 
                case 186: 
                case 187: {
                    break;
                }
                default: {
                    this.jj_la1[167] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 157: {
                    op = this.jj_consume_token(157);
                    break;
                }
                case 186: {
                    op = this.jj_consume_token(186);
                    break;
                }
                case 187: {
                    op = this.jj_consume_token(187);
                    break;
                }
                default: {
                    this.jj_la1[168] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.CastExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object CastExpression() throws ParseException {
        Object obj;
        block11: {
            block10: {
                obj = null;
                if (!this.jj_2_47(Integer.MAX_VALUE)) break block10;
                this.jj_consume_token(149);
                this.TypeName();
                this.jj_consume_token(150);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 50: 
                    case 87: 
                    case 149: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 162: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: {
                        obj = this.CastExpression();
                        break block11;
                    }
                    case 146: {
                        this.jj_consume_token(146);
                        this.InitializerList();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 153: {
                                this.jj_consume_token(153);
                                break;
                            }
                            default: {
                                this.jj_la1[169] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(147);
                        break block11;
                    }
                    default: {
                        this.jj_la1[170] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 14: 
                case 16: 
                case 17: 
                case 25: 
                case 50: 
                case 87: 
                case 149: 
                case 157: 
                case 158: 
                case 161: 
                case 162: 
                case 188: 
                case 189: 
                case 190: 
                case 191: {
                    obj = this.UnaryExpression();
                    break;
                }
                default: {
                    this.jj_la1[171] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return obj;
    }

    public final Object UnaryExpression() throws ParseException {
        Object obj = null;
        Token op = null;
        Declaration dec = null;
        if (this.jj_2_49(3)) {
            obj = this.PostfixExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 157: 
                case 158: {
                    this.UnaryOperator();
                    this.CastExpression();
                    break;
                }
                case 188: {
                    this.jj_consume_token(188);
                    this.UnaryExpression();
                    break;
                }
                case 189: {
                    this.jj_consume_token(189);
                    this.UnaryExpression();
                    break;
                }
                case 161: {
                    this.jj_consume_token(161);
                    obj = this.CastExpression();
                    break;
                }
                case 162: {
                    op = this.jj_consume_token(162);
                    obj = this.CastExpression();
                    obj = this.computeUnaryValue(obj, op);
                    break;
                }
                case 190: {
                    op = this.jj_consume_token(190);
                    obj = this.CastExpression();
                    obj = this.computeUnaryValue(obj, op);
                    break;
                }
                case 191: {
                    op = this.jj_consume_token(191);
                    obj = this.CastExpression();
                    obj = this.computeUnaryValue(obj, op);
                    break;
                }
                case 25: {
                    this.jj_consume_token(25);
                    this.jj_consume_token(149);
                    if (this.jj_2_48(1)) {
                        dec = this.TypeName();
                    } else {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: 
                            case 14: 
                            case 16: 
                            case 17: 
                            case 25: 
                            case 50: 
                            case 87: 
                            case 149: 
                            case 157: 
                            case 158: 
                            case 161: 
                            case 162: 
                            case 188: 
                            case 189: 
                            case 190: 
                            case 191: {
                                obj = this.UnaryExpression();
                                break;
                            }
                            default: {
                                this.jj_la1[172] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    this.jj_consume_token(150);
                    if (obj != null && obj instanceof String) {
                        obj = (long)(((String)obj).length() - 1);
                        break;
                    }
                    if (dec != null) {
                        obj = (long)dec.getDataType().clone(this.dtMgr).getLength();
                        break;
                    }
                    if (obj == null) break;
                    break;
                }
                case 50: {
                    this.jj_consume_token(50);
                    this.jj_consume_token(149);
                    dec = this.TypeName();
                    this.jj_consume_token(150);
                    break;
                }
                default: {
                    this.jj_la1[173] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return obj;
    }

    public final void UnaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 158: {
                this.jj_consume_token(158);
                break;
            }
            case 157: {
                this.jj_consume_token(157);
                break;
            }
            default: {
                this.jj_la1[174] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Object PostfixExpression() throws ParseException {
        Object obj;
        block13: {
            obj = null;
            obj = this.PrimaryExpression();
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 149: 
                    case 151: 
                    case 160: 
                    case 188: 
                    case 189: 
                    case 192: {
                        break;
                    }
                    default: {
                        this.jj_la1[175] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 151: {
                        this.jj_consume_token(151);
                        this.Expression();
                        this.jj_consume_token(152);
                        continue block11;
                    }
                    case 149: {
                        this.jj_consume_token(149);
                        if (this.jj_2_50(Integer.MAX_VALUE)) {
                            this.ArgumentExpressionList();
                        }
                        this.jj_consume_token(150);
                        continue block11;
                    }
                    case 160: {
                        this.jj_consume_token(160);
                        this.jj_consume_token(87);
                        continue block11;
                    }
                    case 192: {
                        this.jj_consume_token(192);
                        this.jj_consume_token(87);
                        continue block11;
                    }
                    case 188: {
                        this.jj_consume_token(188);
                        continue block11;
                    }
                    case 189: {
                        this.jj_consume_token(189);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[176] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return obj;
    }

    public final Object PrimaryExpression() throws ParseException {
        Object obj = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 87: {
                obj = this.jj_consume_token(87);
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 17: {
                obj = this.Constant();
                break;
            }
            case 149: {
                this.jj_consume_token(149);
                obj = this.Expression();
                this.jj_consume_token(150);
                break;
            }
            default: {
                this.jj_la1[177] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return obj;
    }

    public final void ArgumentExpressionList() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: {
                this.PragmaSpec();
                break;
            }
            default: {
                this.jj_la1[178] = this.jj_gen;
            }
        }
        this.AssignmentExpression();
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 153: {
                    break;
                }
                default: {
                    this.jj_la1[179] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(153);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 39: 
                case 40: {
                    this.PragmaSpec();
                    break;
                }
                default: {
                    this.jj_la1[180] = this.jj_gen;
                }
            }
            this.AssignmentExpression();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: {
                this.PragmaSpec();
                break;
            }
            default: {
                this.jj_la1[181] = this.jj_gen;
            }
        }
    }

    public final Object Constant() throws ParseException {
        Object obj = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                Token t = this.jj_consume_token(10);
                String sval = t.image;
                if (sval.endsWith("i8") || sval.endsWith("I8")) {
                    sval = sval.substring(0, sval.length() - 2);
                } else if (sval.endsWith("i16") || sval.endsWith("I16")) {
                    sval = sval.substring(0, sval.length() - 3);
                } else if (sval.endsWith("i32") || sval.endsWith("I32")) {
                    sval = sval.substring(0, sval.length() - 3);
                } else if (sval.endsWith("i64") || sval.endsWith("I64")) {
                    sval = sval.substring(0, sval.length() - 3);
                }
                if (sval.endsWith("ull") || sval.endsWith("ULL")) {
                    sval = sval.substring(0, sval.length() - 3);
                } else if (sval.endsWith("ll") || sval.endsWith("LL")) {
                    sval = sval.substring(0, sval.length() - 2);
                } else if (sval.endsWith("ul") || sval.endsWith("UL")) {
                    sval = sval.substring(0, sval.length() - 2);
                } else if (sval.endsWith("l") || sval.endsWith("L")) {
                    sval = sval.substring(0, sval.length() - 1);
                } else if (sval.endsWith("u") || sval.endsWith("U")) {
                    sval = sval.substring(0, sval.length() - 1);
                }
                if (sval.startsWith("0x") || sval.startsWith("0X")) {
                    BigInteger bigConst = new BigInteger(sval.substring(2), 16);
                    obj = bigConst.longValue();
                    break;
                }
                BigInteger bigConst = new BigInteger(sval);
                obj = bigConst.longValue();
                break;
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                obj = new Double(t.image);
                break;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                if (t.image.length() == 1) {
                    obj = new Character(t.image.charAt(0));
                    break;
                }
                if (t.image.length() != 4) break;
                long cval = ((long)t.image.charAt(0) << 24) + ((long)t.image.charAt(1) << 16) + ((long)t.image.charAt(2) << 8) + (long)t.image.charAt(3);
                obj = cval;
                break;
            }
            case 17: {
                Token t = this.MultiLineString();
                obj = t.image;
                break;
            }
            default: {
                this.jj_la1[182] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    private boolean jj_3R_205() {
        return this.jj_3R_164();
    }

    private boolean jj_3R_144() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(85)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(86)) {
                return true;
            }
        }
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_scan_token(99)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_376()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_204() {
        return this.jj_3R_163();
    }

    private boolean jj_3R_157() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(87)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_220()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_221()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_124() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_203()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_204()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_205()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_206()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_203() {
        return this.jj_3R_144();
    }

    private boolean jj_3_50() {
        return this.jj_3R_84();
    }

    private boolean jj_3R_70() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_124());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_225() {
        if (this.jj_scan_token(192)) {
            return true;
        }
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_88() {
        return this.jj_3R_144();
    }

    private boolean jj_3_3() {
        if (this.jj_3R_51()) {
            return true;
        }
        return this.jj_scan_token(146);
    }

    private boolean jj_3R_224() {
        if (this.jj_scan_token(160)) {
            return true;
        }
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_87() {
        return this.jj_3R_164();
    }

    private boolean jj_3R_272() {
        return this.jj_3R_84();
    }

    private boolean jj_3R_86() {
        return this.jj_3R_163();
    }

    private boolean jj_3_4() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_223() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_272()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_300() {
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_158() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_222()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_223()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_224()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_225()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(188)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(189)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_222() {
        if (this.jj_scan_token(151)) {
            return true;
        }
        if (this.jj_3R_219()) {
            return true;
        }
        return this.jj_scan_token(152);
    }

    private boolean jj_3R_85() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_69() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_336() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        return this.jj_3R_192();
    }

    private boolean jj_3_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(87)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(146)) {
            return true;
        }
        if (this.jj_3R_70()) {
            return true;
        }
        return this.jj_scan_token(147);
    }

    private boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_4()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_86()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_87()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_88()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(148)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_68() {
        if (this.jj_scan_token(154)) {
            return true;
        }
        return this.jj_3R_123();
    }

    private boolean jj_3R_83() {
        Token xsp;
        if (this.jj_3R_157()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_158());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_172() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_300()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_216() {
        return this.jj_3R_79();
    }

    private boolean jj_3R_214() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(158)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(157)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_153() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_82()) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_283() {
        if (this.jj_scan_token(154)) {
            return true;
        }
        return this.jj_3R_123();
    }

    private boolean jj_3_48() {
        return this.jj_3R_82();
    }

    private boolean jj_3_29() {
        if (this.jj_3R_67()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_68()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_245() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_283()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_244() {
        return this.jj_3R_164();
    }

    private boolean jj_3R_192() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_243()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_244()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_245()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_243() {
        return this.jj_3R_144();
    }

    private boolean jj_3_27() {
        return this.jj_3R_64();
    }

    private boolean jj_3R_152() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_scan_token(149)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_216()) {
                return true;
            }
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_151() {
        if (this.jj_scan_token(191)) {
            return true;
        }
        return this.jj_3R_215();
    }

    private boolean jj_3R_150() {
        if (this.jj_scan_token(190)) {
            return true;
        }
        return this.jj_3R_215();
    }

    private boolean jj_3R_118() {
        Token xsp;
        if (this.jj_3R_192()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_336());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_149() {
        if (this.jj_scan_token(162)) {
            return true;
        }
        return this.jj_3R_215();
    }

    private boolean jj_3R_148() {
        if (this.jj_scan_token(161)) {
            return true;
        }
        return this.jj_3R_215();
    }

    private boolean jj_3R_196() {
        return this.jj_3R_64();
    }

    private boolean jj_3R_147() {
        if (this.jj_scan_token(189)) {
            return true;
        }
        return this.jj_3R_79();
    }

    private boolean jj_3R_289() {
        return this.jj_3R_215();
    }

    private boolean jj_3_26() {
        return this.jj_3R_64();
    }

    private boolean jj_3R_146() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        return this.jj_3R_79();
    }

    private boolean jj_3R_145() {
        if (this.jj_3R_214()) {
            return true;
        }
        return this.jj_3R_215();
    }

    private boolean jj_3R_195() {
        return this.jj_3R_57();
    }

    private boolean jj_3_49() {
        return this.jj_3R_83();
    }

    private boolean jj_3_25() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_117() {
        if (this.jj_3R_57()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_196()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_194() {
        return this.jj_3R_64();
    }

    private boolean jj_3R_79() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_49()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_145()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_146()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_147()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_148()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_149()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_150()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_151()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_152()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_153()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_290() {
        if (this.jj_scan_token(146)) {
            return true;
        }
        if (this.jj_3R_311()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(153)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(147);
    }

    private boolean jj_3_47() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_82()) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_193() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_268() {
        return this.jj_3R_79();
    }

    private boolean jj_3_28() {
        if (this.jj_3R_56()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_194()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_195()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_267() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_82()) {
            return true;
        }
        if (this.jj_scan_token(150)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_289()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_290()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_116() {
        if (this.jj_3R_58()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_193()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_215() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_267()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_268()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_116()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_28()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_117()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_391() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(157)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(186)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(187)) {
                    return true;
                }
            }
        }
        return this.jj_3R_215();
    }

    private boolean jj_3R_382() {
        Token xsp;
        if (this.jj_3R_215()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_391());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_65() {
        return this.jj_3R_118();
    }

    private boolean jj_3R_66() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_301() {
        if (this.jj_scan_token(155)) {
            return true;
        }
        return this.jj_3R_315();
    }

    private boolean jj_3_23() {
        return this.jj_3R_64();
    }

    private boolean jj_3R_383() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(161)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(162)) {
                return true;
            }
        }
        return this.jj_3R_382();
    }

    private boolean jj_3R_372() {
        Token xsp;
        if (this.jj_3R_382()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_383());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_256() {
        if (this.jj_scan_token(146)) {
            return true;
        }
        if (this.jj_3R_132()) {
            return true;
        }
        return this.jj_scan_token(147);
    }

    private boolean jj_3_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_23()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(148);
    }

    private boolean jj_3R_115() {
        return this.jj_3R_163();
    }

    private boolean jj_3R_114() {
        return this.jj_3R_164();
    }

    private boolean jj_3R_113() {
        return this.jj_3R_144();
    }

    private boolean jj_3R_63() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_113()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_114()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_115()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_24()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_373() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(184)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(185)) {
                return true;
            }
        }
        return this.jj_3R_372();
    }

    private boolean jj_3R_358() {
        Token xsp;
        if (this.jj_3R_372()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_373());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_328() {
        if (this.jj_scan_token(158)) {
            return true;
        }
        return this.jj_3R_327();
    }

    private boolean jj_3R_274() {
        if (this.jj_3R_67()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_301()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_359() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(180)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(181)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(182)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(183)) {
                        return true;
                    }
                }
            }
        }
        return this.jj_3R_358();
    }

    private boolean jj_3R_255() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_132()) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_343() {
        Token xsp;
        if (this.jj_3R_358()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_359());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_275() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        return this.jj_3R_274();
    }

    private boolean jj_3R_233() {
        Token xsp;
        if (this.jj_3R_274()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_275());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_344() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(178)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(179)) {
                return true;
            }
        }
        return this.jj_3R_343();
    }

    private boolean jj_3R_313() {
        if (this.jj_scan_token(177)) {
            return true;
        }
        return this.jj_3R_312();
    }

    private boolean jj_3R_292() {
        if (this.jj_scan_token(176)) {
            return true;
        }
        return this.jj_3R_291();
    }

    private boolean jj_3_22() {
        return this.jj_3R_63();
    }

    private boolean jj_3R_327() {
        Token xsp;
        if (this.jj_3R_343()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_344());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_60() {
        Token xsp;
        if (this.jj_3_22()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_22());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_397() {
        if (this.jj_scan_token(156)) {
            return true;
        }
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_347() {
        return this.jj_3R_163();
    }

    private boolean jj_3R_331() {
        return this.jj_3R_174();
    }

    private boolean jj_3R_254() {
        if (this.jj_scan_token(151)) {
            return true;
        }
        if (this.jj_3R_132()) {
            return true;
        }
        return this.jj_scan_token(152);
    }

    private boolean jj_3R_270() {
        if (this.jj_scan_token(175)) {
            return true;
        }
        return this.jj_3R_269();
    }

    private boolean jj_3R_312() {
        Token xsp;
        if (this.jj_3R_327()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_328());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_62() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_277() {
        Token xsp;
        if (this.jj_scan_token(36)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_331());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_218() {
        if (this.jj_scan_token(174)) {
            return true;
        }
        return this.jj_3R_217();
    }

    private boolean jj_3R_346() {
        return this.jj_3R_174();
    }

    private boolean jj_3R_330() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_346()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_347()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_291() {
        Token xsp;
        if (this.jj_3R_312()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_313());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_389() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(17)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_397()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_269() {
        Token xsp;
        if (this.jj_3R_291()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_292());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_276() {
        Token xsp;
        if (this.jj_scan_token(30)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_330());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_111() {
        if (this.jj_scan_token(154)) {
            return true;
        }
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_377() {
        Token xsp;
        if (this.jj_scan_token(153)) {
            return true;
        }
        if (this.jj_3R_389()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_389());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_235() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_276()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_277()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_155() {
        if (this.jj_scan_token(173)) {
            return true;
        }
        if (this.jj_3R_219()) {
            return true;
        }
        if (this.jj_scan_token(154)) {
            return true;
        }
        return this.jj_3R_81();
    }

    private boolean jj_3R_217() {
        Token xsp;
        if (this.jj_3R_269()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_270());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_396() {
        if (this.jj_scan_token(118)) {
            return true;
        }
        return this.jj_3R_374();
    }

    private boolean jj_3R_388() {
        Token xsp;
        if (this.jj_3R_396()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_396());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_20() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_401() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(119)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(109)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_266() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_154() {
        Token xsp;
        if (this.jj_3R_217()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_218());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_61() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_111()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(146)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_20()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(147)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_400() {
        if (this.jj_scan_token(112)) {
            return true;
        }
        return this.jj_scan_token(113);
    }

    private boolean jj_3R_399() {
        Token xsp;
        if (this.jj_scan_token(117)) {
            return true;
        }
        if (this.jj_3R_401()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_401());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_123() {
        return this.jj_3R_81();
    }

    private boolean jj_3R_265() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_171() {
        if (this.jj_3R_235()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(87)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_297() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        return this.jj_3R_160();
    }

    private boolean jj_3R_81() {
        if (this.jj_3R_154()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_155()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_253() {
        return this.jj_3R_109();
    }

    private boolean jj_3R_395() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_400()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(123);
    }

    private boolean jj_3R_392() {
        return this.jj_3R_374();
    }

    private boolean jj_3R_80() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(155)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(163)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(164)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(165)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(166)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(167)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(168)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(169)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(170)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(171)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(172)) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_45() {
        if (this.jj_3R_79()) {
            return true;
        }
        return this.jj_3R_80();
    }

    private boolean jj_3R_394() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(123)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_399()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_375() {
        if (this.jj_scan_token(118)) {
            return true;
        }
        if (this.jj_3R_374()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_388()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_264() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_227() {
        return this.jj_3R_163();
    }

    private boolean jj_3_46() {
        return this.jj_3R_81();
    }

    private boolean jj_3R_164() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_123()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_377()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_226() {
        if (this.jj_3R_79()) {
            return true;
        }
        if (this.jj_3R_80()) {
            return true;
        }
        return this.jj_3R_160();
    }

    private boolean jj_3R_160() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_226()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_46()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_227()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_390() {
        return this.jj_3R_271();
    }

    private boolean jj_3R_398() {
        return this.jj_3R_374();
    }

    private boolean jj_3R_387() {
        Token xsp;
        if (this.jj_scan_token(123)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_395());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_219() {
        Token xsp;
        if (this.jj_3R_160()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_297());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_135() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(154);
    }

    private boolean jj_3R_393() {
        Token xsp;
        if (this.jj_scan_token(112)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_398());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(113);
    }

    private boolean jj_3R_386() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_394()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_263() {
        return this.jj_scan_token(76);
    }

    private boolean jj_3R_385() {
        Token xsp;
        if (this.jj_3R_393()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_393());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_213() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_263()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_264()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_265()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_266()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_384() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(116)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(115)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(114)) {
                    return true;
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_392());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_262() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_261() {
        return this.jj_scan_token(82);
    }

    private boolean jj_3R_374() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(119)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_384()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_385()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_386()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_387()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_260() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_361() {
        if (this.jj_scan_token(118)) {
            return true;
        }
        if (this.jj_3R_374()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_375()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_379() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(87)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_390()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_369() {
        Token xsp;
        if (this.jj_3R_379()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_379());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_212() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_260()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_261()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_262()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_44() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        return this.jj_3R_77();
    }

    private boolean jj_3R_259() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_258() {
        return this.jj_scan_token(81);
    }

    private boolean jj_3R_211() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_258()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_259()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_368() {
        return this.jj_3R_271();
    }

    private boolean jj_3R_208() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(87)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(17)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(10)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(53)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_253()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(156)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(161)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(162)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(153)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(154)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(157)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_254()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_255()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_256()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_132() {
        Token xsp;
        if (this.jj_3R_208()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_208());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_360() {
        return this.jj_3R_374();
    }

    private boolean jj_3R_345() {
        Token xsp;
        if (this.jj_3R_360()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_360());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_361()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_189() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(109)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(119)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(123)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(118)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_131() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_134() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        return this.jj_3R_123();
    }

    private boolean jj_3R_190() {
        if (this.jj_scan_token(112)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_345()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(113);
    }

    private boolean jj_3R_75() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_131()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_132();
    }

    private boolean jj_3R_355() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(87)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_368()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_369()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3_42() {
        return this.jj_3R_77();
    }

    private boolean jj_3R_364() {
        return this.jj_3R_299();
    }

    private boolean jj_3R_78() {
        return this.jj_3R_144();
    }

    private boolean jj_3_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_78()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_42()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_110() {
        Token xsp;
        if (this.jj_scan_token(109)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_189());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_190()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_50() {
        Token xsp;
        if (this.jj_3_43()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_43());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_41() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_366() {
        if (this.jj_scan_token(155)) {
            return true;
        }
        return this.jj_3R_306();
    }

    private boolean jj_3_19() {
        if (this.jj_scan_token(112)) {
            return true;
        }
        if (this.jj_3R_59()) {
            return true;
        }
        return this.jj_scan_token(113);
    }

    private boolean jj_3R_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_110()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_298() {
        return this.jj_3R_59();
    }

    private boolean jj_3R_363() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_335() {
        return this.jj_3R_334();
    }

    private boolean jj_3R_210() {
        return this.jj_scan_token(146);
    }

    private boolean jj_3R_257() {
        return this.jj_3R_219();
    }

    private boolean jj_3R_230() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_59();
    }

    private boolean jj_3R_209() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_257()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(148);
    }

    private boolean jj_3R_163() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_229()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_230()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_229() {
        Token xsp;
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_3R_298()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_298());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_133() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_scan_token(154);
    }

    private boolean jj_3R_76() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_133()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_134()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_135()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_367() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_143() {
        return this.jj_3R_164();
    }

    private boolean jj_3R_362() {
        if (this.jj_scan_token(154)) {
            return true;
        }
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_142() {
        return this.jj_3R_163();
    }

    private boolean jj_3R_378() {
        return this.jj_3R_306();
    }

    private boolean jj_3R_141() {
        return this.jj_3R_75();
    }

    private boolean jj_3R_140() {
        return this.jj_3R_213();
    }

    private boolean jj_3R_314() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_317() {
        Token xsp;
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_334()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_335());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_299() {
        Token xsp;
        if (this.jj_3R_314()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_314());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_139() {
        return this.jj_3R_212();
    }

    private boolean jj_3R_138() {
        return this.jj_3R_211();
    }

    private boolean jj_3R_365() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_378()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_351() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_365()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_366()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_137() {
        return this.jj_3R_210();
    }

    private boolean jj_3R_136() {
        return this.jj_3R_209();
    }

    private boolean jj_3R_349() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(156)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(154)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(87)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_363()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_364()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_348() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_362()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_40() {
        return this.jj_3R_76();
    }

    private boolean jj_3R_334() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_348()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_349()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_39() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_316() {
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_303() {
        Token xsp;
        if (this.jj_3R_316()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_316());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_317()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_38() {
        return this.jj_3R_75();
    }

    private boolean jj_3R_354() {
        if (this.jj_scan_token(154)) {
            return true;
        }
        if (this.jj_scan_token(154)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(87)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_367()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_302() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_278()) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_278() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_302()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_303()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_77() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_39()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_40()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_136()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_137()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_138()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_139()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_140()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_141()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_142()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_143()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_337() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_237() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_353() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        return this.jj_3R_306();
    }

    private boolean jj_3R_174() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_236()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_237()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_236() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(38)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(41)) {
                return true;
            }
        }
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_278()) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_352() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        return this.jj_3R_306();
    }

    private boolean jj_3R_173() {
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_323() {
        return this.jj_3R_160();
    }

    private boolean jj_3R_350() {
        return this.jj_3R_306();
    }

    private boolean jj_3R_320() {
        if (this.jj_3R_271()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_353()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_338() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_356() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        return this.jj_3R_321();
    }

    private boolean jj_3R_341() {
        Token xsp;
        if (this.jj_3R_356()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_356());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_37() {
        return this.jj_3R_71();
    }

    private boolean jj_3R_319() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(87)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_337()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_351()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_352()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_318() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_350()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_306() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_318()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_319()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_320()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_129() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_37()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_322() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_191() {
        return this.jj_3R_242();
    }

    private boolean jj_3R_329() {
        return this.jj_3R_123();
    }

    private boolean jj_3R_112() {
        Token xsp;
        if (this.jj_3R_191()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_191());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_321() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(87)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_338()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_354()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_355()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_128() {
        if (this.jj_scan_token(151)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_329()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(152);
    }

    private boolean jj_3R_307() {
        if (this.jj_3R_321()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_341()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_35() {
        return this.jj_3R_71();
    }

    private boolean jj_3R_304() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_scan_token(149)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_322()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_323()) {
                return true;
            }
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_282() {
        return this.jj_3R_304();
    }

    private boolean jj_3R_127() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_35()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_281() {
        if (this.jj_scan_token(151)) {
            return true;
        }
        if (this.jj_scan_token(151)) {
            return true;
        }
        if (this.jj_3R_307()) {
            return true;
        }
        if (this.jj_scan_token(152)) {
            return true;
        }
        return this.jj_scan_token(152);
    }

    private boolean jj_3R_207() {
        return this.jj_3R_123();
    }

    private boolean jj_3R_280() {
        return this.jj_3R_75();
    }

    private boolean jj_3R_242() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_279()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_280()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_281()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_282()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_279() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_306()) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_288() {
        return this.jj_3R_73();
    }

    private boolean jj_3R_126() {
        if (this.jj_scan_token(151)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_207()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(152);
    }

    private boolean jj_3R_156() {
        return this.jj_3R_74();
    }

    private boolean jj_3_36() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_74()) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_108() {
        return this.jj_3R_174();
    }

    private boolean jj_3R_73() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_36()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_126()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_127()) {
                    return true;
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_128());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_129());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_107() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_106() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_105() {
        return this.jj_scan_token(46);
    }

    private boolean jj_3R_130() {
        if (this.jj_3R_197()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_288()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_104() {
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_103() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3_34() {
        return this.jj_3R_73();
    }

    private boolean jj_3R_102() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_326() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        return this.jj_3R_311();
    }

    private boolean jj_3R_101() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_74() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_130()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_100() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_100()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_101()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(77)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(78)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_102()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_103()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_104()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_105()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_106()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_107()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(71)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(68)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(69)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(57)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(55)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(54)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(31)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(52)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(51)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_108()) {
                                                                                            return true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_371() {
        return this.jj_3R_357();
    }

    private boolean jj_3R_82() {
        if (this.jj_3R_64()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_156()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_333() {
        if (this.jj_scan_token(146)) {
            return true;
        }
        if (this.jj_3R_311()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(153)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(147);
    }

    private boolean jj_3R_99() {
        return this.jj_3R_173();
    }

    private boolean jj_3R_98() {
        return this.jj_3R_172();
    }

    private boolean jj_3R_97() {
        return this.jj_3R_171();
    }

    private boolean jj_3R_381() {
        if (this.jj_scan_token(160)) {
            return true;
        }
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_380() {
        if (this.jj_scan_token(151)) {
            return true;
        }
        if (this.jj_3R_123()) {
            return true;
        }
        return this.jj_scan_token(152);
    }

    private boolean jj_3R_370() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_380()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_381()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_97()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_98()) {
                this.jj_scanpos = xsp;
                this.jj_lookingAhead = true;
                this.jj_semLA = this.isType(this.getToken((int)1).image);
                this.jj_lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_99()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_357() {
        if (this.jj_3R_370()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_371()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_58() {
        return this.jj_3R_109();
    }

    private boolean jj_3R_342() {
        if (this.jj_3R_357()) {
            return true;
        }
        return this.jj_scan_token(155);
    }

    private boolean jj_3_18() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_325() {
        return this.jj_3R_342();
    }

    private boolean jj_3R_311() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_325()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_315()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_326()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_332() {
        return this.jj_3R_160();
    }

    private boolean jj_3R_188() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_315() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_332()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_333()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_187() {
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_186() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3R_241() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_185() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_184() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_340() {
        return this.jj_3R_163();
    }

    private boolean jj_3_17() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_324() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_305() {
        Token xsp;
        if (this.jj_scan_token(87)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_324());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_240() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_183() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_241()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_33() {
        return this.jj_3R_67();
    }

    private boolean jj_3R_339() {
        if (this.jj_scan_token(155)) {
            return true;
        }
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_287() {
        return this.jj_3R_74();
    }

    private boolean jj_3_16() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_252() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_287()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_182() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_240()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_181() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_251() {
        return this.jj_3R_67();
    }

    private boolean jj_3R_72() {
        if (this.jj_3R_53()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_251()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_252()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_339()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_340()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_239() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_180() {
        return this.jj_scan_token(59);
    }

    private boolean jj_3_32() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        return this.jj_3R_72();
    }

    private boolean jj_3R_125() {
        Token xsp;
        if (this.jj_3R_72()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_32());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_15() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_179() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_239()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_238() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_247() {
        return this.jj_3R_197();
    }

    private boolean jj_3R_310() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        return this.jj_scan_token(159);
    }

    private boolean jj_3R_178() {
        return this.jj_scan_token(80);
    }

    private boolean jj_3R_177() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_238()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_71() {
        if (this.jj_3R_125()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_310()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_246() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_96() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_176() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_55() {
        Token xsp;
        if (this.jj_3R_96()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_96());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_175() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_109() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_175()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_176()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_177()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_178()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_179()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_180()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_181()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_182()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_183()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_184()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_185()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_186()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_187()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_188()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_273() {
        return this.jj_3R_299();
    }

    private boolean jj_3R_197() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(157)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(158)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_246()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_247()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_122() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_232() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_231() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_273()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_284() {
        return this.jj_3R_305();
    }

    private boolean jj_3_12() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_165() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(73)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(20)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(31)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(37)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(32)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_231()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_232()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_14() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_249() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_284()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_162() {
        return this.jj_3R_163();
    }

    private boolean jj_3_11() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_168() {
        return this.jj_3R_53();
    }

    private boolean jj_3_31() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_71()) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_202() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_249()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_94() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_93() {
        if (this.jj_3R_57()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_168()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_10() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_167() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_376() {
        Token xsp;
        if (this.jj_scan_token(10)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(10));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_248() {
        return this.jj_3R_81();
    }

    private boolean jj_3_13() {
        if (this.jj_3R_56()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_167()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_166() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_169() {
        return this.jj_3R_233();
    }

    private boolean jj_3R_296() {
        return this.jj_3R_299();
    }

    private boolean jj_3_9() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_201() {
        if (this.jj_scan_token(151)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_248()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(152);
    }

    private boolean jj_3R_92() {
        if (this.jj_3R_58()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_166()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_120() {
        return this.jj_3R_197();
    }

    private boolean jj_3R_91() {
        if (this.jj_3R_165()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_8() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_295() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_91()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_92()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_13()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_93()) {
                        return true;
                    }
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_94()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_200() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_67()) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_294() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_199() {
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_95() {
        return this.jj_3R_52();
    }

    private boolean jj_3_6() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_228() {
        return this.jj_3R_163();
    }

    private boolean jj_3R_54() {
        Token xsp;
        if (this.jj_3R_95()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_95());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_198() {
        return this.jj_3R_163();
    }

    private boolean jj_3R_121() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_198()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_199()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_200()) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_201());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_202());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_161() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_228()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_160();
    }

    private boolean jj_3R_90() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(83)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(84)) {
                return true;
            }
        }
        return this.jj_3R_170();
    }

    private boolean jj_3_7() {
        if (this.jj_3R_53()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_169()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(148);
    }

    private boolean jj_3R_309() {
        if (this.jj_scan_token(155)) {
            return true;
        }
        return this.jj_3R_123();
    }

    private boolean jj_3R_234() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(130)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(129)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(144)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_119() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_90()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_67() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_119()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_120()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_121()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_122()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_308() {
        if (this.jj_scan_token(155)) {
            return true;
        }
        return this.jj_3R_123();
    }

    private boolean jj_3R_89() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_67()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_293() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_286() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_309()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_271() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_293()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_294()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_295()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_296()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_170() {
        Token xsp;
        if (this.jj_scan_token(130)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_234());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(133)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(145)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_159() {
        return this.jj_3R_163();
    }

    private boolean jj_3R_285() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_308()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_250() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_285()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_286()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_159()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_160()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_161());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_162()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_221() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_3R_219()) {
            return true;
        }
        return this.jj_scan_token(150);
    }

    private boolean jj_3R_220() {
        return this.jj_3R_271();
    }

    private boolean jj_3R_206() {
        if (this.jj_3R_250()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(153)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 1024, 1024, 0, 0, 0, -2146959360, 0, 0, -1854930944, -2146959360, 131072, -1873805312, 0x1200000, 0x40000000, -2146959360, 0, -2113190912, 0, 0, -2146959360, -2146959360, 0, 214016, 214016, 0, 0, 0, 0, -2146745344, -2146959360, -2146745344, 0, 0, 0, 0, -2146745344, 0, 0, 0, 132096, 0, 0, 0, 131072, 132096, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0, -2146959360, 0, 0, -2146959360, 0x1200000, -2146959360, 0, 0, 0, -2146959360, 0, 0, 0, 1024, 0, 1024, 0, 0, 1024, -2146959360, 0, 0, 0, 0, 0, 33768448, 0, 0, 0, 0, -2146959360, 0, -2146959360, 0, 0, 0, 0, 0, 0, 33768448, 0, 0, 0, 0, 0, 0, 0, 33768448, 0, 0, 33768448, 0, 235357184, 0x800000, 33768448, 0, -2146959360, 19006464, 19006464, 0x4000000, 33768448, 33768448, 33768448, 0, 33768448, 0x8040000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33768448, 33768448, 33768448, 0x2000000, 0, 0, 0, 214016, 0, 0, 0, 0, 214016};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{67109248, 0, 0, 0, 0, 0, 0, 66846688, 0, 0, -1744830429, 66846304, 0, 33, -1744830462, 16, 66846304, 0x1220000, 67108448, 0, 0, 66846304, 66846304, 0, 0, 0, 0, 0, 0, 0x1220000, 66846304, 66846304, 66846304, 0, 0, 0, 0, 66846304, 576, 19006016, 0, 0, 0, 0, 0, 0, 0, 0, 0, 384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1220000, 0, 19006400, 19006400, 19006016, 16, 0, 0, 133955552, 0x1220000, 67109248, 66846304, -1744830462, 66846304, 0, 0, 0, 133955552, 0x1220000, 0, 0, 67109248, 0, 67109248, 0, 0, 0, 66846304, 0, 0x1220000, 384, 0, 0, 262144, 0, 0, 0, 0, 66846304, 0, 66846304, 0, 0, 0, 384, 0, 0, 262144, 0, 0, 0, 0, 0, 0, 0, 262144, 0, 0, 262144, 0, 84148620, 0x40000000, 262144, 0, 66846304, -1742733310, -1742733310, 0, 262144, 262144, 262144, 4, 262144, 8, 0, 384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262144, 262144, 262144, 262144, 0, 0, 0, 0, 384, 0, 384, 384, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0x600000, 0x600000, 0, 0, 0, 0, 0, 8413360, 0x180000, 0x180000, 69199, 24752, 0, 512, 68687, 256, 24752, 0, 8413360, 0, 0, 8413360, 8413360, 0, 0x800000, 0x800000, 0, 0, 0, 0, 8413360, 8413360, 8413360, 0, 0, 0, 0, 8413360, 0, 0, 0x800000, 0x800000, 0, 0x800000, 0, 0x800000, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0x800000, 0, 0, 0, 0, 0, 0, 14704816, 0, 0x600000, 24752, 68687, 24752, 0, 0, 0, 14704816, 0, 0x800000, 0x800000, 0xE00000, 0, 0xE00000, 0, 0, 0x800000, 24752, 0, 0, 0, 0x800000, 0, 0x800000, 0, 0x800000, 0, 0, 24752, 0, 24752, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0x800000, 0, 8818688, 0x800000, 0x800000, 0x600000, 24752, 8457295, 8457295, 131072, 0x800000, 0x800000, 0x800000, 294912, 0x800000, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0x800000, 0x800000, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73728, 0, 146808832, 146808832, 144515072, 0x400000, 0x400000, 0x400000, 0x400000, 144515072, 65536, 8192, 0x1C0000, 144515072, 144515072, 65536, 0x802000, 0x802000, 0x8200000, 0x8200000, 8192, 65536, 144515072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0x100000, 0, 0, 0, 65542, 65542, 131104, 0x60A00000, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0x800000, 0x800000, 0x60A00000, 0x2000000, 0x2000000, 0x800000, 0x800000, 0x4000000, 0, 0, 0x2000000, 0x2000000, 0x200000, 0x800000, 0xA00000, 0x800000, 0xA00000, 0x8200000, 0x8200000, 0x2000000, 0x2000000, 0xA00000, 0, 0x800000, 0, 337641472, 0x200000, 0x200000, 0x4000000, 337641472, 337641472, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0x10000000, 0x2000000, 0x4000000, 0, 0x800000, 0, 0x800000, 0x800000, 0x800000, 0, 0x2000000, 0x8000000, 1688207360, 0x800000, 0, 0x800000, 0, 0x800000, 0x2000000, 0x4000000, 0x4000000, 1688207360, 0x800000, 0, 0, 0, 0x2000000, 0, 0x8000000, 0x8000000, 0, 0x800000, 0x60000000, 0x800000, 0, 0x200000, 0x800000, 0x60200000, 0x200000, 0, 0x200000, 0x60000000, 0x800000, 0x60000000, 0x800000, 0x2000000, 0x60A00000, 0x8000000, 0, 0x2000000, 0x2000000, 1612972032, 0x800000, 0x2000000, 0x800000, 0x800000, 0x60A00000, 0xA00000, 0x60000000, 0x60200000, 0xA00000, 0x800000, 0x60200000, 0x200000, 1614020608, 0, 0x60200000, 0, 0x800000, 916717568, 916717568, 0, 0x60200000, 0x60200000, 0x60200000, 0, 0x60200000, 0, 0x2000000, 0, 0x8000000, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0x20000000, 0x2000000, 1612972032, 0x60200000, 0x60200000, 0x60000000, 0x60000000, 0xA00000, 0xA00000, 0x200000, 0, 0x2000000, 0, 0, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435450, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435450, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435450, 1, 0, 1, 1, 0, 0, 0, -268435450, 0, 0, -268435450, 0, -268435450, 0, -268435450, 0, 0, 6, 6, 0, -268435450, -268435450, -268435450, 0, -268435450, 0, 0, 0, 8184, 8192, 16384, 32768, 65536, 131072, 0, 786432, 786432, 0xF00000, 0xF00000, 0x3000000, 0x3000000, 6, 6, 0xC000000, 0xC000000, 0, -268435450, -268435450, -268435450, -268435450, 0, 0x30000001, 0x30000001, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_6() {
        jj_la1_6 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0};
    }

    public CParser(InputStream stream) {
        this(stream, null);
    }

    public CParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 183; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 183; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 183; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 183; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CParser(CParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 183; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 183; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[193];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 183; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) == 0) continue;
                la1tokens[192 + j] = true;
            }
        }
        for (i = 0; i < 193; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 50; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        CParser.jj_la1_init_0();
        CParser.jj_la1_init_1();
        CParser.jj_la1_init_2();
        CParser.jj_la1_init_3();
        CParser.jj_la1_init_4();
        CParser.jj_la1_init_5();
        CParser.jj_la1_init_6();
    }

    private static class EnumMember {
        final String name;
        final long value;

        EnumMember(String name, long value) {
            this.name = name;
            this.value = value;
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

