/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.navigation;

import ghidra.app.services.QueryData;
import ghidra.app.util.navigation.SymbolSearcher;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class GoToSymbolSearchTask
extends Task {
    private QueryData queryData;
    private List<Program> searchPrograms;
    private List<ProgramLocation> results;
    private int limit;

    public GoToSymbolSearchTask(QueryData queryData, List<Program> searchPrograms, int limit) {
        super("Searching Symbols...");
        this.queryData = queryData;
        this.searchPrograms = searchPrograms;
        this.limit = limit;
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        SymbolSearcher searcher = new SymbolSearcher(this.queryData, this.limit, monitor);
        this.results = searcher.findMatchingSymbolLocations(this.searchPrograms);
    }

    public List<ProgramLocation> getResults() {
        return this.results;
    }
}

