/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.TaskMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Loaded<T extends DomainObject> {
    private final T domainObject;
    private final String name;
    private String projectFolderPath;
    private DomainFile domainFile;
    private boolean ignoreSave;
    private boolean discard;

    public Loaded(T domainObject, String name, String projectFolderPath) {
        this.domainObject = domainObject;
        this.name = name;
        this.setProjectFolderPath(projectFolderPath);
    }

    public Loaded(T domainObject, DomainFile domainFile) {
        this(domainObject, domainFile.getName(), domainFile.getParent().getPathname());
        this.domainFile = domainFile;
        this.ignoreSave = true;
    }

    public T getDomainObject() {
        return this.domainObject;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectFolderPath() {
        return this.projectFolderPath;
    }

    public void setProjectFolderPath(String projectFolderPath) {
        if (projectFolderPath == null || ((String)projectFolderPath).isBlank()) {
            projectFolderPath = "/";
        } else if (!((String)projectFolderPath).endsWith("/")) {
            projectFolderPath = (String)projectFolderPath + "/";
        }
        this.projectFolderPath = projectFolderPath;
    }

    public void release(Object consumer) {
        if (!this.domainObject.isClosed() && this.domainObject.isUsedBy(consumer)) {
            this.domainObject.release(consumer);
        }
    }

    public DomainFile save(Project project, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, ClosedException, IOException {
        if (this.ignoreSave) {
            return this.domainFile;
        }
        if (this.domainObject.isClosed()) {
            throw new ClosedException("Cannot saved closed DomainObject: " + this.domainObject.getName());
        }
        try {
            if (this.getSavedDomainFile() != null) {
                throw new IOException("Already saved to " + String.valueOf(this.domainFile));
            }
        }
        catch (FileNotFoundException e) {
            this.domainFile = null;
        }
        int uniqueNameIndex = 0;
        Object uniqueName = this.name;
        try {
            DomainFolder programFolder = ProjectDataUtils.createDomainFolderPath((DomainFolder)project.getProjectData().getRootFolder(), (String)this.projectFolderPath);
            while (!monitor.isCancelled()) {
                try {
                    this.domainFile = programFolder.createFile((String)uniqueName, this.domainObject, monitor);
                    return this.domainFile;
                }
                catch (DuplicateFileException e) {
                    uniqueName = this.name + "." + uniqueNameIndex;
                    ++uniqueNameIndex;
                }
            }
        }
        catch (InvalidNameException e) {
            throw new IOException(e);
        }
        throw new CancelledException();
    }

    public DomainFile getSavedDomainFile() throws FileNotFoundException {
        if (this.domainFile != null && !this.domainFile.exists()) {
            throw new FileNotFoundException("Saved DomainFile no longer exists: " + String.valueOf(this.domainFile));
        }
        return this.domainFile;
    }

    public boolean shouldDiscard() {
        return this.discard;
    }

    public void setDiscard(boolean discard) {
        this.discard = discard;
    }

    void deleteSavedDomainFile(Object consumer) throws IOException {
        if (this.domainFile != null && this.domainFile.exists()) {
            this.domainFile.delete();
            this.domainFile = null;
        }
    }

    public String toString() {
        return this.getProjectFolderPath() + this.getName();
    }
}

