/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.util.viewer.field.EolEnablement;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.GProperties;

public class EolExtraCommentsOption
implements CustomOption {
    private static final String BASE_KEY = "extraComment";
    private static final String KEY_REPETABLE = "extraCommentRepeatable";
    private static final String KEY_REF_REPETABLE = "extraCommentRefRepeatable";
    private static final String KEY_AUTO_DATA = "extraCommentAutoData";
    private static final String KEY_AUTO_FUNCTION = "extraCommentAutoFunction";
    private static final String KEY_USE_ABBRAVIATED = "extraCommentUseAbbreviated";
    private EolEnablement repeatable = EolEnablement.DEFAULT;
    private EolEnablement refRepeatable = EolEnablement.DEFAULT;
    private EolEnablement autoFunction = EolEnablement.DEFAULT;
    private EolEnablement autoData = EolEnablement.DEFAULT;
    private boolean useAbbreviatedComments = true;

    public EolEnablement getRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(EolEnablement priority) {
        this.repeatable = priority;
    }

    public EolEnablement getRefRepeatable() {
        return this.refRepeatable;
    }

    public void setRefRepeatable(EolEnablement priority) {
        this.refRepeatable = priority;
    }

    public EolEnablement getAutoData() {
        return this.autoData;
    }

    public void setAutoData(EolEnablement priority) {
        this.autoData = priority;
    }

    public EolEnablement getAutoFunction() {
        return this.autoFunction;
    }

    public void setAutoFunction(EolEnablement priority) {
        this.autoFunction = priority;
    }

    public boolean useAbbreviatedComments() {
        return this.useAbbreviatedComments;
    }

    public void setUseAbbreviatedComments(boolean b) {
        this.useAbbreviatedComments = b;
    }

    public boolean alwaysShowAutoComments() {
        return this.autoData == EolEnablement.ALWAYS || this.autoFunction == EolEnablement.ALWAYS;
    }

    public boolean isShowingRefRepeatables(boolean hasOtherComments) {
        return this.isShowing(this.refRepeatable, hasOtherComments);
    }

    public boolean isShowingRepeatables(boolean hasOtherComments) {
        return this.isShowing(this.repeatable, hasOtherComments);
    }

    public boolean isShowingAutoComments(boolean hasOtherComments) {
        if (this.alwaysShowAutoComments()) {
            return true;
        }
        if (this.isShowing(this.autoData, hasOtherComments)) {
            return true;
        }
        return this.isShowing(this.autoFunction, hasOtherComments);
    }

    private boolean isShowing(EolEnablement enablement, boolean hasExistingComments) {
        return enablement == EolEnablement.ALWAYS || enablement == EolEnablement.DEFAULT && !hasExistingComments;
    }

    public void readState(GProperties properties) {
        this.repeatable = (EolEnablement)properties.getEnum(KEY_REPETABLE, (Enum)EolEnablement.DEFAULT);
        this.refRepeatable = (EolEnablement)properties.getEnum(KEY_REF_REPETABLE, (Enum)EolEnablement.DEFAULT);
        this.autoData = (EolEnablement)properties.getEnum(KEY_AUTO_DATA, (Enum)EolEnablement.DEFAULT);
        this.autoFunction = (EolEnablement)properties.getEnum(KEY_AUTO_FUNCTION, (Enum)EolEnablement.DEFAULT);
        this.useAbbreviatedComments = properties.getBoolean(KEY_USE_ABBRAVIATED, true);
    }

    public void writeState(GProperties properties) {
        properties.putEnum(KEY_REPETABLE, (Enum)this.repeatable);
        properties.putEnum(KEY_REF_REPETABLE, (Enum)this.refRepeatable);
        properties.putEnum(KEY_AUTO_DATA, (Enum)this.autoData);
        properties.putEnum(KEY_AUTO_FUNCTION, (Enum)this.autoFunction);
        properties.putBoolean(KEY_USE_ABBRAVIATED, this.useAbbreviatedComments);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.autoData == null ? 0 : this.autoData.hashCode());
        result = 31 * result + (this.autoFunction == null ? 0 : this.autoFunction.hashCode());
        result = 31 * result + (this.refRepeatable == null ? 0 : this.refRepeatable.hashCode());
        result = 31 * result + (this.repeatable == null ? 0 : this.repeatable.hashCode());
        result = 31 * result + (this.useAbbreviatedComments ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EolExtraCommentsOption other = (EolExtraCommentsOption)obj;
        if (this.autoData != other.autoData) {
            return false;
        }
        if (this.autoFunction != other.autoFunction) {
            return false;
        }
        if (this.refRepeatable != other.refRepeatable) {
            return false;
        }
        if (this.repeatable != other.repeatable) {
            return false;
        }
        return this.useAbbreviatedComments == other.useAbbreviatedComments;
    }
}

