/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import generic.theme.GThemeDefaults;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.AnnotationException;
import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.Msg;
import java.awt.Color;
import java.util.List;

public class SymbolAnnotatedStringHandler
implements AnnotatedStringHandler {
    private static final String INVALID_SYMBOL_TEXT = "@symbol annotation must have a valid symbol name or address";
    private static final String[] SUPPORTED_ANNOTATIONS = new String[]{"symbol", "sym"};

    @Override
    public AttributedString createAnnotatedString(AttributedString prototypeString, String[] text, Program program) {
        if (text.length <= 1) {
            throw new AnnotationException(INVALID_SYMBOL_TEXT);
        }
        if (program == null) {
            return this.createUndecoratedString(prototypeString, text);
        }
        List<Symbol> symbols = CommentUtils.getSymbols(text[1], program);
        if (symbols.size() >= 1) {
            String symbolText = symbols.get(0).getName();
            return new AttributedString(symbolText, prototypeString.getColor(0), prototypeString.getFontMetrics(0), true, prototypeString.getColor(0));
        }
        return new AttributedString("No symbol: " + text[1], (Color)GThemeDefaults.Colors.Messages.ERROR, prototypeString.getFontMetrics(0), false, null);
    }

    private AttributedString createUndecoratedString(AttributedString prototypeString, String[] text) {
        StringBuilder buffer = new StringBuilder();
        for (String string : text) {
            buffer.append(string).append(" ");
        }
        return new AttributedString(buffer.toString(), (Color)GThemeDefaults.Colors.Palette.LIGHT_GRAY, prototypeString.getFontMetrics(0));
    }

    @Override
    public String[] getSupportedAnnotations() {
        return SUPPORTED_ANNOTATIONS;
    }

    @Override
    public boolean handleMouseClick(String[] annotationParts, Navigatable sourceNavigatable, ServiceProvider serviceProvider) {
        String symbolText = annotationParts[1];
        Program program = sourceNavigatable.getProgram();
        List<Symbol> symbols = CommentUtils.getSymbols(symbolText, program);
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        if (!symbols.isEmpty()) {
            Symbol s = symbols.get(0);
            return goToService.goTo(s.getProgramLocation());
        }
        Address address = program.getAddressFactory().getAddress(symbolText);
        if (address != null) {
            return goToService.goTo(sourceNavigatable, address);
        }
        Msg.showInfo(this.getClass(), null, (String)("Invalid symbol text: " + symbolText), (Object)("Unable to locate a symbol for \"" + symbolText + "\""));
        return false;
    }

    @Override
    public String getDisplayString() {
        return "Symbol";
    }

    @Override
    public String getPrototypeString() {
        return "{@symbol symbol_address}";
    }

    @Override
    public String getPrototypeString(String displayText) {
        return "{@symbol " + displayText.trim() + "}";
    }
}

