/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.proxy;

import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import java.util.ConcurrentModificationException;

public class DataProxy
extends ProxyObj<Data> {
    private Program program;
    private Data data;
    private Address addr;
    private int[] path;

    public DataProxy(ListingModel model, Program program, Data data) {
        super(model);
        this.program = program;
        this.data = data;
        this.addr = data.getMinAddress();
        this.path = data.getComponentPath();
    }

    @Override
    public Data getObject() {
        if (this.data != null) {
            try {
                this.data.getMinAddress();
                return this.data;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        this.data = this.program.getListing().getDataContaining(this.addr);
        if (this.data != null) {
            this.data = this.data.getComponent(this.path);
        }
        return this.data;
    }

    @Override
    public boolean contains(Address a) {
        Data d = this.getObject();
        if (d == null) {
            return false;
        }
        return d.contains(a);
    }
}

