/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class CommentsXmlMgr {
    private Program program;
    private MessageLog log;
    private AddressFactory factory;
    private Listing listing;
    private static Map<CommentType, String> COMMENT_TAGS = new HashMap<CommentType, String>();

    CommentsXmlMgr(Program program, MessageLog log) {
        this.program = program;
        this.log = log;
        this.factory = program.getAddressFactory();
        this.listing = program.getListing();
    }

    void read(XmlPullParser parser, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        XmlElement element = parser.next();
        while (true) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            element = parser.next();
            if (!element.getName().equals("COMMENT")) break;
            if (!element.isStart()) continue;
            this.processComment(element, parser);
        }
    }

    void write(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing COMMENTS ...");
        if (set == null) {
            set = this.program.getMemory();
        }
        writer.startElement("COMMENTS");
        CodeUnitIterator iter = this.listing.getCodeUnitIterator("COMMENT__GHIDRA_", set, true);
        while (iter.hasNext()) {
            monitor.checkCancelled();
            CodeUnit cu = iter.next();
            for (CommentType type : CommentType.values()) {
                if (monitor.isCancelled()) {
                    return;
                }
                String comments = cu.getComment(type);
                if (comments == null) continue;
                this.writeComment(writer, cu.getMinAddress(), COMMENT_TAGS.get(type), comments);
            }
        }
        writer.endElement("COMMENTS");
    }

    private void processComment(XmlElement element, XmlPullParser parser) throws AddressFormatException {
        String addrStr = element.getAttribute("ADDRESS");
        Address addr = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)addrStr);
        if (addr == null) {
            throw new AddressFormatException("Incompatible Comment Address: " + addrStr);
        }
        try {
            String typeStr = element.getAttribute("TYPE");
            CommentType commentType = this.getCommentType(typeStr);
            if (commentType == null) {
                this.log.appendMsg("Unknown comment type: " + typeStr);
                parser.discardSubTree(element);
                return;
            }
            element = parser.next();
            String comments = element.getText();
            CodeUnit cu = this.listing.getCodeUnitAt(addr);
            if (cu != null) {
                String currCmt = cu.getComment(commentType);
                if (currCmt == null || currCmt.length() == 0) {
                    cu.setComment(commentType, comments);
                } else if (currCmt.indexOf(comments) < 0) {
                    this.log.appendMsg("Merged " + typeStr + " comment at " + String.valueOf(addr));
                    cu.setComment(commentType, currCmt + "\n\n" + comments);
                }
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
            parser.discardSubTree(element);
        }
    }

    private void writeComment(XmlWriter writer, Address addr, String typeStr, String comments) {
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("ADDRESS", XmlProgramUtilities.toString((Address)addr));
        attrs.addAttribute("TYPE", typeStr);
        writer.writeElement("COMMENT", attrs, comments);
    }

    private CommentType getCommentType(String typeStr) {
        if (StringUtils.isBlank((CharSequence)typeStr)) {
            return null;
        }
        for (CommentType type : CommentType.values()) {
            if (!typeStr.equals(COMMENT_TAGS.get(type))) continue;
            return type;
        }
        return null;
    }

    static {
        block7: for (CommentType type : CommentType.values()) {
            switch (type) {
                case PRE: {
                    COMMENT_TAGS.put(type, "pre");
                    continue block7;
                }
                case POST: {
                    COMMENT_TAGS.put(type, "post");
                    continue block7;
                }
                case EOL: {
                    COMMENT_TAGS.put(type, "end-of-line");
                    continue block7;
                }
                case PLATE: {
                    COMMENT_TAGS.put(type, "plate");
                    continue block7;
                }
                case REPEATABLE: {
                    COMMENT_TAGS.put(type, "repeatable");
                    continue block7;
                }
                default: {
                    throw new AssertException("Unsupported comment type: " + type.name());
                }
            }
        }
    }
}

