/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.listing;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.features.base.codecompare.listing.ListingDisplayToggleAction;
import ghidra.program.util.ListingDiff;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import resources.MultiIcon;

public class ListingDiffActionManager {
    private static final String HELP_TOPIC = "FunctionComparison";
    private static final Icon NOT_ICON = new GIcon("icon.base.util.listingdiff.diffs.not");
    private static final Icon BYTE_DIFFS_ICON = new GIcon("icon.base.util.listingdiff.diffs.byte");
    private static final Icon NO_BYTE_DIFFS_ICON = new MultiIcon(BYTE_DIFFS_ICON, new Icon[]{NOT_ICON});
    private static final Icon DIFF_CONSTANTS_ICON = new GIcon("icon.base.util.listingdiff.diffs.constants");
    private static final Icon IGNORE_CONSTANTS_ICON = new MultiIcon(DIFF_CONSTANTS_ICON, new Icon[]{NOT_ICON});
    private static final Icon DIFF_REGISTERS_ICON = new GIcon("icon.base.util.listingdiff.diffs.registers");
    private static final Icon IGNORE_REGISTERS_ICON = new MultiIcon(DIFF_REGISTERS_ICON, new Icon[]{NOT_ICON});
    private static final String ACTION_GROUP = "A4_Diff";
    private DockingAction toggleIgnoreByteDiffsAction;
    private DockingAction toggleIgnoreConstantsAction;
    private DockingAction toggleIgnoreRegisterNamesAction;
    private ListingDiff listingDiff;

    public ListingDiffActionManager(ListingDiff listingDiff) {
        this.listingDiff = listingDiff;
        this.createActions();
    }

    protected void createActions() {
        this.toggleIgnoreByteDiffsAction = new ToggleIgnoreByteDiffsAction();
        this.toggleIgnoreConstantsAction = new ToggleIgnoreConstantsAction();
        this.toggleIgnoreRegisterNamesAction = new ToggleIgnoreRegisterNamesAction();
    }

    public List<DockingAction> getActions() {
        return Arrays.asList(this.toggleIgnoreByteDiffsAction, this.toggleIgnoreConstantsAction, this.toggleIgnoreRegisterNamesAction);
    }

    public void updateActionEnablement(boolean isShowing) {
        this.toggleIgnoreByteDiffsAction.setEnabled(isShowing);
        this.toggleIgnoreConstantsAction.setEnabled(isShowing);
        this.toggleIgnoreRegisterNamesAction.setEnabled(isShowing);
    }

    class ToggleIgnoreByteDiffsAction
    extends ListingDisplayToggleAction {
        ToggleIgnoreByteDiffsAction() {
            super("Toggle Ignore Byte Diffs", "DualListing");
            this.setDescription(HTMLUtilities.toHTML((String)"If selected, difference highlights should\nignore Byte differences."));
            this.setEnabled(true);
            this.setPopupMenuData(new MenuData(new String[]{"Ignore Bytes As Differences"}, BYTE_DIFFS_ICON, ListingDiffActionManager.ACTION_GROUP));
            ToolBarData newToolBarData = new ToolBarData(BYTE_DIFFS_ICON, ListingDiffActionManager.ACTION_GROUP);
            this.setToolBarData(newToolBarData);
            this.setHelpLocation(new HelpLocation(ListingDiffActionManager.HELP_TOPIC, "Dual Listing Ignore Bytes"));
        }

        public void actionPerformed(ActionContext context) {
            ListingDiffActionManager.this.listingDiff.setIgnoreByteDiffs(!ListingDiffActionManager.this.listingDiff.isIgnoringByteDiffs());
        }

        public void setSelected(boolean selected) {
            this.getToolBarData().setIcon(selected ? NO_BYTE_DIFFS_ICON : BYTE_DIFFS_ICON);
            super.setSelected(selected);
        }
    }

    class ToggleIgnoreConstantsAction
    extends ListingDisplayToggleAction {
        ToggleIgnoreConstantsAction() {
            super("Toggle Ignore Constants", "DualListing");
            this.setDescription(HTMLUtilities.toHTML((String)"If selected, difference highlights should\nignore operand Constants."));
            this.setEnabled(true);
            this.setPopupMenuData(new MenuData(new String[]{"Ignore Operand Constants As Differences"}, DIFF_CONSTANTS_ICON, ListingDiffActionManager.ACTION_GROUP));
            ToolBarData newToolBarData = new ToolBarData(DIFF_CONSTANTS_ICON, ListingDiffActionManager.ACTION_GROUP);
            this.setToolBarData(newToolBarData);
            this.setHelpLocation(new HelpLocation(ListingDiffActionManager.HELP_TOPIC, "Dual Listing Ignore Operand Constants"));
        }

        public void actionPerformed(ActionContext context) {
            ListingDiffActionManager.this.listingDiff.setIgnoreConstants(!ListingDiffActionManager.this.listingDiff.isIgnoringConstants());
        }

        public void setSelected(boolean selected) {
            this.getToolBarData().setIcon(selected ? IGNORE_CONSTANTS_ICON : DIFF_CONSTANTS_ICON);
            super.setSelected(selected);
        }
    }

    class ToggleIgnoreRegisterNamesAction
    extends ListingDisplayToggleAction {
        ToggleIgnoreRegisterNamesAction() {
            super("Toggle Ignore Register Names", "DualListing");
            this.setDescription(HTMLUtilities.toHTML((String)"If selected, difference highlights should\nignore operand Registers."));
            this.setEnabled(true);
            this.setPopupMenuData(new MenuData(new String[]{"Ignore Operand Registers As Differences"}, DIFF_REGISTERS_ICON, ListingDiffActionManager.ACTION_GROUP));
            ToolBarData newToolBarData = new ToolBarData(DIFF_REGISTERS_ICON, ListingDiffActionManager.ACTION_GROUP);
            this.setToolBarData(newToolBarData);
            this.setHelpLocation(new HelpLocation(ListingDiffActionManager.HELP_TOPIC, "Dual Listing Ignore Operand Registers"));
        }

        public void actionPerformed(ActionContext context) {
            ListingDiffActionManager.this.listingDiff.setIgnoreRegisters(!ListingDiffActionManager.this.listingDiff.isIgnoringRegisters());
        }

        public void setSelected(boolean selected) {
            this.getToolBarData().setIcon(selected ? IGNORE_REGISTERS_ICON : DIFF_REGISTERS_ICON);
            super.setSelected(selected);
        }
    }
}

