/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.scan;

import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import java.util.function.Predicate;

public enum Scanner {
    EQUALS("Equals", mm -> Scanner.compareBytes(mm) == 0, "Keep results whose values didn't change"),
    NOT_EQUALS("Not Equals", mm -> Scanner.compareBytes(mm) != 0, "Keep results whose values changed"),
    INCREASED("Increased", mm -> Scanner.compareBytes(mm) > 0, "Keep results whose values increased"),
    DECREASED("Decreased", mm -> Scanner.compareBytes(mm) < 0, "Keep results whose values decreased");

    private final String name;
    private final Predicate<MemoryMatch> acceptCondition;
    private final String description;

    private Scanner(String name, Predicate<MemoryMatch> condition, String description) {
        this.name = name;
        this.acceptCondition = condition;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean accept(MemoryMatch match) {
        return this.acceptCondition.test(match);
    }

    private static int compareBytes(MemoryMatch match) {
        byte[] bytes = match.getBytes();
        byte[] originalBytes = match.getPreviousBytes();
        ByteMatcher matcher = match.getByteMatcher();
        SearchSettings settings = matcher.getSettings();
        SearchFormat searchFormat = settings.getSearchFormat();
        return searchFormat.compareValues(bytes, originalBytes, settings);
    }
}

