/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.MBRPartition;

public class MutableMBRPartition
extends MBRPartition {
    public MutableMBRPartition(MBRPartition source) {
        super(source);
    }

    public void setStatus(byte b) {
        this.status[0] = b;
    }

    public void setFirstSector(byte[] chs, int off) {
        MutableMBRPartition.copyData(chs, off, this.firstSector);
    }

    public void setPartitionType(byte b) {
        this.partitionType[0] = b;
    }

    public void setLastSector(byte[] chs, int off) {
        MutableMBRPartition.copyData(chs, off, this.lastSector);
    }

    public void setLBAFirstSector(int lba) {
        Util.arrayCopy(Util.toByteArrayLE(lba), this.lbaFirstSector);
    }

    public void setLBAPartitionLength(int lba) {
        Util.arrayCopy(Util.toByteArrayLE(lba), this.lbaPartitionLength);
    }

    private static void copyData(byte[] data, int off, byte[] dest) {
        MutableMBRPartition.copyData(data, off, dest, dest.length);
    }

    private static void copyData(byte[] data, int off, byte[] dest, int len) {
        if (off + len > data.length) {
            throw new IllegalArgumentException("Length of input data must be " + len + ".");
        }
        System.arraycopy(data, off, dest, 0, len);
    }
}

