/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.util.pcodeInject.PcodeOpEmitter;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;

public class LdcMethods {
    static final String VALUE = "value";

    private LdcMethods() {
        throw new AssertionError();
    }

    public static void getPcodeForLdc(PcodeOpEmitter pCode, int constantPoolIndex, AbstractConstantPoolInfoJava[] constantPool) {
        byte tag = constantPool[constantPoolIndex].getTag();
        switch (tag) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                pCode.emitAssignVarnodeFromPcodeOpCall(VALUE, 4, "cpool", "0", Integer.toString(constantPoolIndex), "4");
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 5: 
            case 6: {
                pCode.emitAssignVarnodeFromPcodeOpCall(VALUE, 8, "cpool", "0", Integer.toString(constantPoolIndex), "5");
                pCode.emitPushCat2Value(VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid load from constant pool: tag " + tag);
            }
        }
    }
}

