/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.util.pcodeInject.PcodeOpEmitter;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolFieldReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolNameAndTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;

public class ReferenceMethods {
    static final String VALUE = "value";
    static final String TEMP_1 = "temp_1";
    static final String TEMP_2 = "temp_2";
    static final String NEW_VALUE = "newValue";
    static final String OBJECT_REF = "objectRef";
    static final String FIELD_OFFSET = "fieldOffset";
    static final String STATIC_OFFSET = "staticOffset";

    private ReferenceMethods() {
        throw new AssertionError();
    }

    public static void getPcodeForGetStatic(PcodeOpEmitter pCode, int index, AbstractConstantPoolInfoJava[] constantPool) {
        String descriptor = ReferenceMethods.getDescriptorForFieldRef(constantPool, index);
        switch (descriptor.charAt(0)) {
            case 'B': {
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 1, "cpool", "0", Integer.toString(index), "3");
                pCode.emitAssignVarnodeFromDereference(TEMP_2, 1, TEMP_1);
                pCode.emitSignExtension(VALUE, 4, TEMP_2);
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 'Z': {
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 1, "cpool", "0", Integer.toString(index), "3");
                pCode.emitAssignVarnodeFromDereference(TEMP_2, 1, TEMP_1);
                pCode.emitZeroExtension(VALUE, 4, TEMP_2);
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 'C': {
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 2, "cpool", "0", Integer.toString(index), "3");
                pCode.emitAssignVarnodeFromDereference(TEMP_2, 2, TEMP_1);
                pCode.emitZeroExtension(VALUE, 4, TEMP_2);
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 'S': {
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 2, "cpool", "0", Integer.toString(index), "3");
                pCode.emitAssignVarnodeFromDereference(TEMP_2, 2, TEMP_1);
                pCode.emitSignExtension(VALUE, 4, TEMP_2);
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 4, "cpool", "0", Integer.toString(index), "3");
                pCode.emitAssignVarnodeFromDereference(VALUE, 4, TEMP_1);
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 'D': 
            case 'J': {
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 8, "cpool", "0", Integer.toString(index), "3");
                pCode.emitAssignVarnodeFromDereference(VALUE, 8, TEMP_1);
                pCode.emitPushCat2Value(VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
            }
        }
    }

    public static void getPcodeForPutStatic(PcodeOpEmitter pCode, int index, AbstractConstantPoolInfoJava[] constantPool) {
        String descriptor = ReferenceMethods.getDescriptorForFieldRef(constantPool, index);
        switch (descriptor.charAt(0)) {
            case 'B': {
                pCode.emitPopCat1Value(NEW_VALUE);
                pCode.emitAssignVarnodeFromPcodeOpCall(STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                pCode.emitTruncate(TEMP_1, 1, NEW_VALUE);
                pCode.emitWriteToMemory("ram", 1, STATIC_OFFSET, TEMP_1);
                break;
            }
            case 'Z': {
                pCode.emitPopCat1Value(NEW_VALUE);
                pCode.emitAssignVarnodeFromPcodeOpCall(STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                pCode.emitTruncate(TEMP_1, 1, NEW_VALUE);
                pCode.emitWriteToMemory("ram", 1, STATIC_OFFSET, TEMP_1);
                break;
            }
            case 'C': {
                pCode.emitPopCat1Value(NEW_VALUE);
                pCode.emitAssignVarnodeFromPcodeOpCall(STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                pCode.emitTruncate(TEMP_1, 2, NEW_VALUE);
                pCode.emitWriteToMemory("ram", 2, STATIC_OFFSET, TEMP_1);
                break;
            }
            case 'S': {
                pCode.emitPopCat1Value(NEW_VALUE);
                pCode.emitAssignVarnodeFromPcodeOpCall(STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                pCode.emitTruncate(TEMP_1, 2, NEW_VALUE);
                pCode.emitWriteToMemory("ram", 2, STATIC_OFFSET, TEMP_1);
                break;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                pCode.emitPopCat1Value(NEW_VALUE);
                pCode.emitAssignVarnodeFromPcodeOpCall(STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                pCode.emitWriteToMemory("ram", 4, STATIC_OFFSET, NEW_VALUE);
                break;
            }
            case 'D': 
            case 'J': {
                pCode.emitPopCat2Value(NEW_VALUE);
                pCode.emitAssignVarnodeFromPcodeOpCall(STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                pCode.emitWriteToMemory("ram", 8, STATIC_OFFSET, NEW_VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
            }
        }
    }

    public static void getPcodeForGetField(PcodeOpEmitter pCode, int index, AbstractConstantPoolInfoJava[] constantPool) {
        String descriptor = ReferenceMethods.getDescriptorForFieldRef(constantPool, index);
        switch (descriptor.charAt(0)) {
            case 'B': {
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 1, "cpool", OBJECT_REF, Integer.toString(index), "2");
                pCode.emitAssignVarnodeFromDereference(TEMP_2, 1, TEMP_1);
                pCode.emitSignExtension(VALUE, 4, TEMP_2);
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 'Z': {
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 1, "cpool", OBJECT_REF, Integer.toString(index), "2");
                pCode.emitAssignVarnodeFromDereference(TEMP_2, 1, TEMP_1);
                pCode.emitZeroExtension(VALUE, 4, TEMP_2);
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 'C': {
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 2, "cpool", OBJECT_REF, Integer.toString(index), "2");
                pCode.emitAssignVarnodeFromDereference(TEMP_2, 2, TEMP_1);
                pCode.emitZeroExtension(VALUE, 4, TEMP_2);
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 'S': {
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 2, "cpool", OBJECT_REF, Integer.toString(index), "2");
                pCode.emitAssignVarnodeFromDereference(TEMP_2, 2, TEMP_1);
                pCode.emitSignExtension(VALUE, 4, TEMP_2);
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 4, "cpool", OBJECT_REF, Integer.toString(index), "2");
                pCode.emitAssignVarnodeFromDereference(VALUE, 4, TEMP_1);
                pCode.emitPushCat1Value(VALUE);
                break;
            }
            case 'D': 
            case 'J': {
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(TEMP_1, 8, "cpool", OBJECT_REF, Integer.toString(index), "2");
                pCode.emitAssignVarnodeFromDereference(VALUE, 8, TEMP_1);
                pCode.emitPushCat2Value(VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
            }
        }
    }

    public static void getPcodeForPutField(PcodeOpEmitter pCode, int index, AbstractConstantPoolInfoJava[] constantPool) {
        String descriptor = ReferenceMethods.getDescriptorForFieldRef(constantPool, index);
        switch (descriptor.charAt(0)) {
            case 'B': {
                pCode.emitPopCat1Value(NEW_VALUE);
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                pCode.emitTruncate(TEMP_1, 1, NEW_VALUE);
                pCode.emitWriteToMemory("ram", 1, FIELD_OFFSET, TEMP_1);
                break;
            }
            case 'Z': {
                pCode.emitPopCat1Value(NEW_VALUE);
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                pCode.emitTruncate(TEMP_1, 1, NEW_VALUE);
                pCode.emitWriteToMemory("ram", 1, FIELD_OFFSET, TEMP_1);
                break;
            }
            case 'C': {
                pCode.emitPopCat1Value(NEW_VALUE);
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                pCode.emitTruncate(TEMP_1, 2, NEW_VALUE);
                pCode.emitWriteToMemory("ram", 2, FIELD_OFFSET, TEMP_1);
                break;
            }
            case 'S': {
                pCode.emitPopCat1Value(NEW_VALUE);
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                pCode.emitTruncate(TEMP_1, 2, NEW_VALUE);
                pCode.emitWriteToMemory("ram", 2, FIELD_OFFSET, TEMP_1);
                break;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                pCode.emitPopCat1Value(NEW_VALUE);
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                pCode.emitWriteToMemory("ram", 4, FIELD_OFFSET, NEW_VALUE);
                break;
            }
            case 'D': 
            case 'J': {
                pCode.emitPopCat2Value(NEW_VALUE);
                pCode.emitPopCat1Value(OBJECT_REF);
                pCode.emitAssignVarnodeFromPcodeOpCall(FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                pCode.emitWriteToMemory("ram", 8, FIELD_OFFSET, NEW_VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
            }
        }
    }

    static String getDescriptorForFieldRef(AbstractConstantPoolInfoJava[] constantPool, int index) {
        ConstantPoolFieldReferenceInfo fieldRef = (ConstantPoolFieldReferenceInfo)constantPool[index];
        int nameAndTypeIndex = fieldRef.getNameAndTypeIndex();
        ConstantPoolNameAndTypeInfo nameAndTypeInfo = (ConstantPoolNameAndTypeInfo)constantPool[nameAndTypeIndex];
        ConstantPoolUtf8Info descriptorInfo = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getDescriptorIndex()];
        return descriptorInfo.getString();
    }
}

