/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.EHIPToStateModel;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;

public class CreateEHIPToStateMapBackgroundCmd
extends AbstractCreateDataBackgroundCmd<EHIPToStateModel> {
    public CreateEHIPToStateMapBackgroundCmd(Address address, int count) {
        super("IPToStateMapEntry", address, count);
    }

    public CreateEHIPToStateMapBackgroundCmd(Address address, int count, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("IPToStateMapEntry", address, count, validationOptions, applyOptions);
    }

    CreateEHIPToStateMapBackgroundCmd(EHIPToStateModel ipToStateModel, DataApplyOptions applyOptions) {
        super(ipToStateModel, applyOptions);
    }

    @Override
    protected EHIPToStateModel createModel(Program program) {
        if (this.model == null) {
            this.model = new EHIPToStateModel(program, this.count, this.getDataAddress(), this.validationOptions);
        }
        return (EHIPToStateModel)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        return this.createIpRefs();
    }

    private boolean createIpRefs() {
        return true;
    }

    @Override
    protected boolean createMarkup() throws CancelledException {
        return true;
    }
}

