/*
 * Decompiled with CFR 0.152.
 */
package help.validator.location;

import ghidra.util.exception.AssertException;
import help.HelpBuildUtils;
import help.validator.model.AnchorDefinition;
import help.validator.model.GhidraTOCFile;
import help.validator.model.HREF;
import help.validator.model.HelpFile;
import help.validator.model.HelpTopic;
import help.validator.model.IMG;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.help.HelpSet;

public abstract class HelpModuleLocation {
    protected Path helpDir;
    private List<HelpTopic> helpTopics = new ArrayList<HelpTopic>();
    protected GhidraTOCFile sourceTOCFile;
    private HelpSet helpSet;

    HelpModuleLocation(Path source) {
        this.helpDir = source;
        this.loadHelpTopics();
        this.sourceTOCFile = this.loadSourceTOCFile();
        this.helpSet = this.loadHelpSet();
    }

    public abstract GhidraTOCFile loadSourceTOCFile();

    public abstract HelpSet loadHelpSet();

    public abstract boolean isHelpInputSource();

    protected void loadHelpTopics() {
        Path helpTopicsDir = this.helpDir.resolve("topics");
        if (!Files.exists(helpTopicsDir, new LinkOption[0])) {
            HelpBuildUtils.debug("No topics found in help dir: " + String.valueOf(this));
        }
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(helpTopicsDir);){
            for (Path file : ds) {
                if (!Files.isDirectory(file, new LinkOption[0])) continue;
                this.helpTopics.add(new HelpTopic(this, file));
            }
        }
        catch (IOException e) {
            throw new AssertException("No topics found in help dir: " + String.valueOf(this));
        }
    }

    public Path getHelpLocation() {
        return this.helpDir;
    }

    public Path getHelpModuleLocation() {
        Path srcMainHelp = this.helpDir.getParent();
        Path srcMain = srcMainHelp.getParent();
        Path src = srcMain.getParent();
        Path module = src.getParent();
        return module;
    }

    public Path getModuleRepoRoot() {
        Path module = this.getHelpModuleLocation();
        Path category = module.getParent();
        Path repo = category.getParent();
        Path repoRoot = repo.getParent();
        return repoRoot;
    }

    GhidraTOCFile getSourceTOCFile() {
        return this.sourceTOCFile;
    }

    HelpSet getHelpSet() {
        return this.helpSet;
    }

    public Collection<HelpTopic> getHelpTopics() {
        return new ArrayList<HelpTopic>(this.helpTopics);
    }

    public Collection<HREF> getAllHREFs() {
        ArrayList<HREF> list = new ArrayList<HREF>();
        for (HelpTopic helpTopic : this.helpTopics) {
            list.addAll(helpTopic.getAllHREFs());
        }
        return list;
    }

    public Collection<IMG> getAllIMGs() {
        ArrayList<IMG> list = new ArrayList<IMG>();
        for (HelpTopic helpTopic : this.helpTopics) {
            list.addAll(helpTopic.getAllIMGs());
        }
        return list;
    }

    Collection<AnchorDefinition> getAllAnchorDefinitions() {
        ArrayList<AnchorDefinition> list = new ArrayList<AnchorDefinition>();
        for (HelpTopic helpTopic : this.helpTopics) {
            list.addAll(helpTopic.getAllAnchorDefinitions());
        }
        return list;
    }

    Collection<HelpFile> getHelpFiles() {
        ArrayList<HelpFile> result = new ArrayList<HelpFile>();
        for (HelpTopic topic : this.helpTopics) {
            result.addAll(topic.getHelpFiles());
        }
        return result;
    }

    boolean containsHelp() {
        if (this.helpTopics.isEmpty()) {
            return false;
        }
        for (HelpTopic topic : this.helpTopics) {
            Collection<HelpFile> helpFiles = topic.getHelpFiles();
            if (helpFiles.isEmpty()) continue;
            return true;
        }
        return false;
    }

    Map<HelpFile, Map<String, List<AnchorDefinition>>> getDuplicateAnchorsByFile() {
        HashMap<HelpFile, Map<String, List<AnchorDefinition>>> map = new HashMap<HelpFile, Map<String, List<AnchorDefinition>>>();
        for (HelpTopic helpTopic : this.helpTopics) {
            Collection<HelpFile> helpFiles = helpTopic.getHelpFiles();
            for (HelpFile helpFile : helpFiles) {
                Map<String, List<AnchorDefinition>> anchors = helpFile.getDuplicateAnchorsByID();
                if (anchors.size() <= 0) continue;
                map.put(helpFile, anchors);
            }
        }
        return map;
    }

    Map<HelpTopic, List<AnchorDefinition>> getDuplicateAnchorsByTopic() {
        HashMap<HelpTopic, List<AnchorDefinition>> map = new HashMap<HelpTopic, List<AnchorDefinition>>();
        for (HelpTopic helpTopic : this.helpTopics) {
            List<AnchorDefinition> duplicateDefinitions = this.getDuplicateTopicAnchorDefinitions(helpTopic);
            if (duplicateDefinitions.size() <= 0) continue;
            map.put(helpTopic, duplicateDefinitions);
        }
        return map;
    }

    private List<AnchorDefinition> getDuplicateTopicAnchorDefinitions(HelpTopic helpTopic) {
        HashMap<String, ArrayList<AnchorDefinition>> map = new HashMap<String, ArrayList<AnchorDefinition>>();
        Collection<HelpFile> helpFiles = helpTopic.getHelpFiles();
        for (HelpFile helpFile : helpFiles) {
            Collection<AnchorDefinition> definitions = helpFile.getAllAnchorDefinitions();
            for (AnchorDefinition anchorDefinition : definitions) {
                String name = anchorDefinition.getAnchorName();
                if (name == null) continue;
                ArrayList<AnchorDefinition> list = (ArrayList<AnchorDefinition>)map.get(name);
                if (list == null) {
                    list = new ArrayList<AnchorDefinition>();
                    map.put(name, list);
                }
                list.add(anchorDefinition);
            }
        }
        ArrayList<AnchorDefinition> list = new ArrayList<AnchorDefinition>();
        Collection values = map.values();
        for (List definitions : values) {
            if (definitions.size() <= 1) continue;
            list.addAll(definitions);
        }
        return list;
    }

    public String toString() {
        return this.helpDir.toUri().toString();
    }
}

