/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.hover.AbstractReferenceHover;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import javax.swing.JComponent;

public class ReferenceDecompilerHover
extends AbstractReferenceHover
implements DecompilerHoverService {
    private static final String NAME = "Decompiler Reference Viewer";
    private static final String DESCRIPTION = "Shows \"referred to\" code and data from the decompiler.";
    private static final int PRIORITY = 50;

    public ReferenceDecompilerHover(PluginTool tool) {
        super(tool, 50);
    }

    protected String getName() {
        return NAME;
    }

    protected String getDescription() {
        return DESCRIPTION;
    }

    protected String getOptionsCategory() {
        return "Decompiler Popups";
    }

    public JComponent getHoverComponent(Program program, ProgramLocation location, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || location == null) {
            return null;
        }
        Address refAddr = location.getRefAddress();
        if (refAddr == null) {
            return null;
        }
        Function other = program.getListing().getFunctionAt(refAddr);
        if (other != null) {
            return null;
        }
        return super.getHoverComponent(program, location, fieldLocation, field);
    }
}

