/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.SliceHighlightColorProvider;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.HelpLocation;
import java.util.Set;

public class BackwardsSliceAction
extends AbstractDecompilerAction {
    public static final String NAME = "Highlight Backward Slice";

    public BackwardsSliceAction() {
        super(NAME);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionHighlight"));
        this.setPopupMenuData(new MenuData(new String[]{"Highlight", "Backward Slice"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        return varnode != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        if (varnode == null) {
            return;
        }
        DecompilerPanel decompilerPanel = context.getDecompilerPanel();
        decompilerPanel.clearPrimaryHighlights();
        PcodeOp op = tokenAtCursor.getPcodeOp();
        Set<Varnode> backwardSlice = DecompilerUtils.getBackwardSlice(varnode);
        SliceHighlightColorProvider colorProvider = new SliceHighlightColorProvider(decompilerPanel, backwardSlice, varnode, op);
        decompilerPanel.addHighlights(backwardSlice, colorProvider);
    }
}

