/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.DynamicEntry;
import ghidra.program.model.pcode.EquateSymbol;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.HelpLocation;
import java.util.List;

public class RemoveEquateAction
extends AbstractDecompilerAction {
    public RemoveEquateAction() {
        super("Remove Equate");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRemoveEquate"));
        this.setPopupMenuData(new MenuData(new String[]{"Remove Convert/Equate"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (!(tokenAtCursor instanceof ClangVariableToken)) {
            return false;
        }
        Varnode convertVn = tokenAtCursor.getVarnode();
        if (convertVn == null || !convertVn.isConstant()) {
            return false;
        }
        HighSymbol symbol = convertVn.getHigh().getSymbol();
        return symbol instanceof EquateSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReference(Program program, Equate equate, Address refAddr, long convertHash) {
        int transaction = program.startTransaction("Remove Equate Reference");
        boolean commit = false;
        try {
            if (equate.getReferenceCount() <= 1) {
                program.getEquateTable().removeEquate(equate.getName());
            } else {
                equate.removeReference(convertHash, refAddr);
            }
            commit = true;
        }
        finally {
            program.endTransaction(transaction, commit);
        }
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (!(tokenAtCursor instanceof ClangVariableToken)) {
            return;
        }
        Varnode convertVn = tokenAtCursor.getVarnode();
        if (convertVn == null || !convertVn.isConstant()) {
            return;
        }
        HighSymbol convertSymbol = convertVn.getHigh().getSymbol();
        if (convertSymbol instanceof EquateSymbol) {
            Address convertAddr = convertSymbol.getPCAddress();
            SymbolEntry entry = convertSymbol.getFirstWholeMap();
            if (!(entry instanceof DynamicEntry)) {
                return;
            }
            long convertHash = ((DynamicEntry)entry).getHash();
            Program program = context.getProgram();
            EquateTable equateTable = program.getEquateTable();
            List equates = equateTable.getEquates(convertAddr);
            for (Equate equate : equates) {
                if (equate.getValue() != convertVn.getOffset()) continue;
                this.removeReference(program, equate, convertAddr, convertHash);
                break;
            }
        }
    }
}

