/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import generic.theme.GIcon;
import ghidra.app.decompiler.CTokenHighlightMatcher;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompilerHighlightService;
import ghidra.app.decompiler.DecompilerMarginService;
import ghidra.app.decompiler.component.margin.DecompilerMarginProvider;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompiler.taint.CreateTargetIndexTask;
import ghidra.app.plugin.core.decompiler.taint.PurgeIndexTask;
import ghidra.app.plugin.core.decompiler.taint.RunPCodeExportScriptTask;
import ghidra.app.plugin.core.decompiler.taint.TaintDecompilerMarginProvider;
import ghidra.app.plugin.core.decompiler.taint.TaintLabel;
import ghidra.app.plugin.core.decompiler.taint.TaintOptions;
import ghidra.app.plugin.core.decompiler.taint.TaintProvider;
import ghidra.app.plugin.core.decompiler.taint.TaintQueryResult;
import ghidra.app.plugin.core.decompiler.taint.TaintService;
import ghidra.app.plugin.core.decompiler.taint.TaintSliceTreeProvider;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraState;
import ghidra.app.services.ConsoleService;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.database.SpecExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import resources.Icons;
import sarif.SarifService;

@PluginInfo(status=PluginStatus.UNSTABLE, packageName="Ghidra Core", category="Analysis", shortDescription="DecompilerTaint", description="Plugin for tracking taint through the decompiler", servicesProvided={TaintService.class}, servicesRequired={DecompilerHighlightService.class, DecompilerMarginService.class, ConsoleService.class, SarifService.class}, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramOpenedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class, ProgramClosedPluginEvent.class})
public class TaintPlugin
extends ProgramPlugin
implements TaintService {
    public static final String HELP_LOCATION = "DecompilerTaint";
    private Function currentFunction;
    private DecompilerMarginService marginService;
    private ConsoleService consoleService;
    private SarifService sarifService;
    private TaintProvider taintProvider;
    private TaintDecompilerMarginProvider taintDecompMarginProvider;
    private DecompilerHighlightService highlightService;
    private TaintState state;
    static final String SHOW_TAINT_TREE_ACTION_NAME = "Taint Slice Tree";
    public static final Icon PROVIDER_ICON = Icons.ARROW_DOWN_RIGHT_ICON;
    public static final Icon FUNCTION_ICON = new GIcon("icon.plugin.calltree.function");
    public static final Icon RECURSIVE_ICON = new GIcon("icon.plugin.calltree.recursive");
    public static final Icon TAINT_TREE_ICON = new GIcon("icon.plugin.functiongraph.layout.nested.code");
    private Map<String, TaintSliceTreeProvider> taintTreeProviders = new HashMap<String, TaintSliceTreeProvider>();
    static final Logger log = LogManager.getLogger(TaintPlugin.class);

    public TaintPlugin(PluginTool tool) {
        super(tool);
        this.taintProvider = new TaintProvider(this);
        this.taintDecompMarginProvider = new TaintDecompilerMarginProvider(this);
        this.createActions();
    }

    public void showOrCreateNewSliceTree(Program program, ClangToken tokenAtCursor, HighVariable highVariable) {
        Msg.info((Object)this, (Object)"showOrCreateNewSliceTree");
        if (program == null) {
            return;
        }
        String treeProviderKey = highVariable != null ? highVariable.toString() : tokenAtCursor.toString();
        TaintSliceTreeProvider provider = this.taintTreeProviders.get(treeProviderKey);
        if (provider != null) {
            this.tool.showComponentProvider((ComponentProvider)provider, true);
            return;
        }
        if (highVariable == null) {
            this.createAndShowProvider(tokenAtCursor);
            return;
        }
        this.createAndShowProvider(highVariable);
    }

    private void createAndShowProvider(ClangToken token) {
        TaintSliceTreeProvider provider = new TaintSliceTreeProvider(this, false);
        this.taintTreeProviders.put(token.toString(), provider);
        this.tool.showComponentProvider((ComponentProvider)provider, true);
    }

    private void createAndShowProvider(HighVariable highVar) {
        TaintSliceTreeProvider provider = new TaintSliceTreeProvider(this, false);
        this.taintTreeProviders.put(highVar.toString(), provider);
        provider.initialize(this.currentProgram, this.currentLocation);
        this.tool.showComponentProvider((ComponentProvider)provider, true);
    }

    public ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public void removeProvider(TaintSliceTreeProvider provider) {
        for (Map.Entry<String, TaintSliceTreeProvider> mapping : this.taintTreeProviders.entrySet()) {
            if (provider != mapping.getValue()) continue;
            this.taintTreeProviders.remove(mapping.getKey());
            this.tool.removeComponentProvider((ComponentProvider)mapping.getValue());
            mapping.getValue().dispose();
            return;
        }
    }

    protected void programDeactivated(Program program) {
        for (TaintSliceTreeProvider provider : this.taintTreeProviders.values()) {
            provider.programDeactivated(program);
        }
    }

    protected void programClosed(Program program) {
        for (TaintSliceTreeProvider provider : this.taintTreeProviders.values()) {
            provider.programClosed(program);
        }
    }

    public Function getFunction(ProgramLocation location) {
        FunctionManager functionManager = this.currentProgram.getFunctionManager();
        Address address = location.getAddress();
        Function function = functionManager.getFunctionContaining(address);
        function = this.resolveFunction(function, address);
        return function;
    }

    public Function getCurrentFunction() {
        return this.currentFunction;
    }

    Function resolveFunction(Function function, Address address) {
        Reference[] references;
        if (function != null) {
            return function;
        }
        FunctionManager functionManager = this.currentProgram.getFunctionManager();
        ReferenceManager referenceManager = this.currentProgram.getReferenceManager();
        for (Reference reference : references = referenceManager.getReferencesFrom(address)) {
            Address toAddress = reference.getToAddress();
            Function toFunction = functionManager.getFunctionAt(toAddress);
            if (toFunction == null) continue;
            return toFunction;
        }
        return null;
    }

    protected void dispose() {
        ArrayList<TaintSliceTreeProvider> copy = new ArrayList<TaintSliceTreeProvider>(this.taintTreeProviders.values());
        for (TaintSliceTreeProvider provider : copy) {
            this.removeProvider(provider);
        }
    }

    protected void locationChanged(ProgramLocation loc) {
        for (TaintSliceTreeProvider provider : this.taintTreeProviders.values()) {
            provider.setLocation(loc);
        }
    }

    protected void programActivated(Program program) {
        this.currentProgram = program;
        for (TaintSliceTreeProvider provider : this.taintTreeProviders.values()) {
            provider.programActivated(program);
        }
    }

    public void init() {
    }

    private void createActions() {
        final TaintPlugin plugin = this;
        DockingAction exportAllAction = new DockingAction("ExportFacts", HELP_LOCATION){

            public void actionPerformed(ActionContext context) {
                GhidraState ghidraState = new GhidraState(TaintPlugin.this.tool, null, TaintPlugin.this.currentProgram, TaintPlugin.this.currentLocation, TaintPlugin.this.currentHighlight, TaintPlugin.this.currentHighlight);
                GhidraScript exportScript = TaintPlugin.this.state.getExportScript(TaintPlugin.this.consoleService, false);
                if (exportScript != null) {
                    RunPCodeExportScriptTask export_task = new RunPCodeExportScriptTask(TaintPlugin.this.tool, exportScript, ghidraState, TaintPlugin.this.consoleService);
                    TaintPlugin.this.tool.execute((Task)export_task);
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                return plugin.getCurrentProgram() != null;
            }
        };
        exportAllAction.setMenuBarData(new MenuData(new String[]{"Tools", "Source-Sink", "Export PCode Facts"}));
        DockingAction saveTableDataAction = new DockingAction("InitializeIndex", HELP_LOCATION){

            public void actionPerformed(ActionContext context) {
                CreateTargetIndexTask index_task = new CreateTargetIndexTask(plugin, plugin.getCurrentProgram());
                TaintPlugin.this.tool.execute((Task)index_task);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return plugin.getCurrentProgram() != null;
            }
        };
        saveTableDataAction.setMenuBarData(new MenuData(new String[]{"Tools", "Source-Sink", "Initialize Program Index"}));
        DockingAction deleteFactsAndIndex = new DockingAction("DeleteIndex", HELP_LOCATION){

            public void actionPerformed(ActionContext context) {
                PurgeIndexTask index_task = new PurgeIndexTask(plugin, plugin.getCurrentProgram());
                TaintPlugin.this.tool.execute((Task)index_task);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return plugin.getCurrentProgram() != null;
            }
        };
        deleteFactsAndIndex.setMenuBarData(new MenuData(new String[]{"Tools", "Source-Sink", "Delete Facts and Index"}));
        DockingAction exportFuncAction = new DockingAction("ReexportFacts", HELP_LOCATION){

            public void actionPerformed(ActionContext context) {
                GhidraState ghidraState = new GhidraState(TaintPlugin.this.tool, null, TaintPlugin.this.currentProgram, TaintPlugin.this.currentLocation, TaintPlugin.this.currentHighlight, TaintPlugin.this.currentHighlight);
                GhidraScript exportScript = TaintPlugin.this.state.getExportScript(TaintPlugin.this.consoleService, true);
                RunPCodeExportScriptTask export_task = new RunPCodeExportScriptTask(TaintPlugin.this.tool, exportScript, ghidraState, TaintPlugin.this.consoleService);
                TaintPlugin.this.tool.execute((Task)export_task);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return plugin.getCurrentProgram() != null;
            }
        };
        exportFuncAction.setMenuBarData(new MenuData(new String[]{"Tools", "Source-Sink", "Re-export Function Facts"}));
        this.tool.addAction((DockingActionIf)deleteFactsAndIndex);
        this.tool.addAction((DockingActionIf)exportAllAction);
        this.tool.addAction((DockingActionIf)exportFuncAction);
        this.tool.addAction((DockingActionIf)saveTableDataAction);
    }

    public TaintState getTaintState() {
        return this.state;
    }

    public void setTaintState(TaintState state) {
        this.state = state;
    }

    public TaintProvider getProvider() {
        return this.taintProvider;
    }

    public TaintOptions getOptions() {
        return this.taintProvider.getOptions();
    }

    public Program getCurrentProgram() {
        return this.currentProgram;
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof ProgramClosedPluginEvent) {
            Program program = ((ProgramClosedPluginEvent)event).getProgram();
            if (this.currentProgram != null && this.currentProgram.equals((Object)program)) {
                this.currentProgram = null;
                this.taintProvider.doSetProgram(null);
            }
            return;
        }
        if (this.taintProvider == null) {
            return;
        }
        if (event instanceof ProgramActivatedPluginEvent) {
            this.currentProgram = ((ProgramActivatedPluginEvent)event).getActiveProgram();
            this.taintProvider.doSetProgram(this.currentProgram);
            if (this.currentProgram != null) {
                SpecExtension.registerOptions((Program)this.currentProgram);
            }
        } else if (event instanceof ProgramLocationPluginEvent) {
            this.taintProvider.contextChanged();
            ProgramLocation location = ((ProgramLocationPluginEvent)event).getLocation();
            Address address = location.getAddress();
            if (address.isExternalAddress()) {
                return;
            }
            if (this.currentProgram != null) {
                Listing listing = this.currentProgram.getListing();
                Function f = listing.getFunctionContaining(address);
                if (this.currentFunction == null || !this.currentFunction.equals((Object)f)) {
                    String cfun = "NULL";
                    String nfun = "NULL";
                    if (this.currentFunction != null) {
                        cfun = this.currentFunction.getEntryPoint().toString();
                    }
                    if (f != null) {
                        nfun = f.getEntryPoint().toString();
                    }
                    Msg.info((Object)this, (Object)("Changed from function: " + cfun + " to function " + nfun));
                    this.currentFunction = f;
                    this.taintDecompMarginProvider.functionChanged();
                    this.taintProvider.setTaint();
                }
            }
        }
    }

    private void initHighlighters() {
        this.highlightService = (DecompilerHighlightService)this.tool.getService(DecompilerHighlightService.class);
        VertexHighlighter matcher = new VertexHighlighter();
        this.taintProvider.setHighlighter(this.highlightService, matcher);
    }

    public void changeHighlighter(Highlighter hl) {
        if (this.highlightService == null) {
            return;
        }
        Object matcher = hl.equals((Object)Highlighter.LABELS) ? new TaintLabelHighlighter() : new VertexHighlighter();
        this.taintProvider.setHighlighter(this.highlightService, (CTokenHighlightMatcher)matcher);
    }

    public DecompilerProvider getDecompilerProvider() {
        if (this.marginService == null) {
            this.marginService = (DecompilerMarginService)this.tool.getService(DecompilerMarginService.class);
            this.marginService.addMarginProvider((DecompilerMarginProvider)this.taintDecompMarginProvider);
        }
        if (this.highlightService == null) {
            this.initHighlighters();
        }
        if (this.consoleService == null) {
            this.consoleService = (ConsoleService)this.tool.getService(ConsoleService.class);
        }
        return (DecompilerProvider)this.marginService;
    }

    public void toggleIcon(TaintState.MarkType mtype, ClangToken token, boolean bySymbol) {
        TaintLabel label;
        try {
            label = this.state.toggleMark(mtype, token);
            label.setBySymbol(bySymbol);
        }
        catch (PcodeException e) {
            e.printStackTrace();
            return;
        }
        this.taintDecompMarginProvider.toggleIcon(label);
        Msg.info((Object)this, (Object)("Mark Toggle: " + label.toString()));
        this.consoleMessage("Mark Toggle: " + label.toString());
    }

    public void clearIcons() {
        this.taintDecompMarginProvider.clearIcons();
    }

    public void toggleMarginIcon(TaintLabel label) {
        this.taintDecompMarginProvider.toggleIcon(label);
    }

    @Override
    public void clearTaint() {
        this.taintProvider.clearTaint();
    }

    public void consoleMessage(String msg) {
        this.consoleService.addMessage(this.getName(), msg);
    }

    public void makeSelection(List<Address> addrs) {
        AddressSet selection = new AddressSet();
        for (Address addr : addrs) {
            if (addr == null) continue;
            selection.add(addr);
        }
        this.setSelection((AddressSetView)selection);
    }

    public SarifService getSarifService() {
        if (this.sarifService == null) {
            this.sarifService = (SarifService)this.tool.getService(SarifService.class);
        }
        return this.sarifService;
    }

    @Override
    public void setAddressSet(AddressSet set, boolean clear) {
        if (clear) {
            this.taintProvider.clearTaint();
        }
        this.state.setTaintAddressSet(set);
        this.taintProvider.setTaint();
    }

    @Override
    public void setVarnodeMap(Map<Address, Set<TaintQueryResult>> vmap, boolean clear, TaintState.TaskType delta) {
        if (clear) {
            this.taintProvider.clearTaint();
        }
        this.state.setTaintVarnodeMap(vmap, delta);
        this.taintProvider.setTaint(delta);
    }

    @Override
    public AddressSet getAddressSet() {
        return this.state.getTaintAddressSet();
    }

    @Override
    public Map<Address, Set<TaintQueryResult>> getVarnodeMap() {
        return this.state.getTaintVarnodeMap();
    }

    private class VertexHighlighter
    implements CTokenHighlightMatcher {
        private VertexHighlighter() {
        }

        public Color getTokenHighlight(ClangToken token) {
            if (TaintPlugin.this.currentFunction == null || token == null) {
                return null;
            }
            HighFunction highFunction = token.getClangFunction().getHighFunction();
            if (highFunction == null) {
                return null;
            }
            if (!TaintPlugin.this.currentFunction.getEntryPoint().equals((Object)highFunction.getFunction().getEntryPoint())) {
                return null;
            }
            if (TaintPlugin.this.taintProvider.matchOn(token)) {
                log.info("Highlighter> MATCHED Token: '{}'", (Object)token.getText());
                TaintPlugin.this.state.augmentAddressSet(token);
                return TaintPlugin.this.taintProvider.getHighlightColor(token);
            }
            return null;
        }
    }

    public static enum Highlighter {
        ALL("all", "variables"),
        LABELS("labels", "labels"),
        DEFAULT("default", "default");

        private String label;
        private String optionString;

        private Highlighter(String optString, String label) {
            this.label = label;
            this.optionString = optString;
        }

        public String getOptionString() {
            return this.optionString;
        }

        public String toString() {
            return this.label;
        }
    }

    private class TaintLabelHighlighter
    implements CTokenHighlightMatcher {
        private TaintLabelHighlighter() {
        }

        public Color getTokenHighlight(ClangToken token) {
            if (TaintPlugin.this.currentFunction == null || token == null) {
                return null;
            }
            assert (TaintPlugin.this.currentFunction.getEntryPoint().equals((Object)token.getClangFunction().getHighFunction().getFunction().getEntryPoint()));
            if (TaintPlugin.this.taintProvider.matchOn(token)) {
                log.info("Highlighter> MATCHED Token: '{}'", (Object)token.getText());
                return TaintPlugin.this.taintProvider.getHighlightColor(token);
            }
            return null;
        }
    }

    public static enum TaintDirection {
        BOTH("all", "both"),
        FORWARD("fwd", "forward"),
        BACKWARD("bwd", "backward"),
        DEFAULT("auto", "auto");

        private String label;
        private String optionString;

        private TaintDirection(String optString, String label) {
            this.label = label;
            this.optionString = optString;
        }

        public String getOptionString() {
            return this.optionString;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum TaintFormat {
        ALL("all", "sarif+all"),
        GRAPHS("graphs", "sarif+graphs"),
        INSTS("insts", "sarif+instructions"),
        PATHS("paths", "sarif"),
        NONE("none", "none");

        private String label;
        private String optionString;

        private TaintFormat(String optString, String label) {
            this.label = label;
            this.optionString = optString;
        }

        public String getOptionString() {
            return this.optionString;
        }

        public String toString() {
            return this.label;
        }
    }
}

