/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.variadic;

import ghidra.app.plugin.core.string.variadic.FunctionCallData;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PcodeFunctionParser {
    private static final int NULL_TERMINATOR_PROBE = -1;
    private Program program;

    public PcodeFunctionParser(Program program) {
        this.program = program;
    }

    public List<FunctionCallData> parseFunctionForCallData(List<PcodeOpAST> pcodeOps, Map<Address, Data> addressToCandidateData, Set<String> variadicFunctionNames) {
        if (pcodeOps == null || addressToCandidateData == null || variadicFunctionNames == null || this.program == null) {
            return null;
        }
        ArrayList<FunctionCallData> functionCallDataList = new ArrayList<FunctionCallData>();
        for (PcodeOpAST callOp : pcodeOps) {
            boolean hasDefinedFormatString;
            String functionName;
            FunctionManager functionManager;
            Function function;
            Varnode callTarget;
            if (callOp.getOpcode() != 7 || (callTarget = callOp.getInput(0)) == null || (function = (functionManager = this.program.getFunctionManager()).getFunctionAt(callTarget.getAddress())) == null || !variadicFunctionNames.contains(functionName = function.getName()) || callOp.getNumInputs() <= function.getParameterCount() || (hasDefinedFormatString = this.searchForVariadicCallData(callOp, addressToCandidateData, functionCallDataList, function))) continue;
            this.searchForHiddenFormatStrings(callOp, functionCallDataList, function);
        }
        return functionCallDataList;
    }

    private boolean searchForVariadicCallData(PcodeOpAST callOp, Map<Address, Data> addressToCandidateData, List<FunctionCallData> functionCallDataList, Function function) {
        StringDataInstance entire;
        String subString;
        Varnode v = callOp.getInput(function.getParameterCount());
        Data data = null;
        Address ramSpaceAddress = this.convertAddressToRamSpace(v.getAddress());
        if (addressToCandidateData.containsKey(ramSpaceAddress)) {
            data = addressToCandidateData.get(ramSpaceAddress);
            functionCallDataList.add(new FunctionCallData(callOp.getSeqnum().getTarget(), function.getName(), data.getDefaultValueRepresentation()));
            return true;
        }
        Data containing = this.program.getListing().getDataContaining(ramSpaceAddress);
        if (containing == null) {
            return false;
        }
        if (addressToCandidateData.containsKey(containing.getAddress()) && (subString = (entire = StringDataInstance.getStringDataInstance((Data)containing)).getByteOffcut((int)(ramSpaceAddress.getOffset() - containing.getAddress().getOffset())).getStringValue()) != null) {
            functionCallDataList.add(new FunctionCallData(callOp.getSeqnum().getTarget(), function.getName(), subString));
            return true;
        }
        return false;
    }

    private void searchForHiddenFormatStrings(PcodeOpAST callOp, List<FunctionCallData> functionCallDataList, Function function) {
        int formatStringSlot = function.getParameterCount() - 1;
        Parameter param = function.getParameter(formatStringSlot);
        if (param == null || param.getSource().equals((Object)SourceType.DEFAULT)) {
            return;
        }
        DataType type = param.getDataType();
        if (type == null || !(type instanceof Pointer)) {
            return;
        }
        String formatStringCandidate = this.findNullTerminatedString(callOp.getInput(formatStringSlot + 1).getAddress(), (Pointer)type);
        if (formatStringCandidate == null) {
            return;
        }
        if (formatStringCandidate.contains("%")) {
            functionCallDataList.add(new FunctionCallData(callOp.getSeqnum().getTarget(), function.getName(), formatStringCandidate));
        }
    }

    private Address convertAddressToRamSpace(Address address) {
        String addressString = address.toString(false);
        return this.program.getAddressFactory().getAddress(addressString);
    }

    String findNullTerminatedString(Address address, Pointer pointer) {
        if (!address.getAddressSpace().isConstantSpace()) {
            return null;
        }
        Address ramSpaceAddress = this.convertAddressToRamSpace(address);
        MemoryBufferImpl memoryBuffer = new MemoryBufferImpl(this.program.getMemory(), ramSpaceAddress);
        DataType charType = pointer.getDataType();
        StringDataInstance stringDataInstance = StringDataInstance.getStringDataInstance((DataType)charType, (MemBuffer)memoryBuffer, (Settings)charType.getDefaultSettings(), (int)-1);
        int detectedLength = stringDataInstance.getStringLength();
        if (detectedLength == -1) {
            return null;
        }
        stringDataInstance = new StringDataInstance(charType, charType.getDefaultSettings(), (MemBuffer)memoryBuffer, detectedLength, true);
        return stringDataInstance.getStringValue();
    }
}

