/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import docking.DockingUtils;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VertexMouseInfo;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class VisualGraphEventForwardingGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener,
VisualGraphMousePlugin<V, E> {
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private VertexMouseInfo<V, E> mousePressedInfo;
    private VertexMouseInfo<V, E> currentMouseEnteredInfo;
    private boolean isHandlingEvent = false;

    public VisualGraphEventForwardingGraphMousePlugin() {
        this(7168);
    }

    public VisualGraphEventForwardingGraphMousePlugin(int modifiers) {
        super(modifiers);
        this.cursor = DEFAULT_CURSOR;
    }

    public boolean checkModifiers(MouseEvent e) {
        int eventModifiers = e.getModifiersEx();
        return ((eventModifiers = this.turnOffControlKey(eventModifiers)) & this.getModifiers()) == eventModifiers;
    }

    private int turnOffControlKey(int eventModifiers) {
        return eventModifiers & ~DockingUtils.CONTROL_KEY_MODIFIER_MASK;
    }

    private boolean isControlClick(MouseEvent e) {
        int osSpecificMask;
        int allModifiers = e.getModifiersEx();
        return (allModifiers & (osSpecificMask = DockingUtils.CONTROL_KEY_MODIFIER_MASK)) == osSpecificMask;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressedInfo = null;
        this.isHandlingEvent = false;
        if (!this.checkModifiers(e)) {
            return;
        }
        VertexMouseInfo<V, E> vertexMouseInfo = this.getTranslatedMouseInfo(e);
        if (vertexMouseInfo == null) {
            return;
        }
        if (vertexMouseInfo.isScaledPastInteractionThreshold()) {
            return;
        }
        this.updateCursor(vertexMouseInfo);
        if (this.allowHeaderClickThroughToLowerLevelMouseHandlers(vertexMouseInfo)) {
            return;
        }
        this.isHandlingEvent = true;
        this.mousePressedInfo = vertexMouseInfo;
        boolean addToSelection = this.isControlClick(e);
        vertexMouseInfo.selectVertex(addToSelection);
        vertexMouseInfo.forwardEvent();
    }

    private VertexMouseInfo<V, E> getTranslatedMouseInfo(MouseEvent e) {
        GraphViewer viewer = this.getGraphViewer(e);
        return GraphViewerUtils.convertMouseEventToVertexMouseEvent(viewer, e);
    }

    private boolean allowHeaderClickThroughToLowerLevelMouseHandlers(VertexMouseInfo<V, E> info) {
        if (info.isPopupClick()) {
            return false;
        }
        return info.isGrabArea();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isHandlingEvent = false;
        if (this.mousePressedInfo != null) {
            Component releasedComponent;
            VertexMouseInfo<V, E> mouseReleasedMouseInfo = this.getTranslatedMouseInfo(e);
            if (mouseReleasedMouseInfo == null) {
                this.handleMouseEventAfterLeavingVertex(e, this.mousePressedInfo);
                return;
            }
            Component pressedComponent = this.mousePressedInfo.getClickedComponent();
            if (pressedComponent != (releasedComponent = mouseReleasedMouseInfo.getClickedComponent())) {
                this.handleMouseEventAfterLeavingVertex(e, this.mousePressedInfo);
                return;
            }
            if (mouseReleasedMouseInfo.isScaledPastInteractionThreshold()) {
                return;
            }
            mouseReleasedMouseInfo.forwardEvent();
            this.isHandlingEvent = true;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.isHandlingEvent = false;
        if (this.mousePressedInfo != null) {
            this.isHandlingEvent = true;
            VertexMouseInfo<V, E> mouseDraggedMouseInfo = this.getTranslatedMouseInfo(e);
            if (mouseDraggedMouseInfo == null) {
                this.handleMouseEventAfterLeavingVertex(e, this.mousePressedInfo);
                return;
            }
            if (this.mousePressedInfo != mouseDraggedMouseInfo) {
                this.handleMouseEventAfterLeavingVertex(e, this.mousePressedInfo);
                return;
            }
            if (mouseDraggedMouseInfo.isScaledPastInteractionThreshold()) {
                return;
            }
            mouseDraggedMouseInfo.forwardEvent();
            mouseDraggedMouseInfo.getViewer().repaint();
            return;
        }
        DockingUtils.hideTipWindow();
    }

    private void handleMouseEventAfterLeavingVertex(MouseEvent e, VertexMouseInfo<V, E> startMouseInfo) {
        if (startMouseInfo.isScaledPastInteractionThreshold()) {
            return;
        }
        GraphViewer<V, E> viewer = startMouseInfo.getViewer();
        V vertex = startMouseInfo.getVertex();
        Point vertexRelativePoint = GraphViewerUtils.translatePointFromViewSpaceToVertexRelativeSpace(viewer, e.getPoint(), vertex);
        VertexMouseInfo<V, E> currentDraggedInfo = viewer.createVertexMouseInfo(e, vertex, vertexRelativePoint);
        currentDraggedInfo.setClickedComponent(startMouseInfo.getClickedComponent(), vertexRelativePoint);
        currentDraggedInfo.forwardEvent();
        viewer.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.isHandlingEvent = false;
        if (this.mousePressedInfo != null) {
            this.isHandlingEvent = true;
            this.repaintVertex(e, this.mousePressedInfo);
            VertexMouseInfo<V, E> mouseClickedMouseInfo = this.getTranslatedMouseInfo(e);
            if (mouseClickedMouseInfo == null) {
                return;
            }
            if (mouseClickedMouseInfo.isScaledPastInteractionThreshold()) {
                return;
            }
            mouseClickedMouseInfo.forwardEvent();
        }
        this.mousePressedInfo = null;
    }

    private void repaintVertex(MouseEvent e, VertexMouseInfo<V, E> mouseInfo) {
        GraphViewer viewer = this.getGraphViewer(e);
        viewer.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setDefaultCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setDefaultCursor(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.isHandlingEvent = false;
        VertexMouseInfo<V, E> mouseMovedMouseInfo = this.getTranslatedMouseInfo(e);
        if (mouseMovedMouseInfo == null) {
            this.triggerMouseExited(this.currentMouseEnteredInfo, mouseMovedMouseInfo);
            this.setDefaultCursor(e);
            this.currentMouseEnteredInfo = null;
            return;
        }
        if (mouseMovedMouseInfo.isScaledPastInteractionThreshold()) {
            return;
        }
        this.isHandlingEvent = true;
        this.triggerMouseExited(this.currentMouseEnteredInfo, mouseMovedMouseInfo);
        this.triggerMouseEntered(this.currentMouseEnteredInfo, mouseMovedMouseInfo);
        this.currentMouseEnteredInfo = mouseMovedMouseInfo;
        mouseMovedMouseInfo.forwardEvent();
    }

    private void triggerMouseExited(VertexMouseInfo<V, E> currentInfo, VertexMouseInfo<V, E> newInfo) {
        if (currentInfo == null) {
            return;
        }
        if (newInfo == null) {
            currentInfo.simulateMouseExitedEvent();
        } else if (newInfo.getClickedComponent() != currentInfo.getClickedComponent()) {
            currentInfo.simulateMouseExitedEvent();
        }
    }

    private void triggerMouseEntered(VertexMouseInfo<V, E> currentInfo, VertexMouseInfo<V, E> newInfo) {
        if (currentInfo == null || newInfo.getClickedComponent() != currentInfo.getClickedComponent()) {
            newInfo.simulateMouseEnteredEvent();
        }
        this.updateCursor(newInfo);
    }

    private void updateCursor(VertexMouseInfo<V, E> info) {
        if (!this.isHandlingEvent) {
            return;
        }
        JComponent c = (JComponent)info.getEventSource();
        c.setCursor(info.getCursorForClickedComponent());
    }

    private void setDefaultCursor(MouseEvent e) {
        if (!this.isHandlingEvent) {
            return;
        }
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }
}

