/*
 * Decompiled with CFR 0.152.
 */
package ghidra.service.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GraphType {
    private final String name;
    private final String description;
    private final Set<String> vertexTypes;
    private final Set<String> edgeTypes;

    public GraphType(String name, String description, List<String> vertexTypes, List<String> edgeTypes) {
        this.name = Objects.requireNonNull(name);
        this.description = Objects.requireNonNull(description);
        this.vertexTypes = Collections.unmodifiableSet(new LinkedHashSet<String>(vertexTypes));
        this.edgeTypes = Collections.unmodifiableSet(new LinkedHashSet<String>(edgeTypes));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getVertexTypes() {
        return new ArrayList<String>(this.vertexTypes);
    }

    public List<String> getEdgeTypes() {
        return new ArrayList<String>(this.edgeTypes);
    }

    public boolean containsVertexType(String vertexType) {
        return this.vertexTypes.contains(vertexType);
    }

    public boolean containsEdgeType(String edgeType) {
        return this.edgeTypes.contains(edgeType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.edgeTypes == null ? 0 : this.edgeTypes.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.vertexTypes == null ? 0 : this.vertexTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphType other = (GraphType)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.description.equals(other.description)) {
            return false;
        }
        if (!this.edgeTypes.equals(other.edgeTypes)) {
            return false;
        }
        return this.vertexTypes.equals(other.vertexTypes);
    }

    public String getOptionsName() {
        return this.getName() + " Graph Type";
    }
}

