/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.rmi;

import ghidra.app.plugin.core.debug.gui.tracermi.launcher.AbstractScriptTraceRmiLaunchOffer;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.AbstractTraceRmiLaunchOffer;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.ScriptAttributesParser;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.dbg.jdi.rmi.jpda.JdiClientThread;
import ghidra.debug.api.ValStr;
import ghidra.debug.api.tracermi.TerminalSession;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JavaTraceRmiLaunchOffer
extends AbstractScriptTraceRmiLaunchOffer {
    public static final String REM = "//";
    public static final int REM_LEN = "//".length();

    public static JavaTraceRmiLaunchOffer create(TraceRmiLauncherServicePlugin plugin, Program program, File script) throws FileNotFoundException {
        ScriptAttributesParser parser = new ScriptAttributesParser(){

            protected boolean ignoreLine(int lineNo, String line) {
                return line.isBlank();
            }

            protected String removeDelimiter(String line) {
                String stripped = line.stripLeading();
                if (!stripped.startsWith(JavaTraceRmiLaunchOffer.REM)) {
                    return null;
                }
                return stripped.substring(REM_LEN);
            }
        };
        ScriptAttributesParser.ScriptAttributes attrs = parser.parseFile(script);
        return new JavaTraceRmiLaunchOffer(plugin, program, script, "JAVA:" + script.getName(), attrs);
    }

    private JavaTraceRmiLaunchOffer(TraceRmiLauncherServicePlugin plugin, Program program, File script, String configName, ScriptAttributesParser.ScriptAttributes attrs) {
        super(plugin, program, script, configName, attrs);
    }

    boolean hasKeyReally(Map<String, String> env, String key) {
        String val = env.get(key);
        return val != null && !val.isBlank();
    }

    protected void launchBackEnd(TaskMonitor monitor, Map<String, TerminalSession> sessions, Map<String, ValStr<?>> args, SocketAddress address) throws Exception {
        ArrayList<Object> commandLine = new ArrayList<Object>();
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        this.prepareSubprocess(commandLine, env, args, address);
        for (Map.Entry ent : this.attrs.extraTtys().entrySet()) {
            if (!((ScriptAttributesParser.TtyCondition)ent.getValue()).isActive(args)) continue;
            AbstractTraceRmiLaunchOffer.NullPtyTerminalSession ns = this.nullPtyTerminal();
            env.put((String)ent.getKey(), ns.name());
            sessions.put(ns.name(), (TerminalSession)ns);
        }
        if (this.hasKeyReally(env, "OPT_JSHELL_PATH")) {
            String classPath = this.computeClassPath(env);
            commandLine.add(0, "--startup");
            commandLine.add(0, "--class-path=" + classPath);
            commandLine.add(0, (String)env.get("OPT_JSHELL_PATH"));
            sessions.put("Shell", (TerminalSession)this.runInTerminal(commandLine, env, this.script.getParentFile(), sessions.values()));
        } else {
            JdiClientThread thread = new JdiClientThread(env);
            thread.start();
        }
    }

    private String computeClassPath(Map<String, String> env) {
        String sep = File.pathSeparator;
        return Stream.of(System.getProperty("java.class.path").split(sep)).filter(p -> new File((String)p).exists()).collect(Collectors.joining(sep));
    }

    public boolean requiresImage() {
        return false;
    }
}

