/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.rmi;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.AbstractTraceRmiLaunchOpinion;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.dbg.jdi.rmi.JavaTraceRmiLaunchOffer;
import ghidra.debug.api.tracermi.TraceRmiLaunchOffer;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JavaTraceRmiLaunchOpinion
extends AbstractTraceRmiLaunchOpinion {
    public Collection<TraceRmiLaunchOffer> getOffers(TraceRmiLauncherServicePlugin plugin, Program program) {
        return this.getScriptPaths(plugin.getTool()).flatMap(rf -> Stream.of(rf.listFiles(crf -> crf.getName().endsWith(".jsh")))).flatMap(sf -> this.createOffer(plugin, program, (ResourceFile)sf)).collect(Collectors.toList());
    }

    protected Stream<TraceRmiLaunchOffer> createOffer(TraceRmiLauncherServicePlugin plugin, Program program, ResourceFile scriptFile) {
        try {
            return Stream.of(JavaTraceRmiLaunchOffer.create(plugin, program, scriptFile.getFile(false)));
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Could not offer " + String.valueOf(scriptFile) + ": " + e.getMessage()), (Throwable)e);
            return Stream.of(new TraceRmiLaunchOffer[0]);
        }
    }
}

