/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.rmi.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ModuleReference;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.MonitorContendedEnterRequest;
import com.sun.jdi.request.MonitorContendedEnteredRequest;
import com.sun.jdi.request.MonitorWaitRequest;
import com.sun.jdi.request.MonitorWaitedRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.jdi.request.VMDeathRequest;
import ghidra.app.plugin.core.debug.client.tracermi.MemoryMapper;
import ghidra.app.plugin.core.debug.client.tracermi.RegisterMapper;
import ghidra.app.plugin.core.debug.client.tracermi.RmiClient;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTrace;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTraceObject;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTraceObjectValue;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTransaction;
import ghidra.dbg.jdi.manager.impl.JdiManagerImpl;
import ghidra.dbg.jdi.rmi.jpda.JdiArch;
import ghidra.dbg.jdi.rmi.jpda.JdiConnector;
import ghidra.dbg.jdi.rmi.jpda.JdiHooks;
import ghidra.dbg.jdi.rmi.jpda.State;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.rmi.trace.TraceRmi;
import ghidra.trace.model.Lifespan;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class JdiCommands {
    private JdiConnector connector;
    private JdiManagerImpl jdi;
    public State state;
    private String[] regNames = new String[]{"PC", "return_address"};
    public long MAX_REFS = 100L;

    public JdiCommands(JdiConnector connector) {
        this.connector = connector;
        this.jdi = connector.getJdi();
        this.state = new State();
    }

    public void ghidraTraceConnect(String address) {
        this.state.requireNoClient();
        String[] addr = address.split(":");
        if (addr.length != 2) {
            throw new RuntimeException("Address must be in the form 'host:port'");
        }
        try {
            SocketChannel channel = SocketChannel.open(new InetSocketAddress(addr[0], Integer.parseInt(addr[1])));
            this.state.client = new RmiClient(channel, "jdi");
            this.state.client.setRegistry(this.connector.remoteMethodRegistry);
            this.state.client.negotiate("Connect");
            Msg.out((Object)("Connected to " + this.state.client.getDescription()));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Port must be numeric");
        }
        catch (IOException e) {
            throw new RuntimeException("Error connecting to " + address + ": " + String.valueOf(e));
        }
    }

    public void ghidraTraceListen(String address) {
        this.state.requireNoClient();
        String host = "0.0.0.0";
        int port = 0;
        if (address != null) {
            String[] parts = address.split(":");
            if (parts.length == 1) {
                port = Integer.parseInt(parts[0]);
            } else {
                host = parts[0];
                port = Integer.parseInt(parts[1]);
            }
        }
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(host, port);
            ServerSocketChannel channel = ServerSocketChannel.open();
            channel.bind(socketAddress);
            Selector selector = Selector.open();
            while (true) {
                selector.select();
                Set<SelectionKey> selKeys = selector.selectedKeys();
                Iterator<SelectionKey> keyIterator = selKeys.iterator();
                while (keyIterator.hasNext()) {
                    SelectionKey key = keyIterator.next();
                    if (!key.isAcceptable()) continue;
                    SocketChannel client = channel.accept();
                    this.state.client = new RmiClient(client, "jdi");
                    this.state.client.setRegistry(this.connector.remoteMethodRegistry);
                    client.configureBlocking(false);
                    Msg.out((Object)("Connected from " + this.state.client.getDescription()));
                }
                keyIterator.remove();
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Port must be numeric");
        }
        catch (IOException e) {
            throw new RuntimeException("Error connecting to " + address + ": " + String.valueOf(e));
        }
    }

    public void ghidraTraceDisconnect() {
        this.state.requireClient().close();
        this.state.resetClient();
    }

    private String computeName() {
        Optional<String> command;
        VirtualMachine currentVM = this.connector.getJdi().getCurrentVM();
        if (currentVM != null && (command = currentVM.process().info().command()).isPresent()) {
            return "jdi/" + String.valueOf(command);
        }
        return "jdi/noname";
    }

    public void startTrace(String name) {
        JdiArch arch = this.connector.getArch();
        LanguageID language = arch.computeGhidraLanguage();
        CompilerSpecID compiler = arch.computeGhidraCompiler(language);
        this.state.trace = this.state.client.createTrace(name, language, compiler);
        this.state.trace.memoryMapper = arch.computeMemoryMapper();
        this.state.trace.registerMapper = arch.computeRegisterMapper();
        try (RmiTransaction tx = this.state.trace.startTx("Create snapshots", false);){
            this.state.trace.createRootObject(this.connector.rootSchema.getContext(), this.connector.rootSchema.getName().toString());
            AddressRangeImpl range = this.connector.defaultRange;
            byte[] bytes = new byte[(int)range.getLength()];
            Arrays.fill(bytes, (byte)-1);
            this.state.trace.putBytes(range.getMinAddress(), bytes, Long.valueOf(this.state.trace.getSnap()));
        }
    }

    public void ghidraTraceStart(String name) {
        this.state.requireClient();
        if (name == null) {
            name = this.computeName();
        } else if (name.contains("/")) {
            name = name.substring(name.lastIndexOf("/"));
        }
        this.state.requireNoTrace();
        this.startTrace(name);
    }

    public void ghidraTraceStop() {
        this.state.requireTrace().close();
        this.state.resetTrace();
    }

    public void ghidraTraceRestart(String name) {
        this.state.requireClient();
        if (this.state.trace != null) {
            this.state.trace.close();
            this.state.resetTrace();
        }
        if (name == null) {
            name = this.computeName();
        }
        this.startTrace(name);
    }

    public VirtualMachine ghidraTraceCreate(Map<String, String> env) {
        return this.connector.getJdi().createVM(env);
    }

    public void ghidraTraceInfo() {
        if (this.state.client == null) {
            Msg.error((Object)this, (Object)"Not connected to Ghidra");
            return;
        }
        Msg.info((Object)this, (Object)("Connected to " + this.state.client.getDescription()));
        if (this.state.trace == null) {
            Msg.error((Object)this, (Object)"No trace");
        } else {
            Msg.info((Object)this, (Object)"Trace active");
        }
    }

    public void ghidraTraceInfoLcsp() {
        JdiArch arch = this.connector.getArch();
        LanguageID language = arch.computeGhidraLanguage();
        CompilerSpecID compiler = arch.computeGhidraCompiler(language);
        Msg.info((Object)this, (Object)("Selected Ghidra language: " + String.valueOf(language)));
        Msg.info((Object)this, (Object)("Selected Ghidra compiler: " + String.valueOf(compiler)));
    }

    public void ghidraTraceTxStart(String description) {
        this.state.requireNoTx();
        this.state.tx = this.state.requireTrace().startTx(description, false);
    }

    public void ghidraTraceTxCommit() {
        this.state.requireTx().commit();
        this.state.resetTx();
    }

    public void ghidraTraceTxAbort() {
        RmiTransaction tx = this.state.requireTx();
        Msg.info((Object)this, (Object)"Aborting trace transaction!");
        tx.abort();
        this.state.resetTx();
    }

    public void ghidraTraceSave() {
        this.state.requireTrace().save();
    }

    public long ghidraTraceNewSnap(String description) {
        this.state.requireTx();
        return this.state.requireTrace().snapshot(description, null, null);
    }

    public void ghidraTraceSetSnap(long snap) {
        this.state.requireTrace().setSnap(snap);
    }

    public void ghidraTracePutMem(Address address, long length) {
        this.state.requireTx();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutMem", false);){
            this.putMem(address, length, true);
        }
    }

    public void ghidraTracePutMemState(Address address, long length, TraceRmi.MemoryState memState) {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutMemState", false);){
            this.putMemState(address, length, memState, true);
        }
    }

    public void ghidraTraceDelMem(Address address, long length) {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTraceDelMem", false);){
            Address mapped = this.state.trace.memoryMapper.map(address);
            AddressRangeImpl range = new AddressRangeImpl(mapped, mapped.add(length - 1L));
            this.state.trace.deleteBytes((AddressRange)range, Long.valueOf(this.state.trace.getSnap()));
        }
    }

    public void ghidraTracePutReg(StackFrame frame) {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutReg", false);){
            this.putReg(frame);
        }
    }

    public void ghidraTraceDelReg(StackFrame frame) {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTraceDelReg", false);){
            String ppath = this.getPath(frame);
            if (ppath == null) {
                Msg.error((Object)this, (Object)("Null path for " + String.valueOf(frame)));
                return;
            }
            String path = ppath + ".Registers";
            this.state.trace.deleteRegisters(path, this.regNames, Long.valueOf(this.state.trace.getSnap()));
        }
    }

    public void ghidraTraceCreateObj(String path) {
        this.state.requireTx();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTraceCreateObj", false);){
            this.createObject(path);
        }
    }

    public void ghidraTraceInsertObj(String path) {
        this.state.requireTx();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTraceInsertObj", false);){
            Lifespan span = this.state.trace.proxyObjectPath(path).insert(this.state.trace.getSnap(), TraceRmi.Resolution.CR_ADJUST);
            System.out.println("Inserted object: lifespan=" + String.valueOf(span));
        }
    }

    public void ghidraTraceRemoveObj(String path) {
        this.state.requireTx();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTraceRemoveObj", false);){
            Lifespan span = this.state.trace.proxyObjectPath(path).remove(this.state.trace.getSnap(), false);
            System.out.println("Removed object: lifespan=" + String.valueOf(span));
        }
    }

    public void ghidraTraceSetValue(String path, String key, Object value) {
        this.state.requireTx();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTraceSetValue", false);){
            this.setValue(path, key, value);
        }
    }

    public void ghidraTraceRetainValues(String kind, String path, Set<String> keys) {
        this.state.requireTx();
        TraceRmi.ValueKinds kinds = TraceRmi.ValueKinds.VK_ELEMENTS;
        if (kind != null && kind.startsWith("--")) {
            if (kind.equals("--elements")) {
                kinds = TraceRmi.ValueKinds.VK_ELEMENTS;
            }
            if (kind.equals("--attributes")) {
                kinds = TraceRmi.ValueKinds.VK_ATTRIBUTES;
            }
            if (kind.equals("--both")) {
                kinds = TraceRmi.ValueKinds.VK_BOTH;
            }
        }
        this.state.trace.proxyObjectPath(path).retainValues(keys, this.state.trace.getSnap(), kinds);
    }

    public RmiTraceObject ghidraTraceGetObj(String path) {
        this.state.requireTrace();
        return this.state.trace.proxyObjectPath(path);
    }

    public void printValues(List<RmiTraceObjectValue> values) {
        Tabulator tab = new Tabulator(System.out, 5);
        tab.measure("Parent", "Key", "Span", "Value", "Type");
        for (RmiTraceObjectValue d : values) {
            tab.measure(d.parent().getPath(), d.span(), d.key(), d.value(), d.schema());
        }
        tab.print("Parent", "Key", "Span", "Value", "Type");
        for (RmiTraceObjectValue d : values) {
            tab.print(d.parent().getPath(), d.span(), d.key(), d.value(), d.schema());
        }
    }

    public void ghidraTraceGetValues(String pattern) {
        this.state.requireTrace();
        List values = this.state.trace.getValues(pattern);
        this.printValues(values);
    }

    public void ghidraTraceGetValuesRng(Address addr, long sz) {
        this.state.requireTrace();
        List values = this.state.trace.getValuesRng(addr, sz);
        this.printValues(values);
    }

    public void ghidraTracePutVMs() {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutVMs", false);){
            this.putVMs();
        }
    }

    public void ghidraTracePutProcesses() {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutVMs", false);){
            this.putProcesses();
        }
    }

    public void ghidraTracePutBreakpoints() {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutBreakpoints", false);){
            this.putBreakpoints();
        }
    }

    public void ghidraTracePutEvents() {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutEvents", false);){
            this.putEvents();
        }
    }

    public void activate(String path) {
        this.state.requireTrace();
        if (path == null) {
            VirtualMachine currentVM = this.connector.getJdi().getCurrentVM();
            path = this.getPath(currentVM);
            try {
                StackFrame currentFrame;
                ThreadReference currentThread = this.connector.getJdi().getCurrentThread();
                if (currentThread != null) {
                    path = this.getPath(currentThread);
                }
                if ((currentFrame = this.connector.getJdi().getCurrentFrame()) != null) {
                    path = this.getPath(currentFrame);
                }
            }
            catch (VMDisconnectedException discExc) {
                Msg.info((Object)this, (Object)"Activate failed - VM disconnected");
            }
        }
        this.state.trace.activate(path);
    }

    public void ghidraTraceActivate(String path) {
        this.activate(path);
    }

    public void ghidraTraceDisassemble(Address address) {
        this.state.requireTrace();
        MemoryMapper mapper = this.state.trace.memoryMapper;
        Address mappedAddress = mapper.map(address);
        AddressSpace addressSpace = mappedAddress.getAddressSpace();
        if (!addressSpace.equals((Object)address.getAddressSpace())) {
            this.state.trace.createOverlaySpace(mappedAddress, address);
        }
        this.state.trace.disassemble(mappedAddress, Long.valueOf(this.state.trace.getSnap()));
    }

    public void putMemState(Address start, long length, TraceRmi.MemoryState memState, boolean usePages) {
        Address mapped = this.state.trace.memoryMapper.map(start);
        if (mapped.getAddressSpace() != start.getAddressSpace() && !memState.equals((Object)TraceRmi.MemoryState.MS_UNKNOWN)) {
            this.state.trace.createOverlaySpace(mapped, start);
        }
        AddressRangeImpl range = new AddressRangeImpl(mapped, mapped.add(length - 1L));
        this.state.trace.setMemoryState((AddressRange)range, memState, Long.valueOf(this.state.trace.getSnap()));
    }

    public void putReg(StackFrame frame) {
        String ppath = this.getPath(frame);
        if (ppath == null) {
            Msg.error((Object)this, (Object)("Null path for " + String.valueOf(frame)));
            return;
        }
        String path = ppath + ".Registers";
        this.state.trace.createOverlaySpace("register", path);
        RegisterValue[] rvs = this.putRegisters(frame, path);
        this.state.trace.putRegisters(path, rvs, Long.valueOf(this.state.trace.getSnap()));
    }

    public RegisterValue[] putRegisters(StackFrame frame, String ppath) {
        JdiArch arch = this.connector.getArch();
        Language lang = arch.getLanguage();
        HashSet<String> keys = new HashSet<String>();
        RegisterValue[] rvs = new RegisterValue[this.regNames.length];
        int ireg = 0;
        String r = this.regNames[0];
        Register register = lang.getRegister(r);
        if (register == null) {
            register = this.fabricatePcRegister(lang, r);
        }
        keys.add(this.connector.key(r));
        Location loc = frame.location();
        Address addr = this.putRegister(ppath, r, loc);
        RegisterValue rv = new RegisterValue(register, BigInteger.valueOf(addr.getOffset()));
        rvs[ireg++] = rv;
        r = this.regNames[1];
        register = lang.getRegister(r);
        if (register == null) {
            register = this.fabricatePcRegister(lang, r);
        }
        keys.add(this.connector.key(r));
        ThreadReference thread = frame.thread();
        Location ploc = null;
        try {
            int frameCount = thread.frameCount();
            for (int i = 0; i < frameCount; ++i) {
                StackFrame f = thread.frame(i);
                if (!f.equals(frame) || i >= frameCount - 1) continue;
                ploc = thread.frame(i + 1).location();
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        if (ploc != null) {
            addr = this.putRegister(ppath, r, ploc);
            rv = new RegisterValue(register, BigInteger.valueOf(addr.getOffset()));
            rvs[ireg++] = rv;
        } else {
            rv = new RegisterValue(register, BigInteger.valueOf(0L));
            rvs[ireg++] = rv;
        }
        this.retainKeys(ppath, keys);
        return rvs;
    }

    public void putCurrentLocation() {
        Location loc = this.connector.getJdi().getCurrentLocation();
        if (loc == null) {
            return;
        }
        Method m = loc.method();
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        if (this.connector.getAddressRange(m.declaringType()) == null) {
            this.putReferenceType(this.getPath(vm) + ".Classes", m.declaringType(), true);
        } else {
            this.updateMemoryForMethod(m);
        }
    }

    public Address putRegister(String ppath, String name, Location loc) {
        Address addr = this.connector.getAddressFromLocation(loc);
        RegisterMapper mapper = this.state.trace.registerMapper;
        String regName = mapper.mapName(name);
        JdiArch arch = this.connector.getArch();
        Language lang = arch.getLanguage();
        Register register = lang.getRegister(name);
        if (register == null) {
            register = this.fabricatePcRegister(lang, name);
        }
        RegisterValue rv = new RegisterValue(register, addr.getOffsetAsBigInteger());
        RegisterValue mapped = mapper.mapValue(name, rv);
        Address regAddr = addr.getNewAddress(mapped.getUnsignedValue().longValue());
        this.setValue(ppath, this.connector.key(regName), Long.toHexString(regAddr.getOffset()));
        int codeIndex = (int)loc.codeIndex();
        regAddr = regAddr.subtract((long)codeIndex);
        this.putMem(regAddr, codeIndex + 1, false);
        return addr;
    }

    private Register fabricatePcRegister(Language lang, String name) {
        int size = lang.getAddressFactory().getDefaultAddressSpace().getSize();
        return new Register(name, name, null, size, lang.isBigEndian(), 4);
    }

    public void putMem(Address address, long length, boolean create) {
        MemoryMapper mapper = this.state.trace.memoryMapper;
        Address mappedAddress = mapper.map(address);
        AddressSpace addressSpace = mappedAddress.getAddressSpace();
        if (!addressSpace.equals((Object)address.getAddressSpace())) {
            this.state.trace.createOverlaySpace(mappedAddress, address);
        }
        int ilen = (int)length;
        byte[] bytes = new byte[ilen];
        Arrays.fill(bytes, (byte)-1);
        if (addressSpace.getName().equals("ram")) {
            Method method = this.connector.getMethodForAddress(address);
            if (method != null) {
                byte[] bytecodes = method.bytecodes();
                if (bytecodes != null) {
                    bytes = Arrays.copyOf(bytecodes, ilen);
                }
                this.state.trace.putBytes(mappedAddress, bytes, Long.valueOf(this.state.trace.getSnap()));
            } else if (create) {
                throw new RuntimeException("Attempt to create existing memory");
            }
            return;
        }
        if (addressSpace.getName().equals("constantPool")) {
            ReferenceType reftype = this.connector.getReferenceTypeForPoolAddress(address);
            if (reftype != null) {
                byte[] bytecodes = reftype.constantPool();
                if (bytecodes != null) {
                    bytes = Arrays.copyOf(bytecodes, ilen);
                }
                this.state.trace.putBytes(mappedAddress, bytes, Long.valueOf(this.state.trace.getSnap()));
            }
            return;
        }
        throw new RuntimeException();
    }

    public void putType(String ppath, String key, Type type) {
        String path = this.createObject(type, key, ppath);
        this.putTypeDetails(path, type);
        this.insertObject(path);
    }

    public void putTypeDetails(String path, Type type) {
        this.setValue(path, "_display", "Type: " + type.name());
        this.setValue(path, "Signature", type.signature());
    }

    public void putReferenceTypeContainer(String ppath, List<ReferenceType> reftypes) {
        HashSet<String> keys = new HashSet<String>();
        for (ReferenceType ref : reftypes) {
            keys.add(this.connector.key(ref.name()));
            this.putReferenceType(ppath, ref, false);
        }
        this.retainKeys(ppath, keys);
    }

    public void putReferenceType(String ppath, ReferenceType reftype, boolean load) {
        String path = this.createObject(reftype, reftype.name(), ppath);
        if (this.connector.getAddressRange(reftype) == null) {
            this.connector.bumpRamIndex();
        }
        if (load) {
            this.registerMemory(path, reftype);
        }
        this.putReferenceTypeDetails(path, reftype);
        this.insertObject(path);
    }

    public void putReferenceTypeDetails(String path, ReferenceType reftype) {
        String name = reftype.name();
        if (name.indexOf(".") > 0) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        this.setValue(path, "_module_name", name + ".class");
        this.putRefTypeAttributes(path, reftype);
        String fpath = this.createObject(path + ".Fields");
        String ipath = this.createObject(path + ".Instances");
        String lpath = this.createObject(path + ".Locations");
        this.insertObject(fpath);
        this.insertObject(ipath);
        this.insertObject(lpath);
        this.putMethodContainer(path + ".Methods", reftype);
        String rpath = this.createObject(path + ".Relations");
        this.insertObject(rpath);
        try {
            ModuleReference module = reftype.module();
            Object moduleName = module.name();
            if (moduleName == null) {
                moduleName = "<unnamed>";
            }
            if (((String)moduleName).contains(".")) {
                moduleName = "\"" + (String)moduleName + "\"";
            }
            String mrpath = this.createObject(module, (String)moduleName, rpath + ".ModuleRef");
            this.insertObject(mrpath);
        }
        catch (UnsupportedOperationException module) {
            // empty catch block
        }
        if (reftype instanceof ArrayType) {
            ArrayType at = (ArrayType)reftype;
            this.putArrayTypeDetails(rpath, at);
        }
        if (reftype instanceof ClassType) {
            ClassType ct = (ClassType)reftype;
            this.putClassTypeDetails(rpath, ct);
        }
        if (reftype instanceof InterfaceType) {
            InterfaceType it = (InterfaceType)reftype;
            this.putInterfaceTypeDetails(rpath, it);
        }
    }

    private void putRefTypeAttributes(String ppath, ReferenceType reftype) {
        String path;
        block3: {
            path = this.createObject(ppath + ".Attributes");
            if (reftype instanceof ArrayType) {
                return;
            }
            try {
                this.setValue(path, "isAbstract", reftype.isAbstract());
                this.setValue(path, "isFinal", reftype.isFinal());
                this.setValue(path, "isInitialized", reftype.isInitialized());
                this.setValue(path, "isPackagePrivate", reftype.isPackagePrivate());
                this.setValue(path, "isPrepared", reftype.isPrepared());
                this.setValue(path, "isPrivate", reftype.isPrivate());
                this.setValue(path, "isProtected", reftype.isProtected());
                this.setValue(path, "isPublic", reftype.isPublic());
                this.setValue(path, "isStatic", reftype.isStatic());
                this.setValue(path, "isVerified", reftype.isVerified());
            }
            catch (Exception e) {
                if (!(e instanceof ClassNotLoadedException)) break block3;
                this.setValue(path, "status", "Class not loaded");
            }
        }
        this.setValue(path, "defaultStratum", reftype.defaultStratum());
        this.setValue(path, "availableStata", reftype.availableStrata());
        this.setValue(path, "failedToInitialize", reftype.failedToInitialize());
        this.insertObject(path);
    }

    private void registerMemory(String path, ReferenceType reftype) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        String mempath = this.getPath(vm) + ".Memory";
        AddressSet bounds = new AddressSet();
        for (Method m : reftype.methods()) {
            AddressRange range;
            if (m.location() == null || (range = this.connector.registerAddressesForMethod(m)) == null || range.getMinAddress().getOffset() == 0L) continue;
            this.putMem(range.getMinAddress(), range.getLength(), true);
            bounds.add(range);
            String mpath = this.createObject(mempath + this.connector.key(m.toString()));
            this.setValue(mpath, "Range", range);
            this.insertObject(mpath);
        }
        AddressRange range = this.connector.putAddressRange(reftype, bounds);
        this.setValue(path, "Range", range);
        try {
            this.setValue(path, "Count", reftype.constantPoolCount());
            range = this.connector.getPoolAddressRange(reftype, this.getSize(reftype) - 1);
            this.setValue(path, "RangeCP", range);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.putMem(range.getMinAddress(), range.getLength(), true);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void updateMemoryForMethod(Method m) {
        AddressRange range;
        if (m.location() != null && (range = this.connector.registerAddressesForMethod(m)) != null && range.getMinAddress().getOffset() != 0L) {
            this.putMem(range.getMinAddress(), range.getLength(), true);
        }
    }

    public boolean loadReferenceType(String ppath, List<ReferenceType> reftypes, String targetClass) {
        boolean result = false;
        List<ReferenceType> classes = reftypes;
        for (ReferenceType ref : classes) {
            if (!ref.name().contains(targetClass)) continue;
            this.putReferenceType(ppath, ref, true);
            result = true;
        }
        return result;
    }

    public void putArrayTypeDetails(String path, ArrayType type) {
        String cpath = this.createObject(path + ".ComponentType");
        this.setValue(path, "ComponentSignature", type.componentSignature());
        this.setValue(path, "ComponentTypeName", type.componentTypeName());
        this.insertObject(cpath);
    }

    public void putClassTypes(String ppath, List<ClassType> reftypes) {
        HashSet<String> keys = new HashSet<String>();
        for (ClassType ref : reftypes) {
            keys.add(this.connector.key(ref.name()));
            this.putReferenceType(ppath, ref, true);
        }
        this.retainKeys(ppath, keys);
    }

    public void putClassTypeDetails(String path, ClassType type) {
        this.setValue(path, "IsEnum", type.isEnum());
        String aipath = this.createObject(path + ".AllInterfaces");
        String ipath = this.createObject(path + ".Interfaces");
        String scpath = this.createObject(path + ".SubClasses");
        String cpath = this.createObject(path + ".ClassType");
        this.insertObject(aipath);
        this.insertObject(ipath);
        this.insertObject(scpath);
        this.insertObject(cpath);
    }

    public void putInterfaceTypes(String ppath, List<InterfaceType> reftypes) {
        HashSet<String> keys = new HashSet<String>();
        for (ReferenceType referenceType : reftypes) {
            keys.add(this.connector.key(referenceType.name()));
            this.putReferenceType(ppath, referenceType, true);
        }
        this.retainKeys(ppath, keys);
    }

    public void putInterfaceTypeDetails(String path, InterfaceType type) {
        String impath = this.createObject(path + ".Implementors");
        String sbpath = this.createObject(path + ".SubInterfaces");
        String sppath = this.createObject(path + ".SuperInterfaces");
        this.insertObject(impath);
        this.insertObject(sbpath);
        this.insertObject(sppath);
    }

    public void putValueContainer(String path, List<Value> values) {
        for (Value v : values) {
            this.putValue(path, v.toString(), v);
        }
    }

    public void putValue(String ppath, String key, Value value) {
        String path = this.createObject(value, key, ppath);
        this.setValue(path, "_display", "Value: " + value.toString());
        this.insertObject(path);
    }

    public void putValueDetailsByType(String path, Value value) {
        if (value instanceof PrimitiveValue) {
            PrimitiveValue pval = (PrimitiveValue)value;
            this.putPrimitiveValue(path, pval);
        } else if (value instanceof ArrayReference) {
            ArrayReference aref = (ArrayReference)value;
            this.putArrayReferenceDetails(path, aref);
        } else if (value instanceof ClassLoaderReference) {
            ClassLoaderReference aref = (ClassLoaderReference)value;
            this.putClassLoaderReferenceDetails(path, aref);
        } else if (value instanceof ClassObjectReference) {
            ClassObjectReference aref = (ClassObjectReference)value;
            this.putClassObjectReferenceDetails(path, aref);
        } else if (value instanceof ModuleReference) {
            ModuleReference aref = (ModuleReference)value;
            this.putModuleReferenceDetails(path, aref);
        } else if (value instanceof StringReference) {
            StringReference aref = (StringReference)value;
            this.putStringReferenceDetails(path, aref);
        } else if (value instanceof ThreadGroupReference) {
            ThreadGroupReference aref = (ThreadGroupReference)value;
            this.putThreadGroupReferenceDetails(path, aref);
        } else if (value instanceof ThreadReference) {
            ThreadReference aref = (ThreadReference)value;
            this.putThreadReferenceDetails(path, aref);
        } else if (value instanceof ObjectReference) {
            ObjectReference oref = (ObjectReference)value;
            this.putObjectReferenceDetails(path, oref);
        }
    }

    public void putValueDetails(String path, Value value) {
        this.putType(path, "Type", value.type());
    }

    public void putPrimitiveValue(String ppath, PrimitiveValue value) {
        PrimitiveValue v;
        String path = this.createObject(value, value.toString(), ppath);
        this.putValueDetails(path, value);
        if (value instanceof BooleanValue) {
            v = (BooleanValue)value;
            this.setValue(path, "Value", v.booleanValue());
        }
        if (value instanceof ByteValue) {
            ByteValue b = (ByteValue)value;
            this.setValue(path, "Value", b.byteValue());
        }
        if (value instanceof CharValue) {
            v = (CharValue)value;
            this.setValue(path, "Value", Character.valueOf(v.charValue()));
        }
        if (value instanceof ShortValue) {
            v = (ShortValue)value;
            this.setValue(path, "Value", v.shortValue());
        }
        if (value instanceof IntegerValue) {
            v = (IntegerValue)value;
            this.setValue(path, "Value", v.intValue());
        }
        if (value instanceof LongValue) {
            v = (LongValue)value;
            this.setValue(path, "Value", v.longValue());
        }
        if (value instanceof FloatValue) {
            v = (FloatValue)value;
            this.setValue(path, "Value", Float.valueOf(v.floatValue()));
        }
        if (value instanceof DoubleValue) {
            v = (DoubleValue)value;
            this.setValue(path, "Value", v.doubleValue());
        }
        this.insertObject(path);
    }

    private Value getPrimitiveValue(Value value, String newVal) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        if (value instanceof BooleanValue) {
            return vm.mirrorOf(Boolean.valueOf(newVal));
        }
        if (value instanceof ByteValue) {
            return vm.mirrorOf(Byte.valueOf(newVal));
        }
        if (value instanceof CharValue) {
            return vm.mirrorOf(newVal.charAt(0));
        }
        if (value instanceof ShortValue) {
            return vm.mirrorOf(Short.valueOf(newVal));
        }
        if (value instanceof IntegerValue) {
            return vm.mirrorOf(Integer.valueOf(newVal));
        }
        if (value instanceof LongValue) {
            return vm.mirrorOf(Long.valueOf(newVal));
        }
        if (value instanceof FloatValue) {
            return vm.mirrorOf(Float.valueOf(newVal).floatValue());
        }
        if (value instanceof DoubleValue) {
            return vm.mirrorOf(Double.valueOf(newVal));
        }
        if (value instanceof StringReference) {
            return vm.mirrorOf(newVal);
        }
        return null;
    }

    public void modifyValue(LocalVariable lvar, String valstr) {
        StackFrame frame;
        Value orig;
        Value repl;
        String path = this.getPath(lvar);
        String ppath = this.getParentPath(path);
        Object parent = this.connector.objForPath(ppath);
        if (parent instanceof StackFrame && (repl = this.getPrimitiveValue(orig = (frame = (StackFrame)parent).getValue(lvar), valstr)) != null) {
            try {
                frame.setValue(lvar, repl);
            }
            catch (InvalidTypeException e) {
                Msg.error((Object)this, (Object)("Invalid type for " + String.valueOf(lvar)));
            }
            catch (ClassNotLoadedException e) {
                Msg.error((Object)this, (Object)("Class not loaded for " + String.valueOf(lvar)));
            }
            this.putLocalVariable(ppath + ".Variables", lvar, repl);
        }
        Msg.error((Object)this, (Object)("Cannot set value for " + String.valueOf(lvar)));
    }

    public void modifyValue(Field field, String valstr) {
        ObjectReference ref;
        Value orig;
        Value repl;
        String path = this.getPath(field);
        String ppath = this.getParentPath(path);
        Object parent = this.connector.objForPath(ppath);
        if (parent instanceof ObjectReference && (repl = this.getPrimitiveValue(orig = (ref = (ObjectReference)parent).getValue(field), valstr)) != null) {
            try {
                ref.setValue(field, repl);
            }
            catch (InvalidTypeException e) {
                Msg.error((Object)this, (Object)("Invalid type for " + String.valueOf(field)));
            }
            catch (ClassNotLoadedException e) {
                Msg.error((Object)this, (Object)("Class not loaded for " + String.valueOf(field)));
            }
            this.putField(ppath + ".Variables", field, repl);
        }
        Msg.error((Object)this, (Object)("Cannot set value for " + String.valueOf(field)));
    }

    public void putObjectContainer(String path, List<ObjectReference> objects) {
        for (ObjectReference obj : objects) {
            String opath = this.createObject(obj, obj.toString(), path);
            this.insertObject(opath);
        }
    }

    public void putObjectReference(String ppath, ObjectReference ref) {
        String path = this.createObject(ref, ref.toString(), ppath);
        this.putObjectReferenceDetails(path, ref);
        this.insertObject(path);
    }

    public void putObjectReferenceDetails(String path, ObjectReference ref) {
        this.putValueDetails(path, ref);
        this.setValue(path, "UniqueId", ref.uniqueID());
        String apath = this.createObject(path + ".Attributes");
        try {
            this.setValue(apath, "entryCount", ref.entryCount());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        this.setValue(apath, "isCollected", ref.isCollected());
        this.insertObject(apath);
        String rpath = this.createObject(path + ".Relations");
        try {
            if (ref.owningThread() != null) {
                String otpath = this.createObject(rpath + ".OwningThread");
                this.insertObject(otpath);
            }
            if (ref.waitingThreads() != null) {
                String wtpath = this.createObject(rpath + ".WaitingThreads");
                this.insertObject(wtpath);
            }
        }
        catch (IncompatibleThreadStateException wtpath) {
            // empty catch block
        }
        if (ref.referenceType() != null) {
            String rtpath = this.createObject(rpath + ".ReferenceType");
            this.insertObject(rtpath);
        }
        if (ref.referringObjects(this.MAX_REFS) != null) {
            String ropath = this.createObject(rpath + ".ReferringObjects");
            this.insertObject(ropath);
        }
        if (!(ref instanceof ArrayReference)) {
            String vpath = this.createObject(path + ".Variables");
            this.insertObject(vpath);
        }
        this.insertObject(rpath);
    }

    public void putArrayReference(String ppath, ArrayReference ref) {
        String path = this.createObject(ref, ref.toString(), ppath);
        this.putArrayReferenceDetails(path, ref);
        this.insertObject(path);
    }

    public void putArrayReferenceDetails(String path, ArrayReference ref) {
        this.putObjectReferenceDetails(path, ref);
        this.setValue(path, "Length", ref.length());
        String vpath = this.createObject(path + ".Values");
        this.insertObject(vpath);
    }

    public void putClassLoaderReference(String ppath, ClassLoaderReference ref) {
        String path = this.createObject(ref, ref.toString(), ppath);
        this.putClassLoaderReferenceDetails(path, ref);
        this.insertObject(path);
    }

    public void putClassLoaderReferenceDetails(String path, ClassLoaderReference ref) {
        this.putObjectReferenceDetails(path, ref);
        String dcpath = this.createObject(path + ".DefinedClasses");
        String vcpath = this.createObject(path + ".VisibleClasses");
        this.insertObject(dcpath);
        this.insertObject(vcpath);
    }

    public void putClassObjectReference(String ppath, ClassObjectReference ref) {
        String path = this.createObject(ref, ref.toString(), ppath);
        this.putClassObjectReferenceDetails(path, ref);
        this.insertObject(path);
    }

    public void putClassObjectReferenceDetails(String path, ClassObjectReference ref) {
        this.putObjectReferenceDetails(path, ref);
        String rtpath = this.createObject(path + ".ReflectedType");
        this.insertObject(rtpath);
    }

    public void putModuleReferenceContainer() {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        String ppath = this.getPath(vm) + ".ModuleRefs";
        HashSet<String> keys = new HashSet<String>();
        try {
            List<ModuleReference> modules = vm.allModules();
            for (ModuleReference ref : modules) {
                keys.add(this.connector.key(ref.name()));
                String mpath = this.createObject(ref, ref.name(), ppath);
                this.insertObject(mpath);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.retainKeys(ppath, keys);
    }

    public void putModuleReference(String ppath, ModuleReference ref) {
        String path = this.createObject(ref, ref.name(), ppath);
        this.putModuleReferenceDetails(path, ref);
        this.insertObject(path);
    }

    public void putModuleReferenceDetails(String path, ModuleReference ref) {
        this.putObjectReferenceDetails(path, ref);
        String clpath = this.createObject(path + ".ClassLoader");
        this.insertObject(clpath);
    }

    public void putStringReference(String ppath, StringReference ref) {
        String path = this.createObject(ref, ref.toString(), ppath);
        this.putStringReferenceDetails(path, ref);
        this.insertObject(path);
    }

    public void putStringReferenceDetails(String path, StringReference ref) {
        this.putObjectReferenceDetails(path, ref);
        this.setValue(path, "Value", ref.value());
    }

    public void putThreadGroupContainer(String refpath, List<ThreadGroupReference> refs) {
        String ppath = refpath + ".ThreadGroups";
        HashSet<String> keys = new HashSet<String>();
        for (ThreadGroupReference subref : refs) {
            keys.add(this.connector.key(subref.name()));
            this.putThreadGroupReference(ppath, subref);
        }
        this.retainKeys(ppath, keys);
    }

    public void putThreadGroupReference(String ppath, ThreadGroupReference ref) {
        String path = this.createObject(ref, ref.name(), ppath);
        this.putThreadGroupReferenceDetails(path, ref);
        this.insertObject(path);
    }

    public void putThreadGroupReferenceDetails(String path, ThreadGroupReference ref) {
        this.putObjectReferenceDetails(path, ref);
        if (ref.parent() != null) {
            String ppath = this.createObject(path + ".Parent");
            this.insertObject(ppath);
        }
        String tgpath = this.createObject(path + ".ThreadGroups");
        String tpath = this.createObject(path + ".Threads");
        this.insertObject(tgpath);
        this.insertObject(tpath);
    }

    public void putThreadContainer(String refpath, List<ThreadReference> refs, boolean asLink) {
        String ppath = refpath + ".Threads";
        HashSet<String> keys = new HashSet<String>();
        for (ThreadReference subref : refs) {
            keys.add(this.connector.key(subref.name()));
            if (asLink) {
                this.createLink(ppath, subref.name(), subref);
                continue;
            }
            this.putThreadReference(ppath, subref);
        }
        this.retainKeys(ppath, keys);
    }

    public void putThreadReference(String ppath, ThreadReference ref) {
        String path = this.createObject(ref, ref.name(), ppath);
        this.putThreadReferenceDetails(path, ref);
        this.insertObject(path);
    }

    public void putThreadReferenceDetails(String path, ThreadReference ref) {
        this.putObjectReferenceDetails(path, ref);
        String spath = this.createObject(path + ".Stack");
        String rpath = this.createObject(path + ".Relations");
        String ccpath = this.createObject(rpath + ".CurrentContendedMonitor");
        String ompath = this.createObject(rpath + ".OwnedMonitors");
        String omfpath = this.createObject(rpath + ".OwnedMonitorsAndFrames");
        String tgpath = this.createObject(rpath + ".ThreadGroup");
        this.putThreadAttributes(ref, path);
        this.insertObject(spath);
        this.insertObject(ccpath);
        this.insertObject(ompath);
        this.insertObject(omfpath);
        this.insertObject(tgpath);
    }

    void putThreadAttributes(ThreadReference thread, String ppath) {
        String path = this.createObject(ppath + ".Attributes");
        this.setValue(path, "Status", thread.status());
        this.setValue(path, "isAtBreakpoint", thread.isAtBreakpoint());
        this.setValue(path, "isCollected", thread.isCollected());
        this.setValue(path, "isSuspended", thread.isSuspended());
        this.setValue(path, "isVirtual", thread.isVirtual());
        try {
            this.setValue(path, "entryCount", thread.entryCount());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        try {
            this.setValue(path, "frameCount", thread.frameCount());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        this.setValue(path, "suspendCount", thread.suspendCount());
        this.insertObject(path);
    }

    public void putMonitorInfoContainer(String path, List<MonitorInfo> info) {
        for (MonitorInfo f : info) {
            String ipath = this.createObject(f, f.toString(), path);
            this.insertObject(ipath);
        }
    }

    public void putMonitorInfoDetails(String path, MonitorInfo info) {
        this.setValue(path, "StackDepth", info.stackDepth());
        String mpath = this.createObject(path + ".Monitor");
        String tpath = this.createObject(path + ".Thread");
        this.insertObject(mpath);
        this.insertObject(tpath);
    }

    public void putFieldContainer(String path, ReferenceType reftype) {
        boolean scope = this.connector.getScope(reftype);
        List<Field> fields = scope ? reftype.allFields() : reftype.fields();
        HashSet<String> keys = new HashSet<String>();
        for (Field f : fields) {
            Value value = null;
            try {
                value = reftype.getValue(f);
                if (value != null) {
                    keys.add(this.connector.key(value.toString()));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            keys.add(this.connector.key(f.name()));
            this.putField(path, f, value);
        }
        this.retainKeys(path, keys);
    }

    public void putVariableContainer(String path, ObjectReference ref) {
        boolean scope = this.connector.getScope(ref);
        List<Field> fields = scope ? ref.referenceType().allFields() : ref.referenceType().fields();
        HashSet<String> keys = new HashSet<String>();
        for (Field f : fields) {
            Value value = null;
            try {
                value = ref.getValue(f);
                keys.add(this.connector.key(value.toString()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            keys.add(this.connector.key(f.name()));
            this.putField(path, f, value);
        }
        this.retainKeys(path, keys);
    }

    public void putField(String ppath, Field f, Value value) {
        String path = this.createObject(f, f.name(), ppath);
        this.putFieldDetails(path, f);
        if (value != null) {
            this.putValue(path, "Value", value);
            this.setValue(path, "_display", f.name() + " (" + f.typeName() + ") : " + String.valueOf(value));
        } else {
            this.setValue(path, "_display", f.name() + " (" + f.typeName() + ")");
        }
        this.insertObject(path);
    }

    public void putFieldDetails(String path, Field f) {
        this.setValue(path, "_module_name", f.declaringType().name());
        if (f.genericSignature() != null) {
            this.setValue(path, "GenericSignature", f.genericSignature());
        }
        this.putFieldAttributes(path, f);
        try {
            this.putType(path, "Type", f.type());
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
    }

    private void putFieldAttributes(String ppath, Field f) {
        String path = this.createObject(ppath + ".Attributes");
        this.setValue(path, "Modifiers", Integer.toHexString(f.modifiers()));
        this.setValue(path, "Signature", f.signature());
        this.setValue(path, "isEnumConstant", f.isEnumConstant());
        this.setValue(path, "isFinal", f.isFinal());
        this.setValue(path, "isPackagePrivate", f.isPackagePrivate());
        this.setValue(path, "isPrivate", f.isPrivate());
        this.setValue(path, "isProtected", f.isProtected());
        this.setValue(path, "isPublic", f.isPublic());
        this.setValue(path, "isStatic", f.isStatic());
        this.setValue(path, "isSynthetic", f.isSynthetic());
        this.setValue(path, "isTransient", f.isTransient());
        this.setValue(path, "isVolatile", f.isVolatile());
        this.insertObject(path);
    }

    public void putMethodContainer(String path, ReferenceType reftype) {
        boolean scope = this.connector.getScope(reftype);
        HashSet<String> keys = new HashSet<String>();
        try {
            List<Method> methods = scope ? reftype.allMethods() : reftype.methods();
            for (Method m : methods) {
                keys.add(this.connector.key(m.name()));
                this.putMethod(path, m);
            }
        }
        catch (Exception e) {
            Msg.info((Object)this, (Object)e.getMessage());
        }
        this.retainKeys(path, keys);
    }

    public void putMethod(String ppath, Method m) {
        String path = this.createObject(m, m.name(), ppath);
        this.putMethodDetails(path, m, true);
        this.insertObject(path);
    }

    public void putMethodDetails(String path, Method m, boolean partial) {
        AddressRange range;
        ReferenceType declaringType = m.declaringType();
        this.setValue(path, "_module_name", declaringType.name());
        this.createLink(m, "DeclaringType", declaringType);
        if (!partial) {
            String apath = this.createObject(path + ".Arguments");
            if (m.genericSignature() != null) {
                this.setValue(path, "GenericSignature", m.genericSignature());
            }
            String lpath = this.createObject(path + ".Locations");
            this.setValue(path, "Modifiers", m.modifiers());
            this.setValue(path, "ReturnType", m.returnTypeName());
            this.setValue(path, "Signature", m.signature());
            String vpath = this.createObject(path + ".Variables");
            this.putMethodAttributes(path, m);
            this.insertObject(apath);
            this.insertObject(lpath);
            this.insertObject(vpath);
        }
        if (m.location() != null && !(range = this.connector.getAddressRange(m)).equals((Object)this.connector.defaultRange)) {
            this.setValue(path, "Range", range);
        }
        Object bytes = "";
        for (byte b : m.bytecodes()) {
            bytes = (String)bytes + Integer.toHexString(b & 0xFF);
        }
        this.setValue(path, "ByteCodes", bytes);
    }

    private void putMethodAttributes(String ppath, Method m) {
        String path = this.createObject(ppath + ".Attributes");
        this.setValue(path, "isAbstract", m.isAbstract());
        this.setValue(path, "isBridge", m.isBridge());
        this.setValue(path, "isConstructor", m.isConstructor());
        this.setValue(path, "isDefault", m.isDefault());
        this.setValue(path, "isFinal", m.isFinal());
        this.setValue(path, "isNative", m.isNative());
        this.setValue(path, "isObsolete", m.isObsolete());
        this.setValue(path, "isPackagePrivate", m.isPackagePrivate());
        this.setValue(path, "isPrivate", m.isPrivate());
        this.setValue(path, "isProtected", m.isProtected());
        this.setValue(path, "isPublic", m.isPublic());
        this.setValue(path, "isStatic", m.isStatic());
        this.setValue(path, "isStaticInitializer", m.isStaticInitializer());
        this.setValue(path, "isSynchronized", m.isSynchronized());
        this.setValue(path, "isSynthetic", m.isSynthetic());
        this.setValue(path, "isVarArgs", m.isVarArgs());
        this.insertObject(path);
    }

    public void putVMs() {
        try {
            HashSet<String> keys = new HashSet<String>();
            for (Map.Entry<String, VirtualMachine> entry : this.jdi.listVMs().get().entrySet()) {
                VirtualMachine vm = entry.getValue();
                keys.add(this.connector.key(vm.name()));
                this.putVM("VMs", vm);
            }
            this.retainKeys("VMs", keys);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    public void putVM(String ppath, VirtualMachine vm) {
        String path = this.createObject(vm, vm.name(), ppath);
        this.putVMDetails(path, vm);
        this.insertObject(path);
    }

    public void putVMDetails(String path, VirtualMachine vm) {
        String cpath = this.createObject(path + ".Classes");
        String mpath = this.createObject(path + ".Memory");
        String tgpath = this.createObject(path + ".ThreadGroups");
        String tpath = this.createObject(path + ".Threads");
        Event currentEvent = this.jdi.getCurrentEvent();
        String shortName = vm.name();
        if (shortName.contains(" ")) {
            shortName = vm.name().substring(0, vm.name().indexOf(" "));
        }
        String display = currentEvent == null ? shortName : shortName + " [" + String.valueOf(currentEvent) + "]";
        this.setValue(path, "_display", display);
        this.setValue(path, "_arch", vm.name());
        this.setValue(path, "_debugger", vm.description());
        this.setValue(path, "_os", vm.version());
        this.insertObject(cpath);
        this.insertObject(mpath);
        this.insertObject(tgpath);
        this.insertObject(tpath);
    }

    public void putProcesses() {
        Map<String, VirtualMachine> vms;
        try {
            vms = this.jdi.listVMs().get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        for (Map.Entry<String, VirtualMachine> entry : vms.entrySet()) {
            HashSet<String> keys = new HashSet<String>();
            VirtualMachine vm = entry.getValue();
            String path = this.getPath(vm);
            if (path == null) continue;
            String ppath = path + ".Processes";
            Process proc = vm.process();
            if (proc != null) {
                String key = Long.toString(proc.pid());
                keys.add(this.connector.key(key));
                this.putProcess(ppath, proc);
            }
            this.retainKeys(ppath, keys);
        }
    }

    public void putProcess(String ppath, Process proc) {
        String path = this.createObject(proc, Long.toString(proc.pid()), ppath);
        this.putProcessDetails(path, proc);
        this.insertObject(path);
    }

    public void putProcessDetails(String path, Process proc) {
        ProcessHandle.Info info = proc.info();
        Optional<String> optional = info.command();
        if (optional.isPresent()) {
            this.setValue(path, "Executable", optional.get());
        }
        if ((optional = info.commandLine()).isPresent()) {
            this.setValue(path, "CommandLine", optional.get());
        }
        this.setValue(path, "Alive", proc.isAlive());
    }

    public void putFrames() {
        ThreadReference thread = this.connector.getJdi().getCurrentThread();
        String ppath = this.createObject(this.getPath(thread) + ".Stack");
        HashSet<String> keys = new HashSet<String>();
        try {
            int frameCount = thread.frameCount();
            for (int i = 0; i < frameCount; ++i) {
                StackFrame frame = thread.frame(i);
                String key = Integer.toString(i);
                keys.add(this.connector.key(key));
                this.putFrame(ppath, frame, key);
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        this.retainKeys(ppath, keys);
        this.insertObject(ppath);
    }

    private void putFrame(String ppath, StackFrame frame, String key) {
        String path = this.createObject(frame, key, ppath);
        this.putFrameDetails(path, frame, key);
        this.insertObject(path);
    }

    private void putFrameDetails(String path, StackFrame frame, String key) {
        Location location = frame.location();
        this.setValue(path, "_display", "[" + key + "] " + String.valueOf(location) + ":" + location.method().name() + ":" + location.codeIndex());
        this.putLocation(path, "Location", location);
        Address addr = this.connector.getAddressFromLocation(location);
        this.setValue(path, "PC", addr);
        String rpath = this.createObject(path + ".Registers");
        this.putRegisters(frame, rpath);
        this.insertObject(rpath);
        String vpath = this.createObject(path + ".Variables");
        this.insertObject(vpath);
        try {
            String thpath = this.createObject(frame.thisObject(), "This", path);
            this.insertObject(thpath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putLocationContainer(String path, Method m) {
        try {
            for (Location loc : m.allLineLocations()) {
                String lpath = this.createObject(loc, loc.toString(), path);
                this.insertObject(lpath);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    public void putLocationContainer(String path, ReferenceType ref) {
        try {
            for (Location loc : ref.allLineLocations()) {
                String lpath = this.createObject(loc, loc.toString(), path);
                this.insertObject(lpath);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    public void putLocation(String ppath, String key, Location location) {
        String path = this.createObject(location, key, ppath);
        this.putLocationDetails(path, location);
        this.insertObject(path);
    }

    public void putLocationDetails(String path, Location location) {
        Address addr = this.connector.getAddressFromLocation(location);
        if (this.isLoaded(location)) {
            this.setValue(path, "_display", this.connector.key(location.toString()) + ": " + String.valueOf(addr));
            this.setValue(path, "Address", addr);
        }
        this.setValue(path, "Index", location.codeIndex());
        this.setValue(path, "LineNo", location.lineNumber());
        try {
            this.setValue(path, "Name", location.sourceName());
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        try {
            this.setValue(path, "Path", location.sourcePath());
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        Method method = location.method();
        RmiTraceObject methodObject = this.proxyObject(method);
        if (methodObject == null) {
            String ppath = this.getVmPath(method.virtualMachine()) + ".Classes";
            this.putReferenceType(ppath, method.declaringType(), true);
        }
        this.createLink(location, "Method", method);
        this.createLink(location, "DeclaringType", location.declaringType());
        try {
            this.createLink(location, "ModuleRef", location.declaringType().module());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private boolean isLoaded(Location location) {
        AddressRange range = this.connector.getAddressRange(location.method());
        return !range.equals((Object)this.connector.defaultRange);
    }

    public void putLocalVariableContainer(String path, Map<LocalVariable, Value> variables) {
        for (LocalVariable lv : variables.keySet()) {
            this.putLocalVariable(path, lv, variables.get(lv));
        }
    }

    public void putLocalVariableContainer(String path, List<LocalVariable> variables) {
        for (LocalVariable lv : variables) {
            this.putLocalVariable(path, lv, null);
        }
    }

    public void putLocalVariable(String ppath, LocalVariable lv, Value value) {
        String path = this.createObject(lv, lv.name(), ppath);
        this.putLocalVariableDetails(path, lv);
        if (value != null) {
            this.putValue(path, "Value", value);
            this.setValue(path, "_display", lv.name() + ": " + String.valueOf(value));
        }
        this.insertObject(path);
    }

    public void putLocalVariableDetails(String path, LocalVariable lv) {
        try {
            this.putType(path, "Type", lv.type());
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
        this.putLocalVariableAttributes(path, lv);
    }

    private void putLocalVariableAttributes(String ppath, LocalVariable lv) {
        String path = this.createObject(ppath + ".Attributes");
        this.setValue(path, "isArgument", lv.isArgument());
        if (lv.genericSignature() != null) {
            this.setValue(path, "GenericSignature", lv.genericSignature());
        }
        this.setValue(path, "Signature", lv.signature());
        this.insertObject(path);
    }

    public void putMethodTypeContainer(String ppath, Method m) {
        try {
            for (Type type : m.argumentTypes()) {
                String tpath = this.createObject(type, type.name(), ppath);
                this.insertObject(tpath);
            }
        }
        catch (ClassNotLoadedException e) {
            String epath = this.createObject(ppath + "Class Not Loaded");
            this.insertObject(epath);
        }
    }

    public void putBreakpoints() {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        EventRequestManager requestManager = vm.eventRequestManager();
        String ppath = this.getPath(vm) + ".Breakpoints";
        String path = this.createObject(ppath);
        HashSet<String> keys = new HashSet<String>();
        List<BreakpointRequest> brkReqs = requestManager.breakpointRequests();
        for (BreakpointRequest breakpointRequest : brkReqs) {
            String key = this.connector.key(breakpointRequest.toString());
            keys.add(key);
            this.putReqBreakpoint(ppath, breakpointRequest, key);
        }
        List<AccessWatchpointRequest> watchReqs = requestManager.accessWatchpointRequests();
        for (AccessWatchpointRequest req : watchReqs) {
            String key = this.connector.key(req.toString());
            keys.add(key);
            this.putReqAccessWatchpoint(ppath, req, key);
        }
        List<ModificationWatchpointRequest> list = requestManager.modificationWatchpointRequests();
        for (ModificationWatchpointRequest req : list) {
            String key = this.connector.key(req.toString());
            keys.add(key);
            this.putReqModificationWatchpoint(ppath, req, key);
        }
        this.retainKeys(ppath, keys);
        this.insertObject(path);
    }

    public void putEvents() {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        EventRequestManager requestManager = vm.eventRequestManager();
        String ppath = this.getPath(vm) + ".Events";
        String path = this.createObject(ppath);
        HashSet<String> keys = new HashSet<String>();
        List<VMDeathRequest> deathReqs = requestManager.vmDeathRequests();
        for (VMDeathRequest vMDeathRequest : deathReqs) {
            keys.add(this.connector.key(vMDeathRequest.toString()));
            this.putReqVMDeath(ppath, vMDeathRequest, vMDeathRequest.toString());
        }
        List<ThreadStartRequest> threadStartReqs = requestManager.threadStartRequests();
        for (ThreadStartRequest threadStartRequest : threadStartReqs) {
            keys.add(this.connector.key(threadStartRequest.toString()));
            this.putReqThreadStarted(ppath, threadStartRequest, threadStartRequest.toString());
        }
        List<ThreadDeathRequest> list = requestManager.threadDeathRequests();
        for (ThreadDeathRequest threadDeathRequest : list) {
            keys.add(this.connector.key(threadDeathRequest.toString()));
            this.putReqThreadExited(ppath, threadDeathRequest, threadDeathRequest.toString());
        }
        List<ExceptionRequest> list2 = requestManager.exceptionRequests();
        for (ExceptionRequest exceptionRequest : list2) {
            keys.add(this.connector.key(exceptionRequest.toString()));
            this.putReqException(ppath, exceptionRequest, exceptionRequest.toString());
        }
        List<ClassPrepareRequest> list3 = requestManager.classPrepareRequests();
        for (ClassPrepareRequest classPrepareRequest : list3) {
            keys.add(this.connector.key(classPrepareRequest.toString()));
            this.putReqClassLoad(ppath, classPrepareRequest, classPrepareRequest.toString());
        }
        List<ClassUnloadRequest> list4 = requestManager.classUnloadRequests();
        for (ClassUnloadRequest classUnloadRequest : list4) {
            keys.add(this.connector.key(classUnloadRequest.toString()));
            this.putReqClassUnload(ppath, classUnloadRequest, classUnloadRequest.toString());
        }
        List<MethodEntryRequest> list5 = requestManager.methodEntryRequests();
        for (MethodEntryRequest methodEntryRequest : list5) {
            keys.add(this.connector.key(methodEntryRequest.toString()));
            this.putReqMethodEntry(ppath, methodEntryRequest, methodEntryRequest.toString());
        }
        List<MethodExitRequest> list6 = requestManager.methodExitRequests();
        for (MethodExitRequest methodExitRequest : list6) {
            keys.add(this.connector.key(methodExitRequest.toString()));
            this.putReqMethodExit(ppath, methodExitRequest, methodExitRequest.toString());
        }
        List<StepRequest> list7 = requestManager.stepRequests();
        for (StepRequest stepRequest : list7) {
            keys.add(this.connector.key(stepRequest.toString()));
            this.putReqStep(ppath, stepRequest, stepRequest.toString());
        }
        List<MonitorContendedEnterRequest> list8 = requestManager.monitorContendedEnterRequests();
        for (MonitorContendedEnterRequest monitorContendedEnterRequest : list8) {
            keys.add(this.connector.key(monitorContendedEnterRequest.toString()));
            this.putReqMonContendedEnter(ppath, monitorContendedEnterRequest, monitorContendedEnterRequest.toString());
        }
        List<MonitorContendedEnteredRequest> list9 = requestManager.monitorContendedEnteredRequests();
        for (MonitorContendedEnteredRequest monitorContendedEnteredRequest : list9) {
            keys.add(this.connector.key(monitorContendedEnteredRequest.toString()));
            this.putReqMonContendedEntered(ppath, monitorContendedEnteredRequest, monitorContendedEnteredRequest.toString());
        }
        List<MonitorWaitRequest> list10 = requestManager.monitorWaitRequests();
        for (MonitorWaitRequest req : list10) {
            keys.add(this.connector.key(req.toString()));
            this.putReqMonWait(ppath, req, req.toString());
        }
        List<MonitorWaitedRequest> list11 = requestManager.monitorWaitedRequests();
        for (MonitorWaitedRequest req : list11) {
            keys.add(this.connector.key(req.toString()));
            this.putReqMonWaited(ppath, req, req.toString());
        }
        this.retainKeys(ppath, keys);
        this.insertObject(path);
    }

    private void putReqVMDeath(String ppath, VMDeathRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqVMDeathDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqVMDeathDetails(String path, VMDeathRequest req, String key) {
        this.putFilterDetails(path, req);
    }

    private void putReqThreadStarted(String ppath, ThreadStartRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqThreadStartedDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqThreadStartedDetails(String path, ThreadStartRequest req, String key) {
        this.putFilterDetails(path, req);
    }

    private void putReqThreadExited(String ppath, ThreadDeathRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqThreadExitedDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqThreadExitedDetails(String path, ThreadDeathRequest req, String key) {
        this.putFilterDetails(path, req);
    }

    private void putReqBreakpoint(String ppath, BreakpointRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqBreakpointDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqBreakpointDetails(String path, BreakpointRequest req, String key) {
        Location location = req.location();
        this.setValue(path, "_display", "[" + key + "] " + String.valueOf(location) + ":" + location.method().name() + ":" + location.codeIndex());
        Address addr = this.connector.getAddressFromLocation(location);
        AddressRangeImpl range = new AddressRangeImpl(addr, addr);
        this.setValue(path, "Range", range);
        String lpath = this.createObject(location, location.toString(), path + ".Location");
        this.insertObject(lpath);
        this.setValue(path, "Enabled", req.isEnabled());
        this.putFilterDetails(path, req);
    }

    private void putReqAccessWatchpoint(String ppath, AccessWatchpointRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqAccessWatchpointDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqAccessWatchpointDetails(String path, AccessWatchpointRequest req, String key) {
        Field field = req.field();
        this.setValue(path, "_display", "[" + key + "] " + String.valueOf(field) + ":" + String.valueOf(field.declaringType()));
        AddressRange range = this.connector.getPoolAddressRange(field.declaringType(), this.getSize(field.declaringType()));
        this.setValue(path, "Range", range);
        String fpath = this.createObject(field, field.toString(), path + ".Field");
        this.insertObject(fpath);
        this.setValue(path, "Enabled", req.isEnabled());
        this.putFilterDetails(path, req);
    }

    private void putReqModificationWatchpoint(String ppath, ModificationWatchpointRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqModificationWatchpointDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqModificationWatchpointDetails(String path, ModificationWatchpointRequest req, String key) {
        Field field = req.field();
        this.setValue(path, "_display", "[" + key + "] " + String.valueOf(field) + ":" + String.valueOf(field.declaringType()));
        AddressRange range = this.connector.getPoolAddressRange(field.declaringType(), this.getSize(field.declaringType()));
        this.setValue(path, "Range", range);
        String fpath = this.createObject(field, field.toString(), path + ".Field");
        this.insertObject(fpath);
        this.setValue(path, "Enabled", req.isEnabled());
        this.putFilterDetails(path, req);
    }

    private void putReqException(String ppath, ExceptionRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqExceptionDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqExceptionDetails(String path, ExceptionRequest req, String key) {
        this.setValue(path, "Enabled", req.isEnabled());
    }

    private void putReqClassLoad(String ppath, ClassPrepareRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqClassLoadDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqClassLoadDetails(String path, ClassPrepareRequest req, String key) {
        this.setValue(path, "Enabled", req.isEnabled());
        this.putFilterDetails(path, req);
    }

    private void putReqClassUnload(String ppath, ClassUnloadRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqClassUnloadDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqClassUnloadDetails(String path, ClassUnloadRequest req, String key) {
        this.setValue(path, "Enabled", req.isEnabled());
        this.putFilterDetails(path, req);
    }

    private void putReqMethodEntry(String ppath, MethodEntryRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqMethodEntryDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqMethodEntryDetails(String path, MethodEntryRequest req, String key) {
        this.setValue(path, "Enabled", req.isEnabled());
        this.putFilterDetails(path, req);
    }

    private void putReqMethodExit(String ppath, MethodExitRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqMethodExitDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqMethodExitDetails(String path, MethodExitRequest req, String key) {
        this.setValue(path, "Enabled", req.isEnabled());
        this.putFilterDetails(path, req);
    }

    private void putReqStep(String ppath, StepRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqStepRequestDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqStepRequestDetails(String path, StepRequest req, String key) {
        this.setValue(path, "Enabled", req.isEnabled());
        this.putFilterDetails(path, req);
    }

    private void putReqMonContendedEnter(String ppath, MonitorContendedEnterRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqMonContendedEnterDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqMonContendedEnterDetails(String path, MonitorContendedEnterRequest req, String key) {
        this.putFilterDetails(path, req);
    }

    private void putReqMonContendedEntered(String ppath, MonitorContendedEnteredRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqMonContendedEnteredDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqMonContendedEnteredDetails(String path, MonitorContendedEnteredRequest req, String key) {
        this.putFilterDetails(path, req);
    }

    private void putReqMonWait(String ppath, MonitorWaitRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqMonWaitDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqMonWaitDetails(String path, MonitorWaitRequest req, String key) {
        this.putFilterDetails(path, req);
    }

    private void putReqMonWaited(String ppath, MonitorWaitedRequest req, String key) {
        String path = this.createObject(req, key, ppath);
        this.putReqMonWaitedDetails(path, req, key);
        this.insertObject(path);
    }

    private void putReqMonWaitedDetails(String path, MonitorWaitedRequest req, String key) {
        this.putFilterDetails(path, req);
    }

    private void putFilterDetails(String path, EventRequest req) {
        ObjectReference ref;
        Object property = req.getProperty("Class");
        if (property != null && property instanceof ReferenceType) {
            ReferenceType reftype = (ReferenceType)property;
            this.setValue(path, "Class", reftype.name());
        }
        if ((property = req.getProperty("Instance")) != null && property instanceof ObjectReference) {
            ref = (ObjectReference)property;
            this.setValue(path, "Instance", ref.toString());
        }
        if ((property = req.getProperty("Thread")) != null && property instanceof ThreadReference) {
            ref = (ThreadReference)property;
            this.setValue(path, "Thread", ref.name());
        }
    }

    public void ghidraTracePutModules() {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutModules", false);){
            this.putModuleReferenceContainer();
        }
    }

    public void ghidraTracePutClasses() {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutClasses", false);){
            VirtualMachine vm = this.connector.getJdi().getCurrentVM();
            this.putReferenceTypeContainer(this.getPath(vm) + ".Classes", vm.allClasses());
        }
    }

    public void ghidraTracePutThreads() {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutThreads", false);){
            VirtualMachine vm = this.connector.getJdi().getCurrentVM();
            this.putThreadContainer(this.getPath(vm), vm.allThreads(), false);
            this.putThreadGroupContainer(this.getPath(vm), vm.topLevelThreadGroups());
        }
    }

    public void ghidraTracePutFrames() {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutFrames", false);){
            this.putFrames();
        }
    }

    public void ghidraTracePutAll() {
        this.state.requireTrace();
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTracePutAll", false);){
            this.putVMs();
            VirtualMachine vm = this.connector.getJdi().getCurrentVM();
            this.putProcesses();
            this.putThreadContainer(this.getPath(vm), vm.allThreads(), false);
            this.putThreadGroupContainer(this.getPath(vm), vm.topLevelThreadGroups());
            this.putFrames();
            this.putBreakpoints();
            this.putEvents();
            this.putReferenceTypeContainer(this.getPath(vm) + ".Classes", vm.allClasses());
        }
    }

    public void ghidraTraceInstallHooks() {
        this.connector.getHooks().installHooks();
    }

    public void ghidraTraceRemoveHooks() {
        this.connector.getHooks().removeHooks();
    }

    public void ghidraTraceSyncEnable() {
        try (RmiTransaction tx = this.state.trace.startTx("ghidraTraceSyncEnable", false);){
            JdiHooks hooks = this.connector.getHooks();
            hooks.installHooks();
            hooks.enableCurrentVM();
        }
    }

    public void ghidraTraceSyncDisable() {
        this.connector.getHooks().disableCurrentVM();
    }

    public void ghidraTraceSyncSynthStopped() {
        this.connector.getHooks().onStop(null, this.state.trace);
    }

    public void ghidraTraceWaitStopped(int timeout) {
        ThreadReference currentThread = this.connector.getJdi().getCurrentThread();
        if (currentThread == null) {
            return;
        }
        long start = System.currentTimeMillis();
        while (!currentThread.isSuspended()) {
            currentThread = this.connector.getJdi().getCurrentThread();
            try {
                Thread.sleep(100L);
                long elapsed = System.currentTimeMillis() - start;
                if (elapsed <= (long)timeout) continue;
                throw new RuntimeException("Timed out waiting for thread to stop");
            }
            catch (InterruptedException e) {
                Msg.error((Object)this, (Object)"Wait interrupted");
            }
        }
    }

    public void execute(ClassType ct, ThreadReference thread, Method method, List<Value> args, int options) {
        try {
            Value val = ct.invokeMethod(thread, method, args, options);
            System.err.println(val);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void execute(ObjectReference ref, ThreadReference thread, Method method, List<Value> args, int options) {
        try {
            Value val = ref.invokeMethod(thread, method, args, options);
            System.out.println(val);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private int getSize(ReferenceType reftype) {
        byte[] cp = reftype.constantPool();
        int sz = 1;
        if (cp != null && cp.length > 0) {
            sz = cp.length;
        }
        return sz;
    }

    public void setValue(String path, String key, Object value) {
        this.state.trace.setValue(path, key, value);
    }

    String getPath(Object obj) {
        return this.connector.pathForObj(obj);
    }

    public RmiTraceObject proxyObject(Object obj) {
        String path = this.getPath(obj);
        return path == null ? null : RmiTraceObject.fromPath((RmiTrace)this.state.trace, (String)path);
    }

    private String createObject(String path) {
        this.state.trace.createObject(path);
        return path;
    }

    private String createObject(Object obj, String key, String ppath) {
        if (obj == null) {
            return null;
        }
        String path = this.connector.recordPath(obj, ppath, key);
        this.state.trace.createObject(path);
        return path;
    }

    private String insertObject(String path) {
        this.state.trace.insertObject(path);
        return path;
    }

    private void retainKeys(String ppath, Set<String> keys) {
        this.state.trace.retainValues(ppath, keys, TraceRmi.ValueKinds.VK_ELEMENTS);
    }

    public void createLink(Object parent, String label, Object child) {
        String ppath = parent instanceof String ? (String)parent : this.getPath(parent);
        RmiTraceObject proxy = this.proxyObject(child);
        if (proxy != null) {
            this.setValue(ppath, label, proxy);
        } else {
            String key = child.toString();
            if (child instanceof Method) {
                Method m = (Method)child;
                key = m.name();
            }
            String lpath = this.createObject(child, key, ppath + "." + label);
            this.insertObject(lpath);
        }
    }

    public String getVmPath(VirtualMachine vm) {
        return this.connector.recordPath(vm, "VMs", vm.name());
    }

    public String getParentPath(String path) {
        String ppath = path.substring(0, path.lastIndexOf("."));
        if (ppath.endsWith(".Relations")) {
            return this.getParentPath(ppath);
        }
        return ppath;
    }

    public boolean setStatus(Object obj, boolean stopped) {
        String path = this.getPath(obj);
        if (obj == null || path == null) {
            return stopped;
        }
        boolean suspended = stopped;
        String name = obj.toString();
        if (obj instanceof ThreadReference) {
            ThreadReference thread = (ThreadReference)obj;
            suspended = thread.isSuspended();
            name = thread.name();
        }
        if (obj instanceof VirtualMachine) {
            VirtualMachine vm = (VirtualMachine)obj;
            Event currentEvent = this.jdi.getCurrentEvent();
            String shortName = vm.name();
            if (shortName.contains(" ")) {
                shortName = vm.name().substring(0, vm.name().indexOf(" "));
            }
            name = currentEvent == null ? shortName : shortName + " [" + String.valueOf(currentEvent) + "]";
        }
        this.setValue(path, "_accessible", suspended);
        String annotation = suspended ? "(S)" : "(R)";
        this.setValue(path, "_display", name + " " + annotation);
        String tstate = suspended ? "STOPPED" : "RUNNING";
        this.setValue(path, "_state", tstate);
        return stopped |= suspended;
    }

    public static class Tabulator {
        private final PrintStream out;
        private final List<Column> columns;

        public Tabulator(PrintStream out, int colCount) {
            this.out = out;
            this.columns = IntStream.range(0, colCount).mapToObj(i -> new Column()).toList();
        }

        public void measure(Object ... row) {
            if (row.length != this.columns.size()) {
                throw new IllegalArgumentException("Column count mismatch");
            }
            for (int i = 0; i < row.length; ++i) {
                this.columns.get(i).measure(row[i].toString());
            }
        }

        public void print(Object ... row) {
            if (row.length != this.columns.size()) {
                throw new IllegalArgumentException("Column count mismatch");
            }
            for (int i = 0; i < row.length; ++i) {
                if (i != 0) {
                    this.out.print(" ");
                }
                this.columns.get(i).print(this.out, row[i].toString());
            }
            this.out.println();
        }

        static class Column {
            int width;

            Column() {
            }

            public void measure(String string) {
                this.width = Math.max(this.width, string.length());
            }

            public void print(PrintStream out, String string) {
                out.print(this.pad(string));
            }

            private String pad(String string) {
                return StringUtils.rightPad((String)string, (int)this.width);
            }
        }
    }
}

