/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.AbstractHierarchicalMinCrossLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.Layered;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerRunnable;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Layering;
import org.jungrapht.visualization.layout.algorithms.util.AfterRunnable;
import org.jungrapht.visualization.layout.algorithms.util.ExecutorConsumer;
import org.jungrapht.visualization.layout.algorithms.util.LayeredRunnable;
import org.jungrapht.visualization.layout.algorithms.util.Threaded;
import org.jungrapht.visualization.layout.algorithms.util.VertexBoundsFunctionConsumer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EiglspergerLayoutAlgorithm<V, E>
extends AbstractHierarchicalMinCrossLayoutAlgorithm<V, E>
implements LayoutAlgorithm<V>,
VertexBoundsFunctionConsumer<V>,
Layered<V, E>,
AfterRunnable,
Threaded,
ExecutorConsumer {
    private static final Logger log = LoggerFactory.getLogger(EiglspergerLayoutAlgorithm.class);

    public static <V, E> Builder<V, E, ?, ?> edgeAwareBuilder() {
        return new Builder();
    }

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public EiglspergerLayoutAlgorithm() {
        this(EiglspergerLayoutAlgorithm.edgeAwareBuilder());
    }

    protected EiglspergerLayoutAlgorithm(Builder<V, E, ?, ?> builder) {
        this(builder.vertexBoundsFunction, builder.straightenEdges, builder.postStraighten, builder.transpose, builder.maxLevelCross, builder.maxLevelCrossFunction, builder.expandLayout, builder.layering, builder.edgeComparator, builder.threaded, builder.executor, builder.separateComponents, builder.favoredEdgePredicate, builder.after);
    }

    protected EiglspergerLayoutAlgorithm(Function<V, Rectangle> vertexShapeFunction, boolean straightenEdges, boolean postStraighten, boolean transpose, int maxLevelCross, Function<Graph<V, E>, Integer> maxLevelCrossFunction, boolean expandLayout, Layering layering, Comparator<E> edgeComparator, boolean threaded, Executor executor, boolean separateComponents, Predicate<E> favoredEdgePredicate, Runnable after) {
        super(vertexShapeFunction, straightenEdges, postStraighten, transpose, maxLevelCross, maxLevelCrossFunction, expandLayout, layering, edgeComparator, threaded, executor, separateComponents, favoredEdgePredicate, after);
    }

    @Override
    protected LayeredRunnable<E> getRunnable(int componentCount, LayoutModel<V> componentLayoutModel) {
        return ((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)EiglspergerRunnable.builder().layoutModel(componentLayoutModel)).vertexShapeFunction(this.vertexBoundsFunction)).straightenEdges(this.straightenEdges)).postStraighten(this.postStraighten)).transpose(this.transpose)).maxLevelCross((Integer)this.maxLevelCrossFunction.apply(this.layoutModel.getGraph()))).layering(this.layering)).edgeComparator(this.edgeComparator)).favoredEdgePredicate(this.favoredEdgePredicate)).multiComponent(componentCount > 1)).build();
    }

    public static class Builder<V, E, T extends EiglspergerLayoutAlgorithm<V, E>, B extends Builder<V, E, T, B>>
    extends AbstractHierarchicalMinCrossLayoutAlgorithm.Builder<V, E, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        @Override
        public T build() {
            return (T)new EiglspergerLayoutAlgorithm(this);
        }
    }
}

