/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.repulsion.BarnesHutSpringRepulsion;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardSpringRepulsion;
import org.jungrapht.visualization.layout.algorithms.util.IterativeContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.util.RandomLocationTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringLayoutAlgorithm<V, E>
extends AbstractIterativeLayoutAlgorithm<V>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(SpringLayoutAlgorithm.class);
    protected double stretch = 0.7;
    protected Function<E, Integer> lengthFunction;
    protected int repulsion_range_sq = 10000;
    protected double force_multiplier = 0.3333333333333333;
    boolean done = false;
    final Object lock = new Object();
    protected Map<V, SpringVertexData> springVertexData = new ConcurrentHashMap<V, SpringVertexData>();
    protected StandardSpringRepulsion.Builder repulsionContractBuilder;
    protected StandardSpringRepulsion repulsionContract;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public SpringLayoutAlgorithm() {
        this(SpringLayoutAlgorithm.builder());
    }

    protected SpringLayoutAlgorithm(Builder<V, E, ?, ?> builder) {
        super(builder);
        this.lengthFunction = builder.lengthFunction;
        this.repulsionContractBuilder = builder.repulsionContractBuilder;
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        super.visit(layoutModel);
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return;
        }
        this.repulsionContract = ((StandardSpringRepulsion.Builder)((StandardSpringRepulsion.Builder)((StandardSpringRepulsion.Builder)this.repulsionContractBuilder.nodeData(this.springVertexData)).layoutModel((LayoutModel)layoutModel)).random(this.random)).build();
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setStretch(double stretch) {
        this.stretch = stretch;
    }

    public int getRepulsionRange() {
        return (int)Math.sqrt(this.repulsion_range_sq);
    }

    public void setRepulsionRange(int range) {
        this.repulsion_range_sq = range * range;
    }

    public double getForceMultiplier() {
        return this.force_multiplier;
    }

    public void setForceMultiplier(double force) {
        this.force_multiplier = force;
    }

    public void initialize() {
        Graph graph = this.layoutModel.getGraph();
        this.layoutModel.setInitializer(new RandomLocationTransformer(this.layoutModel.getWidth(), (double)this.layoutModel.getHeight(), graph.vertexSet().size()));
    }

    @Override
    public void step() {
        this.repulsionContract.step();
        Graph graph = this.layoutModel.getGraph();
        try {
            for (Object vertex : graph.vertexSet()) {
                SpringVertexData svd = this.springVertexData.computeIfAbsent((SpringVertexData)vertex, (Function<SpringVertexData, SpringVertexData>)((Function<Object, SpringVertexData>)v -> new SpringVertexData()));
                svd.dx /= 4.0;
                svd.dy /= 4.0;
                svd.edgedy = 0.0;
                svd.edgedx = 0.0;
                svd.repulsiondy = 0.0;
                svd.repulsiondx = 0.0;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.step();
        }
        this.relaxEdges();
        this.repulsionContract.calculateRepulsion();
        this.moveVertices();
    }

    protected void relaxEdges() {
        Graph graph = this.layoutModel.getGraph();
        try {
            for (Object edge : graph.edgeSet()) {
                Object vertex1 = graph.getEdgeSource(edge);
                Object vertex2 = graph.getEdgeTarget(edge);
                Point p1 = this.layoutModel.get(vertex1);
                Point p2 = this.layoutModel.get(vertex2);
                if (p1 == null || p2 == null) continue;
                double vx = p1.x - p2.x;
                double vy = p1.y - p2.y;
                double len = Math.sqrt(vx * vx + vy * vy);
                double desiredLen = this.lengthFunction.apply(edge).intValue();
                len = len == 0.0 ? 1.0E-4 : len;
                double f = this.force_multiplier * (desiredLen - len) / len;
                double dx = (f *= Math.pow(this.stretch, graph.degreeOf(vertex1) + graph.degreeOf(vertex2) - 2)) * vx;
                double dy = f * vy;
                SpringVertexData v1D = this.springVertexData.computeIfAbsent((SpringVertexData)vertex1, (Function<SpringVertexData, SpringVertexData>)((Function<Object, SpringVertexData>)v -> new SpringVertexData()));
                SpringVertexData v2D = this.springVertexData.computeIfAbsent((SpringVertexData)vertex2, (Function<SpringVertexData, SpringVertexData>)((Function<Object, SpringVertexData>)v -> new SpringVertexData()));
                v1D.edgedx += dx;
                v1D.edgedy += dy;
                v2D.edgedx += -dx;
                v2D.edgedy += -dy;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.relaxEdges();
        }
    }

    public String toString() {
        return "SpringLayoutAlgorithm{repulsionContract=" + this.repulsionContract + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveVertices() {
        Graph graph = this.layoutModel.getGraph();
        Object object = this.lock;
        synchronized (object) {
            try {
                for (Object vertex : graph.vertexSet()) {
                    if (this.layoutModel.isLocked(vertex)) continue;
                    if (this.cancelled) {
                        return;
                    }
                    SpringVertexData vd = this.springVertexData.computeIfAbsent((SpringVertexData)vertex, (Function<SpringVertexData, SpringVertexData>)((Function<Object, SpringVertexData>)v -> new SpringVertexData()));
                    if (vd == null) continue;
                    Point xyd = (Point)this.layoutModel.apply(vertex);
                    double posX = xyd.x;
                    double posY = xyd.y;
                    vd.dx += vd.repulsiondx + vd.edgedx;
                    vd.dy += vd.repulsiondy + vd.edgedy;
                    posX += Math.max(-5.0, Math.min(5.0, vd.dx));
                    posY += Math.max(-5.0, Math.min(5.0, vd.dy));
                    int width = this.layoutModel.getWidth();
                    int height = this.layoutModel.getHeight();
                    posX = Math.max(0.0, Math.min((double)width, posX));
                    posY = Math.max(0.0, Math.min((double)height, posY));
                    this.layoutModel.set(vertex, posX, posY);
                }
            }
            catch (ConcurrentModificationException cme) {
                this.moveVertices();
            }
        }
    }

    @Override
    public boolean done() {
        if (this.cancelled) {
            return true;
        }
        if (this.done) {
            this.runAfter();
        }
        return this.done;
    }

    public static class Builder<V, E, T extends SpringLayoutAlgorithm<V, E>, B extends Builder<V, E, T, B>>
    extends AbstractIterativeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        private StandardSpringRepulsion.Builder repulsionContractBuilder = BarnesHutSpringRepulsion.builder();
        private Function<E, Integer> lengthFunction = n -> 30;

        public B repulsionContractBuilder(StandardSpringRepulsion.Builder repulsionContractBuilder) {
            this.repulsionContractBuilder = repulsionContractBuilder;
            return (B)((Builder)this.self());
        }

        public B withLengthFunction(Function<E, Integer> lengthFunction) {
            this.lengthFunction = lengthFunction;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new SpringLayoutAlgorithm(this);
        }
    }

    public static class SpringVertexData {
        protected double edgedx;
        protected double edgedy;
        public double repulsiondx;
        public double repulsiondy;
        protected double dx;
        protected double dy;

        public String toString() {
            return "{edge=" + Point.of(this.edgedx, this.edgedy) + ", rep=" + Point.of(this.repulsiondx, this.repulsiondy) + ", dx=" + this.dx + ", dy=" + this.dy + "}";
        }
    }
}

