/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.NeighborCache;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jgrapht.util.SupplierUtil;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.Container;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerSteps;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerUtil;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.PVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.QVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.Segment;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SegmentVertex;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EiglspergerStepsForward<V, E>
extends EiglspergerSteps<V, E> {
    private static final Logger log = LoggerFactory.getLogger(EiglspergerStepsForward.class);

    public EiglspergerStepsForward(Graph<LV<V>, LE<V, E>> svGraph, NeighborCache<LV<V>, LE<V, E>> neighborCache, LV<V>[][] layersArray, boolean transpose) {
        super(svGraph, layersArray, PVertex.class::isInstance, QVertex.class::isInstance, arg_0 -> svGraph.getEdgeSource(arg_0), arg_0 -> svGraph.getEdgeTarget(arg_0), arg_0 -> neighborCache.predecessorsOf(arg_0), e -> e, transpose);
    }

    public int sweep(LV<V>[][] layersArray) {
        this.compactionGraph = GraphTypeBuilder.directed().allowingMultipleEdges(true).edgeSupplier(SupplierUtil.createIntegerSupplier()).buildGraph();
        if (log.isTraceEnabled()) {
            log.trace(">>>>>>>>>>>>>>>>>>>>>>>>> Forward!>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        int crossCount = 0;
        List<LV<V>> layerEye = null;
        for (int i = 0; i < layersArray.length - 1; ++i) {
            if (layerEye == null) {
                layerEye = EiglspergerUtil.scan(EiglspergerUtil.createListOfVertices(layersArray[i]));
                LV<V> pred = null;
                for (LV<V> v : layerEye) {
                    if (v instanceof Container) {
                        Container container = (Container)v;
                        for (Segment segment : container.segments()) {
                            this.compactionGraph.addVertex(segment);
                            if (pred != null) {
                                this.compactionGraph.addEdge(pred, segment);
                            }
                            pred = segment;
                        }
                        continue;
                    }
                    if (v instanceof SegmentVertex) {
                        this.compactionGraph.addVertex(v);
                        if (pred != null) {
                            this.compactionGraph.addEdge(pred, v);
                        }
                        pred = v;
                        continue;
                    }
                    this.compactionGraph.addVertex(v);
                    if (pred != null) {
                        this.compactionGraph.addEdge(pred, v);
                    }
                    pred = v;
                }
            }
            this.stepOne(layerEye);
            if (log.isTraceEnabled()) {
                log.trace("stepOneOut:{}", layerEye);
            }
            List<LV<V>> currentLayer = layerEye;
            List<LV<V>> downstreamLayer = EiglspergerUtil.createListOfVertices(layersArray[i + 1]);
            this.stepTwo(currentLayer, downstreamLayer);
            if (log.isTraceEnabled()) {
                log.trace("stepTwoOut:{}", downstreamLayer);
            }
            this.stepThree(downstreamLayer);
            if (log.isTraceEnabled()) {
                log.trace("stepThreeOut:{}", downstreamLayer);
            }
            EiglspergerUtil.fixIndices(downstreamLayer);
            this.stepFour(downstreamLayer, i + 1);
            if (log.isTraceEnabled()) {
                log.trace("stepFourOut:{}", downstreamLayer);
            }
            if (this.transpose) {
                crossCount += this.stepFive(currentLayer, downstreamLayer, i, i + 1);
            }
            this.stepSix(downstreamLayer);
            LV<V> pred = null;
            for (LV<V> v : downstreamLayer) {
                if (v instanceof Container) {
                    Container container = (Container)v;
                    List segments = container.segments();
                    for (Segment segment : segments) {
                        this.compactionGraph.addVertex(segment);
                        if (pred != null) {
                            this.compactionGraph.addEdge(pred, segment);
                        }
                        pred = segment;
                    }
                    continue;
                }
                if (v instanceof SegmentVertex) {
                    SegmentVertex segmentVertex = (SegmentVertex)v;
                    Segment segment = segmentVertex.getSegment();
                    this.compactionGraph.addVertex(segment);
                    if (pred != null) {
                        this.compactionGraph.addEdge(pred, segment);
                    }
                    pred = segment;
                    continue;
                }
                this.compactionGraph.addVertex(v);
                if (pred != null) {
                    this.compactionGraph.addEdge(pred, v);
                }
                pred = v;
            }
            if (log.isTraceEnabled()) {
                log.trace("stepSixOut:{}", downstreamLayer);
            }
            Arrays.sort(layersArray[i], Comparator.comparingInt(LV::getIndex));
            EiglspergerUtil.fixIndices(layersArray[i]);
            Arrays.sort(layersArray[i + 1], Comparator.comparingInt(LV::getIndex));
            EiglspergerUtil.fixIndices(layersArray[i + 1]);
            layerEye = downstreamLayer;
        }
        log.debug("sweepForward crossCount:{}", (Object)crossCount);
        return crossCount;
    }
}

