/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.Container;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.PVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.QVertex;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EiglspergerUtil {
    private static final Logger log = LoggerFactory.getLogger(EiglspergerUtil.class);

    public static <V> List<LV<V>> createListOfVertices(LV<V>[] rank) {
        return Arrays.stream(rank).collect(Collectors.toList());
    }

    static <V> List<LV<V>> assignIndices(List<LV<V>> inList) {
        int i = 0;
        for (LV<V> v : inList) {
            if (v instanceof Container && ((Container)v).size() == 0) continue;
            v.setIndex(i++);
        }
        return inList;
    }

    static <V> List<LV<V>> scan(List<LV<V>> list) {
        ArrayList<LV<V>> outList = new ArrayList<LV<V>>();
        for (int i = 0; i < list.size(); ++i) {
            LV<V> v = list.get(i);
            if (outList.isEmpty()) {
                if (v instanceof Container) {
                    outList.add(v);
                    continue;
                }
                outList.add(Container.createSubContainer());
                outList.add(v);
                continue;
            }
            LV previous = (LV)outList.get(outList.size() - 1);
            if (previous instanceof Container && v instanceof Container) {
                if (log.isTraceEnabled()) {
                    log.trace("joining {} and {}", (Object)previous, v);
                }
                Container previousContainer = (Container)previous;
                Container thisContainer = (Container)v;
                previousContainer.join(thisContainer);
                if (!log.isTraceEnabled()) continue;
                log.trace("previous now joined as {}", (Object)previous);
                continue;
            }
            if (!(previous instanceof Container) && !(v instanceof Container)) {
                if (log.isTraceEnabled()) {
                    log.trace("added empty container between {} and {}", (Object)previous, v);
                }
                outList.add(Container.createSubContainer());
                outList.add(v);
                continue;
            }
            outList.add(v);
        }
        if (!outList.isEmpty() && !(outList.get(outList.size() - 1) instanceof Container)) {
            outList.add(Container.createSubContainer());
            if (log.isTraceEnabled()) {
                log.trace("appended empty container");
            }
        }
        return EiglspergerUtil.assignIndices(outList);
    }

    static <V> List<LV<V>> fixIndices(List<LV<V>> layer) {
        IntStream.range(0, layer.size()).forEach(i -> ((LV)layer.get(i)).setIndex(i));
        return layer;
    }

    static <V> LV<V>[] fixIndices(LV<V>[] layer) {
        IntStream.range(0, layer.length).forEach(i -> layer[i].setIndex(i));
        return layer;
    }

    public static <V> void check(LV<V>[][] layers) {
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].length; ++j) {
                LV<V> v = layers[i][j];
                if (v.getIndex() == j) continue;
                log.error("{} needs fix", v);
            }
        }
    }

    static double medianValue(int[] P) {
        int m = P.length / 2;
        if (P.length == 0) {
            return -1.0;
        }
        if (P.length % 2 == 1) {
            return P[m];
        }
        if (P.length == 2) {
            return (P[0] + P[1]) / 2;
        }
        double left = P[m - 1] - P[0];
        double right = P[P.length - 1] - P[m];
        return ((double)P[m - 1] * right + (double)P[m] * left) / (left + right);
    }

    static <V> LV<V> s(LV<V> v) {
        if (v instanceof PVertex) {
            PVertex pVertex = (PVertex)v;
            return pVertex.getSegment();
        }
        if (v instanceof QVertex) {
            QVertex qVertex = (QVertex)v;
            return qVertex.getSegment();
        }
        return v;
    }
}

