/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.model;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.IterativeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.algorithms.util.Threaded;
import org.jungrapht.visualization.layout.event.LayoutSizeChange;
import org.jungrapht.visualization.layout.event.LayoutStateChange;
import org.jungrapht.visualization.layout.event.LayoutVertexPositionChange;
import org.jungrapht.visualization.layout.event.ModelChange;
import org.jungrapht.visualization.layout.event.ViewChange;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.util.VisRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayoutModel<V>
implements LayoutModel<V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractLayoutModel.class);
    protected Set<V> lockedVertices = new HashSet<V>();
    protected boolean locked;
    protected int width;
    protected int height;
    protected int preferredWidth;
    protected int preferredHeight;
    protected boolean createVisRunnable;
    protected Graph<V, ?> graph;
    protected VisRunnable visRunnable = VisRunnable.noop();
    protected boolean relaxing;
    protected LayoutVertexPositionChange.Support layoutVertexPositionSupport = LayoutVertexPositionChange.Support.create();
    protected LayoutStateChange.Support layoutStateChangeSupport = LayoutStateChange.Support.create();
    protected ModelChange.Support modelChangeSupport = ModelChange.Support.create();
    protected ViewChange.Support viewChangeSupport = ViewChange.Support.create();
    protected LayoutSizeChange.Support layoutSizeChangeSupport = LayoutSizeChange.Support.create();
    protected int appendageCount;
    protected Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction;

    protected AbstractLayoutModel(Builder builder) {
        this.graph = Objects.requireNonNull(builder.graph);
        this.initialDimensionFunction = builder.initialDimensionFunction;
        this.setSize(builder.width, builder.height);
        this.setPreferredSize(builder.width, builder.height);
        this.createVisRunnable = builder.createVisRunnable;
    }

    protected AbstractLayoutModel(LayoutModel<V> other) {
        this.graph = other.getGraph();
        this.setSize(other.getWidth(), other.getHeight());
        this.setPreferredSize(other.getWidth(), other.getHeight());
    }

    protected AbstractLayoutModel(Graph<V, ?> graph, int width, int height) {
        this.graph = Objects.requireNonNull(graph);
        this.setSize(width, height);
    }

    @Override
    public void setInitialDimensionFunction(Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction) {
        this.initialDimensionFunction = initialDimensionFunction;
    }

    @Override
    public void stop() {
        if (this.visRunnable != null) {
            this.visRunnable.stop();
        }
        this.setRelaxing(false);
    }

    @Override
    public void accept(LayoutAlgorithm<V> layoutAlgorithm) {
        if (this.graph.vertexSet().isEmpty()) {
            return;
        }
        log.debug("accept {}", layoutAlgorithm);
        this.appendageCount = 0;
        if (this.visRunnable != null) {
            if (log.isTraceEnabled()) {
                log.trace("stopping {}", (Object)this.visRunnable);
            }
            this.visRunnable.stop();
        }
        if (log.isTraceEnabled()) {
            log.trace("{} is constrained: {}", layoutAlgorithm, (Object)layoutAlgorithm.constrained());
        }
        if (layoutAlgorithm.constrained()) {
            log.trace("{} constrained: {}", layoutAlgorithm, (Object)true);
            Pair<Integer> dimension = this.initialDimensionFunction.apply(this.graph);
            this.setSize((Integer)dimension.first, (Integer)dimension.second);
        }
        log.trace("reset the model size to {} x {}", (Object)this.preferredWidth, (Object)this.preferredHeight);
        this.layoutStateChangeSupport.fireLayoutStateChanged(this, true);
        this.layoutVertexPositionSupport.setFireEvents(true);
        this.modelChangeSupport.fireModelChanged();
        if (layoutAlgorithm != null) {
            layoutAlgorithm.visit(this);
            if (this.graph.vertexSet().size() > 0 && this.createVisRunnable && layoutAlgorithm instanceof IterativeLayoutAlgorithm) {
                this.setRelaxing(true);
                this.setupVisRunner((IterativeLayoutAlgorithm)layoutAlgorithm);
            } else if (!(layoutAlgorithm instanceof Threaded) || !((Threaded)((Object)layoutAlgorithm)).isThreaded()) {
                this.layoutStateChangeSupport.fireLayoutStateChanged(this, false);
            }
        }
    }

    @Override
    public LayoutStateChange.Support getLayoutStateChangeSupport() {
        return this.layoutStateChangeSupport;
    }

    @Override
    public ModelChange.Support getModelChangeSupport() {
        return this.modelChangeSupport;
    }

    @Override
    public ViewChange.Support getViewChangeSupport() {
        return this.viewChangeSupport;
    }

    protected void setupVisRunner(IterativeLayoutAlgorithm iterativeContext) {
        log.trace("this {} is setting up a visRunnable with {}", (Object)this, (Object)iterativeContext);
        if (this.visRunnable != null) {
            this.visRunnable.stop();
        }
        this.layoutStateChangeSupport.fireLayoutStateChanged(this, true);
        this.layoutVertexPositionSupport.setFireEvents(false);
        this.modelChangeSupport.setFireEvents(false);
        iterativeContext.preRelax();
        this.modelChangeSupport.setFireEvents(true);
        this.layoutVertexPositionSupport.setFireEvents(true);
        log.trace("prerelax is done");
        Executor executor = iterativeContext.getExecutor();
        this.visRunnable = new VisRunnable(iterativeContext);
        if (executor != null) {
            log.debug("start visRunner thread");
            CompletableFuture.runAsync(this.visRunnable, executor).thenRun(() -> {
                log.debug("We're done");
                this.setRelaxing(false);
                this.viewChangeSupport.fireViewChanged();
                this.layoutStateChangeSupport.fireLayoutStateChanged(this, false);
            });
        } else {
            log.debug("start visRunner thread");
            CompletableFuture.runAsync(this.visRunnable).thenRun(() -> {
                log.debug("We're done");
                this.setRelaxing(false);
                this.viewChangeSupport.fireViewChanged();
                this.layoutStateChangeSupport.fireLayoutStateChanged(this, false);
            });
        }
    }

    @Override
    public <E> Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph<V, ?> graph) {
        this.appendageCount = 0;
        this.graph = graph;
        this.modelChangeSupport.fireModelChanged();
        if (log.isTraceEnabled()) {
            log.trace("setGraph to n:{} e:{}", (Object)graph.vertexSet(), (Object)graph.edgeSet());
        }
    }

    @Override
    public void lock(V vertex, boolean locked) {
        if (locked) {
            this.lockedVertices.add(vertex);
        } else {
            this.lockedVertices.remove(vertex);
        }
    }

    @Override
    public boolean isLocked(V vertex) {
        return this.lockedVertices.contains(vertex);
    }

    @Override
    public void lock(boolean locked) {
        log.trace("lock:{}", (Object)locked);
        this.locked = locked;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setSize(int width, int height) {
        log.trace("setSize({} x {}), old values: {} x {}", new Object[]{width, height, this.width, this.height});
        if (width <= 0) {
            width = this.preferredWidth;
        }
        if (height <= 0) {
            height = this.preferredHeight;
        }
        this.width = width;
        this.height = height;
        this.layoutSizeChangeSupport.fireLayoutSizeChanged(this, width, height);
        log.trace("setSize to {} by {}", (Object)this.width, (Object)this.height);
    }

    @Override
    public void setPreferredSize(int preferredWidth, int preferredHeight) {
        log.trace("setPreferredSize({},{})", (Object)preferredWidth, (Object)preferredHeight);
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            throw new IllegalArgumentException("Can't be <= zeros " + preferredWidth + "/" + preferredHeight);
        }
        this.preferredWidth = preferredWidth;
        this.preferredHeight = preferredHeight;
    }

    public void setSize(int width, int height, boolean adjustLocations) {
        if (width == 0 || height == 0) {
            throw new IllegalArgumentException("Can't be zeros " + width + "/" + height);
        }
        int oldWidth = this.width;
        int oldHeight = this.height;
        if (oldWidth == width && oldHeight == height) {
            return;
        }
        if (oldWidth != 0 || oldHeight != 0 && adjustLocations) {
            this.adjustLocations(oldWidth, oldHeight, width, height);
        }
        this.width = width;
        this.height = height;
    }

    private void adjustLocations(int oldWidth, int oldHeight, int width, int height) {
        if (oldWidth == width && oldHeight == height) {
            return;
        }
        int xOffset = (width - oldWidth) / 2;
        int yOffset = (height - oldHeight) / 2;
        while (true) {
            try {
                for (Object vertex : this.graph.vertexSet()) {
                    this.offsetvertex(vertex, xOffset, yOffset);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public void set(V vertex, double x, double y) {
        this.set(vertex, Point.of(x, y));
    }

    @Override
    public void set(V vertex, Point location) {
        this.layoutVertexPositionSupport.fireLayoutVertexPositionChanged(vertex, location);
        this.viewChangeSupport.fireViewChanged();
    }

    protected void offsetvertex(V vertex, double xOffset, double yOffset) {
        if (!this.locked && !this.isLocked(vertex)) {
            Point p = this.get(vertex);
            this.set(vertex, p.x + xOffset, p.y + yOffset);
        }
    }

    @Override
    public LayoutVertexPositionChange.Support<V> getLayoutVertexPositionSupport() {
        return this.layoutVertexPositionSupport;
    }

    @Override
    public LayoutSizeChange.Support getLayoutSizeChangeSupport() {
        return this.layoutSizeChangeSupport;
    }

    @Override
    public boolean isRelaxing() {
        return this.relaxing;
    }

    @Override
    public void setRelaxing(boolean relaxing) {
        log.trace("setRelaxing:{}", (Object)relaxing);
        this.relaxing = relaxing;
    }

    @Override
    public void layoutVertexPositionChanged(LayoutVertexPositionChange.Event<V> evt) {
        this.visRunnable.stop();
    }

    @Override
    public void layoutVertexPositionChanged(LayoutVertexPositionChange.GraphEvent<V> evt) {
    }

    @Override
    public void resizeToSurroundingRectangle() {
        int vertexSpaceHeight;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (Point p : this.getLocations().values()) {
            if (p.x > (double)maxX) {
                maxX = (int)p.x;
            }
            if (p.x < (double)minX) {
                minX = (int)p.x;
            }
            if (p.y > (double)maxY) {
                maxY = (int)p.y;
            }
            if (!(p.y < (double)minY)) continue;
            minY = (int)p.y;
        }
        int vertexSpaceWidth = maxX - minX;
        if (vertexSpaceWidth <= 0) {
            vertexSpaceWidth = 100;
        }
        if ((vertexSpaceHeight = maxY - minY) <= 0) {
            vertexSpaceHeight = 100;
        }
        int paddingX = vertexSpaceWidth / 10;
        int paddingY = vertexSpaceHeight / 10;
        int dx = 0;
        int dy = 0;
        minY -= paddingY;
        if ((minX -= paddingX) != 0) {
            dx = -minX;
        }
        if (minY != 0) {
            dy = -minY;
        }
        maxX += paddingX;
        maxY += paddingY;
        if (dx != 0 || dy != 0) {
            for (Object v : this.getGraph().vertexSet()) {
                Point vp = ((Point)this.apply(v)).add(dx, dy);
                this.set(v, vp);
            }
        }
        int newWidth = maxX + dx;
        int newHeight = maxY + dy;
        this.setSize(newWidth, newHeight);
    }

    public String toString() {
        return "AbstractLayoutModel{hashCode=" + this.hashCode() + ", width=" + this.width + ", height=" + this.height + ", graph of size =" + this.graph.vertexSet().size() + "}";
    }

    @Override
    public void appendLayoutModel(LayoutModel<V> layoutModel) {
        if (log.isTraceEnabled()) {
            log.trace("appending layoutModel with width {} to this layoutModel width:{}", (Object)layoutModel.getWidth(), (Object)this.width);
        }
        if (this.appendageCount++ == 0) {
            int newWidth = layoutModel.getWidth();
            int newHeight = Math.max(this.height, layoutModel.getHeight());
            this.setSize(newWidth, newHeight);
            layoutModel.getLocations().keySet().stream().forEach(v -> this.set(v, layoutModel.get(v)));
        } else {
            int widthDelta = this.width;
            int newWidth = this.width + layoutModel.getWidth();
            int newHeight = Math.max(this.height, layoutModel.getHeight());
            this.setSize(newWidth, newHeight);
            layoutModel.getLocations().keySet().stream().forEach(v -> this.set(v, layoutModel.get(v).add(widthDelta, 0.0)));
        }
    }

    public static abstract class Builder<V, T extends AbstractLayoutModel<V>, B extends Builder<V, T, B>> {
        protected Graph<V, ?> graph;
        protected int width;
        protected int height;
        protected Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction = g -> Pair.of(this.width, this.height);
        protected boolean createVisRunnable = true;

        public B graph(Graph<V, ?> graph) {
            this.graph = graph;
            return (B)this;
        }

        public B size(int width, int height) {
            this.width = width;
            this.height = height;
            return (B)this;
        }

        public B width(int width) {
            this.width = width;
            return (B)this;
        }

        public B height(int height) {
            this.height = height;
            return (B)this;
        }

        public B initialDimensionFunction(Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction) {
            if (initialDimensionFunction != null) {
                this.initialDimensionFunction = initialDimensionFunction;
            }
            return (B)this;
        }

        public B createVisRunnable(boolean createVisRunnable) {
            this.createVisRunnable = createVisRunnable;
            return (B)this;
        }
    }
}

