/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit;

import ghidra.pcode.emu.jit.JitConfiguration;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.analysis.JitOpUseModel;
import ghidra.pcode.emu.jit.analysis.JitTypeModel;
import ghidra.pcode.emu.jit.analysis.JitVarScopeModel;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassageClass;
import java.lang.invoke.MethodHandles;
import java.util.EnumSet;

public class JitCompiler {
    public static final EnumSet<Diag> ENABLE_DIAGNOSTICS = EnumSet.noneOf(Diag.class);
    public static final long EXCLUDE_MAXS = -1L;
    private final JitConfiguration config;

    public JitCompiler(JitConfiguration config) {
        this.config = config;
    }

    public JitCompiledPassageClass compilePassage(MethodHandles.Lookup lookup, JitPassage passage) {
        if (ENABLE_DIAGNOSTICS.contains((Object)Diag.PRINT_PASSAGE)) {
            System.err.println(passage);
        }
        JitAnalysisContext context = new JitAnalysisContext(this.config, passage);
        JitControlFlowModel cfm = new JitControlFlowModel(context);
        if (ENABLE_DIAGNOSTICS.contains((Object)Diag.PRINT_CFM)) {
            cfm.dumpResult();
        }
        JitDataFlowModel dfm = new JitDataFlowModel(context, cfm);
        if (ENABLE_DIAGNOSTICS.contains((Object)Diag.PRINT_DFM)) {
            dfm.dumpResult();
        }
        JitVarScopeModel vsm = new JitVarScopeModel(cfm, dfm);
        if (ENABLE_DIAGNOSTICS.contains((Object)Diag.PRINT_VSM)) {
            vsm.dumpResult();
        }
        JitTypeModel tm = new JitTypeModel(dfm);
        JitAllocationModel am = new JitAllocationModel(context, dfm, vsm, tm);
        JitOpUseModel oum = new JitOpUseModel(context, cfm, dfm, vsm);
        if (ENABLE_DIAGNOSTICS.contains((Object)Diag.PRINT_SYNTH)) {
            dfm.dumpSynth();
        }
        if (ENABLE_DIAGNOSTICS.contains((Object)Diag.PRINT_OUM)) {
            oum.dumpResult();
        }
        JitCodeGenerator gen = new JitCodeGenerator(lookup, context, cfm, dfm, vsm, tm, am, oum);
        return gen.load();
    }

    public JitConfiguration getConfiguration() {
        return this.config;
    }

    public static enum Diag {
        PRINT_PASSAGE,
        PRINT_CFM,
        PRINT_DFM,
        PRINT_VSM,
        PRINT_SYNTH,
        PRINT_OUM,
        TRACE_CLASS,
        DUMP_CLASS;

    }
}

