/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.op.JitBranchIndOp;
import ghidra.pcode.emu.jit.op.JitBranchOp;
import ghidra.pcode.emu.jit.op.JitCBranchOp;
import ghidra.pcode.emu.jit.op.JitCallOtherMissingOp;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.pcode.emu.jit.var.JitFailVal;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.Map;
import java.util.Objects;

class JitDataFlowExecutor
extends PcodeExecutor<JitVal> {
    private final JitDataFlowModel dfm;
    private final Map<PcodeOp, JitPassage.PBranch> branches;

    protected JitDataFlowExecutor(JitAnalysisContext context, JitDataFlowModel dfm, PcodeExecutorState<JitVal> state) {
        super(context.getLanguage(), dfm.getArithmetic(), state, PcodeExecutorStatePiece.Reason.EXECUTE_READ);
        this.dfm = dfm;
        this.branches = context.getPassage().getBranches();
    }

    protected void recordBranch(PcodeOp op) {
        JitPassage.RBranch branch = (JitPassage.RBranch)Objects.requireNonNull(this.branches.get(op));
        this.dfm.notifyOp(new JitBranchOp(op, branch));
    }

    protected void recordConditionalBranch(PcodeOp op) {
        JitVal cond;
        JitPassage.RBranch branch = (JitPassage.RBranch)Objects.requireNonNull(this.branches.get(op));
        if (op instanceof JitPassage.ExitPcodeOp) {
            cond = JitFailVal.INSTANCE;
        } else {
            Varnode condVar = this.getConditionalBranchPredicate(op);
            cond = (JitVal)this.state.getVar(condVar, this.reason);
        }
        this.dfm.notifyOp(new JitCBranchOp(op, branch, cond));
    }

    protected void recordIndirectBranch(PcodeOp op) {
        Varnode offVar = this.getIndirectBranchTarget(op);
        JitVal offset = (JitVal)this.state.getVar(offVar, this.reason);
        JitPassage.RIndBranch branch = (JitPassage.RIndBranch)Objects.requireNonNull(this.branches.get(op));
        this.dfm.notifyOp(new JitBranchIndOp(op, offset, branch));
    }

    @Override
    public void executeBranch(PcodeOp op, PcodeFrame frame) {
        this.recordBranch(op);
    }

    @Override
    public void executeConditionalBranch(PcodeOp op, PcodeFrame frame) {
        this.recordConditionalBranch(op);
    }

    @Override
    public void executeIndirectBranch(PcodeOp op, PcodeFrame frame) {
        this.recordIndirectBranch(op);
    }

    @Override
    public void executeCall(PcodeOp op, PcodeFrame frame, PcodeUseropLibrary<JitVal> library) {
        this.recordBranch(op);
    }

    @Override
    public void executeIndirectCall(PcodeOp op, PcodeFrame frame) {
        this.recordIndirectBranch(op);
    }

    @Override
    public void executeReturn(PcodeOp op, PcodeFrame frame) {
        this.recordIndirectBranch(op);
    }

    @Override
    protected void badOp(PcodeOp op) {
        this.dfm.notifyOp(JitOp.stubOp(op));
    }

    @Override
    protected void onMissingUseropDef(PcodeOp op, PcodeFrame frame, String opName, PcodeUseropLibrary<JitVal> library) {
        this.dfm.notifyOp(new JitCallOtherMissingOp(op, opName));
    }
}

