/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.IntReadGen;
import ghidra.pcode.emu.jit.gen.type.LongReadGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitLoadOp;
import ghidra.program.model.lang.Endian;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum LoadOpGen implements OpGen<JitLoadOp>
{
    GEN;


    @Override
    public void generateInitCode(JitCodeGenerator gen, JitLoadOp op, MethodVisitor iv) {
        gen.requestFieldForSpaceIndirect(op.space());
    }

    private void generateConvMpIntRunCodeLegBE(int off, int size, MethodVisitor rv, boolean keepByteArr) {
        if (keepByteArr) {
            rv.visitInsn(89);
        }
        rv.visitLdcInsn((Object)off);
        rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, IntReadGen.BE.chooseName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_INTX, true);
        if (keepByteArr) {
            rv.visitInsn(95);
        }
    }

    private void generateConvMpIntRunCodeLegLE(int off, int size, MethodVisitor rv, boolean keepByteArr) {
        if (keepByteArr) {
            rv.visitInsn(89);
        }
        rv.visitLdcInsn((Object)off);
        rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, IntReadGen.LE.chooseName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_INTX, true);
        if (keepByteArr) {
            rv.visitInsn(95);
        }
    }

    private void generateConvIntRunCode(Endian endian, JitType.IntJitType type, MethodVisitor rv) {
        switch (endian) {
            case BIG: {
                this.generateConvMpIntRunCodeLegBE(0, type.size(), rv, false);
                break;
            }
            case LITTLE: {
                this.generateConvMpIntRunCodeLegLE(0, type.size(), rv, false);
            }
        }
    }

    static String chooseReadLongName(Endian endian, int size) {
        return switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> LongReadGen.BE.chooseName(size);
            case Endian.LITTLE -> LongReadGen.LE.chooseName(size);
        };
    }

    private void generateConvLongRunCode(Endian endian, JitType.LongJitType type, MethodVisitor rv) {
        rv.visitLdcInsn((Object)0);
        rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, LoadOpGen.chooseReadLongName(endian, type.size()), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true);
    }

    private void generateConvFloatRunCode(Endian endian, JitType.FloatJitType type, MethodVisitor rv) {
        this.generateConvIntRunCode(endian, JitType.IntJitType.I4, rv);
        TypeConversions.generateIntToFloat(JitType.IntJitType.I4, type, rv);
    }

    private void generateConvDoubleRunCode(Endian endian, JitType.DoubleJitType type, MethodVisitor rv) {
        this.generateConvLongRunCode(endian, JitType.LongJitType.I8, rv);
        TypeConversions.generateLongToDouble(JitType.LongJitType.I8, type, rv);
    }

    private void generateConvMpIntRunCodeBE(JitType.MpIntJitType type, MethodVisitor rv) {
        int countFull = type.legsWhole();
        int remSize = type.partialSize();
        int off = 0;
        if (remSize > 0) {
            this.generateConvMpIntRunCodeLegBE(off, remSize, rv, true);
            off += remSize;
        }
        for (int i = 0; i < countFull; ++i) {
            this.generateConvMpIntRunCodeLegBE(off, 4, rv, true);
            off += 4;
        }
        rv.visitInsn(87);
    }

    private void generateConvMpIntRunCodeLE(JitType.MpIntJitType type, MethodVisitor rv) {
        int countFull = type.legsWhole();
        int remSize = type.partialSize();
        int off = type.size();
        if (remSize > 0) {
            this.generateConvMpIntRunCodeLegLE(off -= remSize, remSize, rv, true);
        }
        for (int i = 0; i < countFull; ++i) {
            this.generateConvMpIntRunCodeLegLE(off -= 4, 4, rv, true);
        }
        rv.visitInsn(87);
    }

    private void generateConvMpIntRunCode(Endian endian, JitType.MpIntJitType type, MethodVisitor rv) {
        switch (endian) {
            case BIG: {
                this.generateConvMpIntRunCodeBE(type, rv);
                break;
            }
            case LITTLE: {
                this.generateConvMpIntRunCodeLE(type, rv);
            }
        }
    }

    @Override
    public void generateRunCode(JitCodeGenerator gen, JitLoadOp op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        JitType outType;
        gen.requestFieldForSpaceIndirect(op.space()).generateLoadCode(gen, rv);
        JitType offsetType = gen.generateValReadCode(op.offset(), op.offsetType());
        TypeConversions.generateToLong(offsetType, JitType.LongJitType.I8, rv);
        rv.visitLdcInsn((Object)op.out().size());
        rv.visitMethodInsn(182, GenConsts.NAME_JIT_BYTES_PCODE_EXECUTOR_STATE_SPACE, "read", GenConsts.MDESC_JIT_BYTES_PCODE_EXECUTOR_STATE_SPACE__READ, false);
        Endian endian = gen.getAnalysisContext().getEndian();
        JitType jitType = outType = gen.getTypeModel().typeOf(op.out());
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType iType = (JitType.IntJitType)jitType2;
                this.generateConvIntRunCode(endian, iType, rv);
                break;
            }
            case 1: {
                JitType.LongJitType lType = (JitType.LongJitType)jitType2;
                this.generateConvLongRunCode(endian, lType, rv);
                break;
            }
            case 2: {
                JitType.FloatJitType fType = (JitType.FloatJitType)jitType2;
                this.generateConvFloatRunCode(endian, fType, rv);
                break;
            }
            case 3: {
                JitType.DoubleJitType dType = (JitType.DoubleJitType)jitType2;
                this.generateConvDoubleRunCode(endian, dType, rv);
                break;
            }
            case 4: {
                JitType.MpIntJitType mpType = (JitType.MpIntJitType)jitType2;
                this.generateConvMpIntRunCode(endian, mpType, rv);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        gen.generateVarWriteCode(op.out(), outType);
    }
}

