/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.type;

import ghidra.pcode.emu.jit.gen.FieldForArrDirect;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.type.MethodAccessGen;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.Varnode;
import org.objectweb.asm.MethodVisitor;

public enum LongWriteGen implements MethodAccessGen
{
    BE{

        @Override
        public String chooseName(int size) {
            return switch (size) {
                case 1 -> "writeLong1";
                case 2 -> "writeLongBE2";
                case 3 -> "writeLongBE3";
                case 4 -> "writeLongBE4";
                case 5 -> "writeLongBE5";
                case 6 -> "writeLongBE6";
                case 7 -> "writeLongBE7";
                case 8 -> "writeLongBE8";
                default -> throw new AssertionError();
            };
        }

        @Override
        public void generateCode(JitCodeGenerator gen, Varnode vn, MethodVisitor rv) {
            long offset = vn.getOffset();
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int size = vn.getSize();
            AddressSpace space = vn.getAddress().getAddressSpace();
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                blkField.generateLoadCode(gen, rv);
                rv.visitLdcInsn((Object)off);
                rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true);
                return;
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            rv.visitInsn(92);
            rv.visitInsn(off + size - 4096);
            rv.visitInsn(125);
            blkField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)off);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true);
            nxtField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)0);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true);
        }
    }
    ,
    LE{

        @Override
        public String chooseName(int size) {
            return switch (size) {
                case 1 -> "writeLong1";
                case 2 -> "writeLongLE2";
                case 3 -> "writeLongLE3";
                case 4 -> "writeLongLE4";
                case 5 -> "writeLongLE5";
                case 6 -> "writeLongLE6";
                case 7 -> "writeLongLE7";
                case 8 -> "writeLongLE8";
                default -> throw new AssertionError();
            };
        }

        @Override
        public void generateCode(JitCodeGenerator gen, Varnode vn, MethodVisitor rv) {
            long offset = vn.getOffset();
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int size = vn.getSize();
            AddressSpace space = vn.getAddress().getAddressSpace();
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                blkField.generateLoadCode(gen, rv);
                rv.visitLdcInsn((Object)off);
                rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true);
                return;
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            rv.visitInsn(92);
            rv.visitLdcInsn((Object)(4096 - off));
            rv.visitInsn(125);
            nxtField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)0);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true);
            blkField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)off);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true);
        }
    };

}

